/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.tree.events.impl;

import com.intellij.lang.ASTNode;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.tree.events.TreeChange;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.pom.tree.events.impl.TreeChangeImpl;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeChangeEventImpl
implements TreeChangeEvent {
    private final Map<CompositeElement, TreeChangeImpl> myChangedElements = new LinkedHashMap<CompositeElement, TreeChangeImpl>();
    private final MultiMap<CompositeElement, TreeChangeImpl> myChangesByAllParents = MultiMap.createSet();
    private final PomModelAspect myAspect;
    private final FileElement myFileElement;

    public TreeChangeEventImpl(@NotNull PomModelAspect aspect, @NotNull FileElement treeElement) {
        this.myAspect = aspect;
        this.myFileElement = treeElement;
    }

    @Override
    @NotNull
    public FileElement getRootElement() {
        return this.myFileElement;
    }

    @Override
    @NotNull
    public ASTNode[] getChangedElements() {
        return this.myChangedElements.keySet().toArray(ASTNode.EMPTY_ARRAY);
    }

    @Override
    public TreeChange getChangesByElement(@NotNull ASTNode element) {
        return this.myChangedElements.get((CompositeElement)element);
    }

    public void addElementaryChange(@NotNull CompositeElement parent) {
        TreeChangeImpl existing = this.myChangedElements.get(parent);
        if (existing != null) {
            existing.clearCache();
        } else if (!this.integrateIntoExistingChanges(parent)) {
            this.mergeChange(new TreeChangeImpl(parent));
        }
    }

    private boolean integrateIntoExistingChanges(CompositeElement nextParent) {
        for (CompositeElement eachParent : JBIterable.generate((Object)nextParent, TreeElement::getTreeParent)) {
            CompositeElement superParent = eachParent.getTreeParent();
            TreeChangeImpl superChange = this.myChangedElements.get(superParent);
            if (superChange == null) continue;
            superChange.markChildChanged(eachParent, 0);
            return true;
        }
        return false;
    }

    private void mergeChange(TreeChangeImpl nextChange) {
        CompositeElement newParent = nextChange.getChangedParent();
        for (TreeChangeImpl descendant : new ArrayList(this.myChangesByAllParents.get((Object)newParent))) {
            TreeElement ancestorChild = TreeChangeEventImpl.findAncestorChild(newParent, descendant);
            if (ancestorChild != null) {
                nextChange.markChildChanged(ancestorChild, descendant.getLengthDelta());
            }
            this.unregisterChange(descendant);
        }
        this.registerChange(nextChange);
    }

    private void registerChange(TreeChangeImpl nextChange) {
        this.myChangedElements.put(nextChange.getChangedParent(), nextChange);
        for (CompositeElement eachParent : nextChange.getSuperParents()) {
            this.myChangesByAllParents.putValue((Object)eachParent, (Object)nextChange);
        }
    }

    private void unregisterChange(TreeChangeImpl change) {
        this.myChangedElements.remove(change.getChangedParent());
        for (CompositeElement superParent : change.getSuperParents()) {
            this.myChangesByAllParents.remove((Object)superParent, (Object)change);
        }
    }

    @Nullable
    private static TreeElement findAncestorChild(@NotNull CompositeElement ancestor, @NotNull TreeChangeImpl change) {
        List<CompositeElement> superParents = change.getSuperParents();
        int index = superParents.indexOf(ancestor);
        return index < 0 ? null : (index == 0 ? change.getChangedParent() : (TreeElement)superParents.get(index - 1));
    }

    @NotNull
    public PomModelAspect getAspect() {
        return this.myAspect;
    }

    public void merge(@NotNull PomChangeSet next) {
        for (TreeChangeImpl change : ((TreeChangeEventImpl)next).myChangedElements.values()) {
            TreeChangeImpl existing = this.myChangedElements.get(change.getChangedParent());
            if (existing != null) {
                existing.appendChanges(change);
                continue;
            }
            if (this.integrateIntoExistingChanges(change.getChangedParent())) continue;
            this.mergeChange(change);
        }
    }

    public void fireEvents() {
        List changes2 = ContainerUtil.sorted(this.myChangedElements.values());
        for (TreeChangeImpl change : changes2) {
            change.fireEvents((PsiFile)this.myFileElement.getPsi());
        }
    }

    public void beforeNestedTransaction() {
        for (TreeChangeImpl change : this.myChangedElements.values()) {
            change.getAffectedChildren();
        }
    }

    public String toString() {
        return new ArrayList<TreeChangeImpl>(this.myChangedElements.values()).toString();
    }
}

