/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.xml.impl;

import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.XmlChangeSet;
import com.intellij.pom.xml.events.XmlChange;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAspectChangeSetImpl
implements XmlChangeSet {
    private final PomModel myModel;
    private final List<XmlChange> myChanges = new ArrayList<XmlChange>();
    private final List<XmlFile> myChangedFiles = new ArrayList<XmlFile>();

    public XmlAspectChangeSetImpl(PomModel model) {
        this.myModel = model;
    }

    public XmlAspectChangeSetImpl(PomModel model, @Nullable XmlFile xmlFile) {
        this(model);
        if (xmlFile != null) {
            this.addChangedFile(xmlFile);
        }
    }

    public List<XmlChange> getChanges() {
        return Collections.unmodifiableList(this.myChanges);
    }

    @NotNull
    public PomModelAspect getAspect() {
        return this.myModel.getModelAspect(XmlAspect.class);
    }

    public void merge(@NotNull PomChangeSet blocked) {
        List<XmlChange> changes2 = ((XmlAspectChangeSetImpl)blocked).myChanges;
        for (XmlChange xmlChange : changes2) {
            this.add(xmlChange);
        }
    }

    public void add(XmlChange xmlChange) {
        this.myChanges.add(xmlChange);
    }

    public void clear() {
        this.myChanges.clear();
    }

    @NotNull
    public Iterable<XmlFile> getChangedFiles() {
        return this.myChangedFiles;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Iterator<XmlChange> iterator = this.myChanges.iterator();
        while (iterator.hasNext()) {
            XmlChange xmlChange = iterator.next();
            buffer.append("(");
            buffer.append(xmlChange);
            buffer.append(")");
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public void addChangedFile(@NotNull XmlFile xmlFile) {
        this.myChangedFiles.add(xmlFile);
    }
}

