/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.xml.impl;

import com.intellij.lang.ASTNode;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.ChangeInfo;
import com.intellij.pom.tree.events.TreeChange;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.pom.tree.events.impl.TreeChangeImpl;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.events.XmlChange;
import com.intellij.pom.xml.impl.XmlAspectChangeSetImpl;
import com.intellij.pom.xml.impl.events.XmlAttributeSetImpl;
import com.intellij.pom.xml.impl.events.XmlDocumentChangedImpl;
import com.intellij.pom.xml.impl.events.XmlElementChangedImpl;
import com.intellij.pom.xml.impl.events.XmlTagChildAddImpl;
import com.intellij.pom.xml.impl.events.XmlTagChildChangedImpl;
import com.intellij.pom.xml.impl.events.XmlTagChildRemovedImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class XmlAspectImpl
implements XmlAspect {
    private final PomModel myModel;
    private final TreeAspect myTreeAspect;

    public XmlAspectImpl(PomModel model, TreeAspect aspect) {
        this.myModel = model;
        this.myTreeAspect = aspect;
        this.myModel.registerAspect(XmlAspect.class, (PomModelAspect)this, Collections.singleton(this.myTreeAspect));
    }

    public void update(PomModelEvent event) {
        if (!event.getChangedAspects().contains(this.myTreeAspect)) {
            return;
        }
        TreeChangeEvent changeSet = (TreeChangeEvent)event.getChangeSet((PomModelAspect)this.myTreeAspect);
        if (changeSet == null) {
            return;
        }
        ASTNode rootElement = changeSet.getRootElement();
        PsiFile file2 = (PsiFile)rootElement.getPsi();
        if (!(file2 instanceof XmlFile)) {
            return;
        }
        final XmlAspectChangeSetImpl xmlChangeSet = (XmlAspectChangeSetImpl)event.registerChangeSetIfAbsent((PomModelAspect)this, (PomChangeSet)new XmlAspectChangeSetImpl(this.myModel));
        xmlChangeSet.addChangedFile((XmlFile)file2);
        ASTNode[] changedElements = changeSet.getChangedElements();
        final CharTable table = ((FileElement)changeSet.getRootElement()).getCharTable();
        for (ASTNode changedElement : changedElements) {
            PsiElement psiElement;
            TreeChangeImpl changesByElement = (TreeChangeImpl)changeSet.getChangesByElement(changedElement);
            while ((psiElement = changedElement.getPsi()) == null) {
                changesByElement = XmlAspectImpl.createChildrenChangedInfo(changedElement);
                changedElement = changesByElement.getChangedParent();
            }
            final TreeChangeImpl finalChangedElement = changesByElement;
            psiElement.accept((PsiElementVisitor)new XmlElementVisitor(){
                TreeChange myChange;
                {
                    this.myChange = finalChangedElement;
                }

                public void visitElement(PsiElement element) {
                    this.myChange = XmlAspectImpl.createChildrenChangedInfo(element.getNode());
                    element.getParent().accept((PsiElementVisitor)this);
                }

                public void visitXmlAttribute(XmlAttribute attribute) {
                    ASTNode[] affectedChildren = this.myChange.getAffectedChildren();
                    String oldName = null;
                    String oldValue = null;
                    for (ASTNode treeElement : affectedChildren) {
                        ChangeInfo changeByChild = this.myChange.getChangeByChild(treeElement);
                        int changeType = changeByChild.getChangeType();
                        if (treeElement.getElementType() == XmlTokenType.XML_NAME) {
                            if (changeType == 1) {
                                oldName = treeElement.getText();
                            } else if (changeType == 2) {
                                oldName = this.getReplacedNode(changeByChild).getText();
                            }
                        }
                        if (treeElement.getElementType() != XmlElementType.XML_ATTRIBUTE_VALUE) continue;
                        if (changeType == 1) {
                            oldValue = treeElement.getText();
                            continue;
                        }
                        if (changeType != 2) continue;
                        oldValue = this.getReplacedNode(changeByChild).getText();
                    }
                    if (oldName != null && !oldName.equals(attribute.getName())) {
                        xmlChangeSet.add((XmlChange)new XmlAttributeSetImpl(attribute.getParent(), oldName, null));
                        xmlChangeSet.add((XmlChange)new XmlAttributeSetImpl(attribute.getParent(), attribute.getName(), attribute.getValue()));
                    } else if (oldValue != null) {
                        xmlChangeSet.add((XmlChange)new XmlAttributeSetImpl(attribute.getParent(), attribute.getName(), attribute.getValue()));
                    } else {
                        xmlChangeSet.add((XmlChange)new XmlElementChangedImpl((XmlElement)attribute));
                    }
                }

                private TreeElement getReplacedNode(ChangeInfo info) {
                    return ((ChangeInfoImpl)info).getOldChild();
                }

                public void visitXmlTag(XmlTag tag) {
                    ASTNode[] affectedChildren;
                    for (ASTNode treeElement : affectedChildren = this.myChange.getAffectedChildren()) {
                        if (treeElement.getPsi() instanceof XmlTagChild) continue;
                        this.visitElement((PsiElement)tag);
                        return;
                    }
                    block7: for (ASTNode treeElement : affectedChildren) {
                        ChangeInfo changeByChild = this.myChange.getChangeByChild(treeElement);
                        int changeType = changeByChild.getChangeType();
                        IElementType type = treeElement.getElementType();
                        if (type == TokenType.WHITE_SPACE) continue;
                        PsiElement element = treeElement.getPsi();
                        switch (changeType) {
                            case 0: {
                                xmlChangeSet.add((XmlChange)new XmlTagChildAddImpl(tag, (XmlTagChild)element));
                                continue block7;
                            }
                            case 1: {
                                treeElement.putUserData(CharTable.CHAR_TABLE_KEY, (Object)table);
                                xmlChangeSet.add((XmlChange)new XmlTagChildRemovedImpl(tag, (XmlTagChild)element));
                                continue block7;
                            }
                            case 3: {
                                xmlChangeSet.add((XmlChange)new XmlTagChildChangedImpl(tag, (XmlTagChild)element));
                                continue block7;
                            }
                            case 2: {
                                PsiElement psi = this.getReplacedNode(changeByChild).getPsi();
                                if (!(psi instanceof XmlTagChild)) continue block7;
                                XmlTagChild replaced = (XmlTagChild)psi;
                                replaced.putUserData(CharTable.CHAR_TABLE_KEY, (Object)table);
                                xmlChangeSet.add((XmlChange)new XmlTagChildRemovedImpl(tag, replaced));
                                xmlChangeSet.add((XmlChange)new XmlTagChildAddImpl(tag, (XmlTagChild)element));
                            }
                        }
                    }
                }

                public void visitXmlDocument(XmlDocument document) {
                    xmlChangeSet.clear();
                    xmlChangeSet.add((XmlChange)new XmlDocumentChangedImpl(document));
                }

                public void visitFile(PsiFile file2) {
                    XmlDocument document = ((XmlFile)file2).getDocument();
                    if (document != null) {
                        xmlChangeSet.clear();
                        xmlChangeSet.add((XmlChange)new XmlDocumentChangedImpl(document));
                    }
                }
            });
        }
    }

    @NotNull
    private static TreeChangeImpl createChildrenChangedInfo(ASTNode changedElement) {
        ASTNode parent = changedElement.getTreeParent();
        TreeChangeImpl changesByElement = new TreeChangeImpl((CompositeElement)parent);
        changesByElement.markChildChanged((TreeElement)changedElement, 0);
        return changesByElement;
    }
}

