/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.util.JdomKt;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Supplier;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class InspectionProfileLoadUtil {
    private static String getProfileName(@NotNull Path file2, @NotNull Element element) {
        String name = null;
        for (Element option2 : element.getChildren("option")) {
            if (!"myName".equals(option2.getAttributeValue("name"))) continue;
            name = option2.getAttributeValue("value");
        }
        if (name == null) {
            name = element.getAttributeValue("profile_name");
        }
        return name != null ? name : FileUtilRt.getNameWithoutExtension((String)file2.getFileName().toString());
    }

    @NotNull
    public static InspectionProfileImpl load(@NotNull Path file2, @NotNull InspectionToolRegistrar registrar, @NotNull InspectionProfileManager profileManager) throws JDOMException, IOException, InvalidDataException {
        Element element = JdomKt.loadElement((Path)file2);
        String profileName = InspectionProfileLoadUtil.getProfileName(file2, element);
        return InspectionProfileLoadUtil.load(element, profileName, registrar, profileManager);
    }

    @NotNull
    public static InspectionProfileImpl load(@NotNull Element element, @NotNull String name, @NotNull Supplier<List<InspectionToolWrapper>> registrar, @NotNull InspectionProfileManager profileManager) throws JDOMException, IOException, InvalidDataException {
        InspectionProfileImpl profile2 = new InspectionProfileImpl(name, registrar, (BaseInspectionProfileManager)profileManager);
        Element profileElement = element.getChild("profile");
        if (profileElement != null) {
            element = profileElement;
        }
        profile2.readExternal(element);
        return profile2;
    }
}

