/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.SeverityUtil;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.SeverityEditorDialog;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.table.SeverityRenderer;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class LevelChooserAction
extends ComboBoxAction
implements DumbAware {
    private final SeverityRegistrar mySeverityRegistrar;
    private final boolean myIncludeDoNotShow;
    private HighlightSeverity myChosen = null;

    public LevelChooserAction(SeverityRegistrar severityRegistrar) {
        this(severityRegistrar, false);
    }

    public LevelChooserAction(SeverityRegistrar severityRegistrar, boolean includeDoNotShow) {
        this.mySeverityRegistrar = severityRegistrar;
        this.myIncludeDoNotShow = includeDoNotShow;
    }

    @NotNull
    public DefaultActionGroup createPopupActionGroup(JComponent anchor2) {
        DefaultActionGroup group = new DefaultActionGroup();
        for (HighlightSeverity severity : LevelChooserAction.getSeverities(this.mySeverityRegistrar, this.myIncludeDoNotShow)) {
            HighlightSeverityAction action = new HighlightSeverityAction(severity);
            if (this.myChosen == null) {
                this.setChosen(action.getSeverity());
            }
            group.add((AnAction)action);
        }
        group.addSeparator();
        group.add((AnAction)new DumbAwareAction(InspectionsBundle.message((String)"inspection.edit.severities.text", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project = e.getProject();
                if (project != null) {
                    SeverityEditorDialog.show(project, LevelChooserAction.this.myChosen, LevelChooserAction.this.mySeverityRegistrar, true, (Consumer<? super HighlightSeverity>)((Consumer)severity -> {
                        LevelChooserAction.this.setChosen((HighlightSeverity)severity);
                        LevelChooserAction.this.onChosen((HighlightSeverity)severity);
                    }));
                }
            }
        });
        return group;
    }

    public static List<HighlightSeverity> getSeverities(SeverityRegistrar severityRegistrar) {
        return LevelChooserAction.getSeverities(severityRegistrar, true);
    }

    public static List<HighlightSeverity> getSeverities(SeverityRegistrar severityRegistrar, boolean includeDoNotShow) {
        ArrayList<HighlightSeverity> severities = new ArrayList<HighlightSeverity>();
        for (SeverityRegistrar.SeverityBasedTextAttributes type : SeverityUtil.getRegisteredHighlightingInfoTypes(severityRegistrar)) {
            severities.add(type.getSeverity());
        }
        if (includeDoNotShow) {
            severities.add(HighlightSeverity.INFORMATION);
        }
        return severities;
    }

    protected abstract void onChosen(HighlightSeverity var1);

    public void setChosen(HighlightSeverity severity) {
        this.myChosen = severity;
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setText(SingleInspectionProfilePanel.renderSeverity(severity));
        templatePresentation.setIcon(SeverityRenderer.getIcon(HighlightDisplayLevel.find((HighlightSeverity)severity)));
    }

    private class HighlightSeverityAction
    extends DumbAwareAction {
        private final HighlightSeverity mySeverity;

        public HighlightSeverity getSeverity() {
            return this.mySeverity;
        }

        private HighlightSeverityAction(HighlightSeverity severity) {
            this.mySeverity = severity;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(SingleInspectionProfilePanel.renderSeverity(severity));
            presentation.setIcon(SeverityRenderer.getIcon(HighlightDisplayLevel.find((HighlightSeverity)severity)));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            HighlightSeverity severity = this.getSeverity();
            LevelChooserAction.this.setChosen(severity);
            LevelChooserAction.this.onChosen(severity);
        }
    }
}

