/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.ui.ScopesOrderDialog;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class ScopesChooser
extends ComboBoxAction
implements DumbAware {
    public static final String TITLE = "Select a Scope to Change Its Settings";
    private final List<Descriptor> myDefaultDescriptors;
    @NotNull
    private final InspectionProfileImpl myInspectionProfile;
    private final Project myProject;
    private final Set<String> myExcludedScopeNames;

    public ScopesChooser(List<Descriptor> defaultDescriptors, @NotNull InspectionProfileImpl inspectionProfile, @NotNull Project project, String[] excludedScopeNames) {
        this.myDefaultDescriptors = defaultDescriptors;
        this.myInspectionProfile = inspectionProfile;
        this.myProject = project;
        this.myExcludedScopeNames = excludedScopeNames == null ? Collections.emptySet() : ContainerUtil.newHashSet((Object[])excludedScopeNames);
        this.setPopupTitle(TITLE);
        this.getTemplatePresentation().setText("In All Scopes");
    }

    @NotNull
    public DefaultActionGroup createPopupActionGroup(final JComponent component) {
        DefaultActionGroup group = new DefaultActionGroup();
        ArrayList<NamedScope> predefinedScopes = new ArrayList<NamedScope>();
        ArrayList<NamedScope> customScopes = new ArrayList<NamedScope>();
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders((Project)this.myProject)) {
            Collections.addAll(customScopes, holder.getEditableScopes());
            predefinedScopes.addAll(holder.getPredefinedScopes());
        }
        predefinedScopes.remove(CustomScopesProviderEx.getAllScope());
        for (NamedScope predefinedScope : predefinedScopes) {
            if (!(predefinedScope instanceof NonProjectFilesScope)) continue;
            predefinedScopes.remove(predefinedScope);
            break;
        }
        this.fillActionGroup(group, predefinedScopes, this.myDefaultDescriptors, this.myInspectionProfile, this.myExcludedScopeNames);
        group.addSeparator();
        this.fillActionGroup(group, customScopes, this.myDefaultDescriptors, this.myInspectionProfile, this.myExcludedScopeNames);
        group.addSeparator();
        group.add((AnAction)new DumbAwareAction("Edit Scopes Order..."){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ScopesOrderDialog dlg = new ScopesOrderDialog(component, ScopesChooser.this.myInspectionProfile, ScopesChooser.this.myProject);
                if (dlg.showAndGet()) {
                    ScopesChooser.this.onScopesOrderChanged();
                }
            }
        });
        return group;
    }

    protected abstract void onScopesOrderChanged();

    protected abstract void onScopeAdded(@NotNull String var1);

    private void fillActionGroup(DefaultActionGroup group, List<NamedScope> scopes, final List<Descriptor> defaultDescriptors, final InspectionProfileImpl inspectionProfile, Set<String> excludedScopeNames) {
        for (final NamedScope scope : scopes) {
            final String scopeName = scope.getName();
            if (excludedScopeNames.contains(scopeName)) continue;
            group.add((AnAction)new DumbAwareAction(scopeName){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    for (Descriptor defaultDescriptor : defaultDescriptors) {
                        InspectionToolWrapper wrapper2 = defaultDescriptor.getToolWrapper().createCopy();
                        wrapper2.getTool().readSettings(Descriptor.createConfigElement(defaultDescriptor.getToolWrapper()));
                        inspectionProfile.addScope(wrapper2, scope, defaultDescriptor.getLevel(), true, e.getProject());
                    }
                    ScopesChooser.this.onScopeAdded(scopeName);
                }
            });
        }
    }
}

