/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.header.InspectionProfileSchemesPanel;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class InspectionProfileSchemesModel
implements SchemesModel<InspectionProfileModifiableModel> {
    private static final Logger LOG = Logger.getInstance(InspectionProfileSchemesModel.class);
    private final List<SingleInspectionProfilePanel> myProfilePanels = new ArrayList<SingleInspectionProfilePanel>();
    private final List<InspectionProfileImpl> myDeletedProfiles = new SmartList();
    private final InspectionProfileManager myApplicationProfileManager;
    private final InspectionProfileManager myProjectProfileManager;

    InspectionProfileSchemesModel(@NotNull InspectionProfileManager appProfileManager, @NotNull InspectionProfileManager projectProfileManager) {
        this.myApplicationProfileManager = appProfileManager;
        this.myProjectProfileManager = projectProfileManager;
    }

    @Override
    public boolean canDuplicateScheme(@NotNull InspectionProfileModifiableModel profile2) {
        return true;
    }

    @Override
    public boolean canResetScheme(@NotNull InspectionProfileModifiableModel profile2) {
        return true;
    }

    @Override
    public boolean canDeleteScheme(@NotNull InspectionProfileModifiableModel candidateToDelete) {
        boolean isProjectProfile;
        SingleInspectionProfilePanel profilePanel;
        InspectionProfileModifiableModel profile2;
        boolean projectProfileFound = false;
        boolean ideProfileFound = false;
        Iterator<SingleInspectionProfilePanel> iterator = this.myProfilePanels.iterator();
        while (!(!iterator.hasNext() || candidateToDelete != (profile2 = (profilePanel = iterator.next()).getProfile()) && (ideProfileFound |= !(isProjectProfile = profile2.getProfileManager() == this.myProjectProfileManager)) && (projectProfileFound |= isProjectProfile))) {
        }
        return candidateToDelete.getProfileManager() == this.myProjectProfileManager ? projectProfileFound : ideProfileFound;
    }

    @Override
    public boolean isProjectScheme(@NotNull InspectionProfileModifiableModel profile2) {
        return profile2.isProjectLevel();
    }

    @Override
    public boolean canRenameScheme(@NotNull InspectionProfileModifiableModel profile2) {
        return true;
    }

    @Override
    public boolean containsScheme(@NotNull String name, boolean isProjectProfile) {
        return this.hasName(name, isProjectProfile);
    }

    @Override
    public boolean differsFromDefault(@NotNull InspectionProfileModifiableModel profile2) {
        return this.getProfilePanel(profile2).differsFromDefault();
    }

    @Override
    public void removeScheme(@NotNull InspectionProfileModifiableModel profile2) {
        SingleInspectionProfilePanel panel2 = this.getProfilePanel(profile2);
        this.removeProfile(profile2);
        this.myDeletedProfiles.add(profile2);
        this.onProfileRemoved(panel2);
    }

    protected abstract void onProfileRemoved(@NotNull SingleInspectionProfilePanel var1);

    void addProfile(@NotNull InspectionProfileModifiableModel profile2) {
        this.myProfilePanels.add(this.createPanel(profile2));
    }

    private void removeProfile(@NotNull InspectionProfileImpl profile2) {
        for (SingleInspectionProfilePanel panel2 : this.myProfilePanels) {
            if (!panel2.getProfile().equals(profile2)) continue;
            this.myProfilePanels.remove(panel2);
            break;
        }
    }

    void updatePanel(@NotNull InspectionProfileSchemesPanel panel2) {
        List allProfiles = ContainerUtil.map(this.myProfilePanels, p -> p.getProfile());
        panel2.resetSchemes(allProfiles);
    }

    void apply(InspectionProfileModifiableModel selected, Consumer<? super InspectionProfileImpl> applyRootProfileAction) {
        for (InspectionProfileImpl profile2 : this.myDeletedProfiles) {
            profile2.getProfileManager().deleteProfile(profile2);
        }
        this.myDeletedProfiles.clear();
        SingleInspectionProfilePanel selectedPanel = this.getProfilePanel(selected);
        for (SingleInspectionProfilePanel panel2 : this.getProfilePanels()) {
            panel2.apply();
            if (panel2 != selectedPanel) continue;
            applyRootProfileAction.consume((Object)panel2.getProfile());
        }
    }

    void reset() {
        this.disposeUI();
        this.myDeletedProfiles.clear();
        InspectionProfileSchemesModel.getSortedProfiles(this.myApplicationProfileManager, this.myProjectProfileManager).stream().map(source -> {
            try {
                return new InspectionProfileModifiableModel((InspectionProfileImpl)source);
            }
            catch (Exception e) {
                LOG.error("'" + source.getName() + "' profile is corrupted (project profile = " + source.isProjectLevel() + ")", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).forEach(this::addProfile);
    }

    void disposeUI() {
        for (SingleInspectionProfilePanel panel2 : this.myProfilePanels) {
            panel2.disposeUI();
        }
        this.myProfilePanels.clear();
    }

    SingleInspectionProfilePanel getProfilePanel(InspectionProfileImpl profile2) {
        return this.myProfilePanels.stream().filter(panel2 -> panel2.getProfile().equals(profile2)).findFirst().orElse(null);
    }

    @NotNull
    protected abstract SingleInspectionProfilePanel createPanel(@NotNull InspectionProfileModifiableModel var1);

    private boolean hasName(@NotNull String name, boolean shared) {
        boolean hasName = this.myProfilePanels.stream().map(SingleInspectionProfilePanel::getProfile).anyMatch(p -> name.equals(p.getName()) && p.isProjectLevel() == shared);
        if (hasName) {
            return true;
        }
        return this.myProfilePanels.stream().anyMatch(p -> {
            InspectionProfileModifiableModel profile2 = p.getProfile();
            return name.equals(profile2.getName()) && profile2.isProjectLevel() == shared;
        });
    }

    @NotNull
    List<SingleInspectionProfilePanel> getProfilePanels() {
        return this.myProfilePanels;
    }

    int getSize() {
        return this.myProfilePanels.size();
    }

    boolean hasDeletedProfiles() {
        return !this.myDeletedProfiles.isEmpty();
    }

    @NotNull
    InspectionProfileModifiableModel getModifiableModelFor(@NotNull InspectionProfileImpl profile2) {
        if (profile2 instanceof InspectionProfileModifiableModel) {
            return (InspectionProfileModifiableModel)profile2;
        }
        for (SingleInspectionProfilePanel panel2 : this.myProfilePanels) {
            InspectionProfileModifiableModel modifiableModel = panel2.getProfile();
            if (!modifiableModel.getSource().equals(profile2)) continue;
            return modifiableModel;
        }
        throw new AssertionError((Object)("profile " + profile2.getName() + " is not present among profile panels" + Arrays.toString(this.myProfilePanels.stream().map(p -> p.getProfile().getName()).toArray(String[]::new))));
    }

    @NotNull
    public static List<InspectionProfileImpl> getSortedProfiles(@NotNull InspectionProfileManager appManager, @NotNull InspectionProfileManager projectManager) {
        return ContainerUtil.notNullize((List)ContainerUtil.concat((List)ContainerUtil.sorted(appManager.getProfiles()), (List)ContainerUtil.sorted(projectManager.getProfiles())));
    }
}

