/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.application.options.schemes.AbstractDescriptionAwareSchemesPanel;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.DescriptionAwareSchemeActions;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.header.InspectionProfileSchemesModel;
import com.intellij.profile.codeInspection.ui.header.InspectionToolsConfigurable;
import com.intellij.util.Consumer;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionProfileSchemesPanel
extends AbstractDescriptionAwareSchemesPanel<InspectionProfileModifiableModel> {
    private static final Logger LOG = Logger.getInstance(InspectionProfileSchemesPanel.class);
    private final Project myProject;
    private final BaseInspectionProfileManager myAppProfileManager;
    private final BaseInspectionProfileManager myProjectProfileManager;
    private final InspectionToolsConfigurable myConfigurable;
    private final InspectionProfileSchemesModel myModel;

    InspectionProfileSchemesPanel(@NotNull Project project, @NotNull BaseInspectionProfileManager appProfileManager, @NotNull BaseInspectionProfileManager projectProfileManager, @NotNull InspectionToolsConfigurable configurable) {
        this.myProject = project;
        this.myAppProfileManager = appProfileManager;
        this.myProjectProfileManager = projectProfileManager;
        this.myConfigurable = configurable;
        this.myModel = new InspectionProfileSchemesModel(appProfileManager, projectProfileManager){

            @Override
            protected void onProfileRemoved(@NotNull SingleInspectionProfilePanel profilePanel) {
                InspectionProfileSchemesPanel.this.myConfigurable.removeProfilePanel(profilePanel);
                List currentProfiles = ContainerUtil.map(InspectionProfileSchemesPanel.this.getModel().getProfilePanels(), SingleInspectionProfilePanel::getProfile);
                InspectionProfileSchemesPanel.this.resetSchemes(currentProfiles);
                InspectionProfileSchemesPanel.this.selectScheme((Scheme)ContainerUtil.getFirstItem((List)currentProfiles));
            }

            @Override
            @NotNull
            protected SingleInspectionProfilePanel createPanel(@NotNull InspectionProfileModifiableModel model) {
                return InspectionProfileSchemesPanel.this.myConfigurable.createPanel(model);
            }
        };
    }

    @NotNull
    public InspectionProfileSchemesModel getModel() {
        return this.myModel;
    }

    @Override
    protected boolean supportsProjectSchemes() {
        return true;
    }

    @Override
    protected boolean highlightNonDefaultSchemes() {
        return false;
    }

    @Override
    public boolean useBoldForNonRemovableSchemes() {
        return false;
    }

    @Override
    protected boolean hideDeleteActionIfUnavailable() {
        return false;
    }

    @Override
    @NotNull
    protected AbstractSchemeActions<InspectionProfileModifiableModel> createSchemeActions() {
        return new DescriptionAwareSchemeActions<InspectionProfileModifiableModel>((AbstractDescriptionAwareSchemesPanel)this){

            @Override
            @Nullable
            public String getDescription(@NotNull InspectionProfileModifiableModel scheme2) {
                SingleInspectionProfilePanel inspectionProfile = ((InspectionProfileSchemesModel)this.getModel()).getProfilePanel(scheme2);
                return inspectionProfile == null ? null : inspectionProfile.getProfile().getDescription();
            }

            @Override
            protected void setDescription(@NotNull InspectionProfileModifiableModel scheme2, @NotNull String newDescription) {
                InspectionProfileModifiableModel inspectionProfile = InspectionProfileSchemesPanel.this.getModel().getProfilePanel(scheme2).getProfile();
                if (!Comparing.strEqual((String)newDescription, (String)inspectionProfile.getDescription())) {
                    inspectionProfile.setDescription(newDescription);
                    inspectionProfile.setModified(true);
                }
            }

            @Override
            protected void importScheme(@NotNull String importerName) {
                FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

                    public boolean isFileSelectable(VirtualFile file2) {
                        return file2.getFileType().equals(StdFileTypes.XML);
                    }
                };
                descriptor.setDescription("Choose profile file");
                FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)InspectionProfileSchemesPanel.this.myProject, null, file2 -> {
                    if (file2 != null) {
                        try {
                            InspectionProfileImpl profile2 = InspectionProfileSchemesPanel.importInspectionProfile(JdomKt.loadElement((InputStream)file2.getInputStream()), InspectionProfileSchemesPanel.this.myAppProfileManager, InspectionProfileSchemesPanel.this.myProject);
                            if (profile2 == null) {
                                Messages.showErrorDialog((Project)InspectionProfileSchemesPanel.this.myProject, (String)("File '" + file2.getName() + "' has invalid format."), (String)"Inspection Settings");
                                return;
                            }
                            SingleInspectionProfilePanel existed = InspectionProfileSchemesPanel.this.getModel().getProfilePanel(profile2);
                            if (existed != null) {
                                if (Messages.showOkCancelDialog((Project)InspectionProfileSchemesPanel.this.myProject, (String)("Profile with name '" + profile2.getName() + "' already exists. Do you want to overwrite it?"), (String)"Overwrite Warning", (String)"Overwrite", (String)"Cancel", (Icon)Messages.getInformationIcon()) != 0) {
                                    return;
                                }
                                this.getModel().removeScheme(existed.getProfile());
                            }
                            InspectionProfileModifiableModel model = new InspectionProfileModifiableModel(profile2);
                            model.setModified(true);
                            InspectionProfileSchemesPanel.this.addProfile(model);
                            InspectionProfileSchemesPanel.this.selectScheme(model);
                        }
                        catch (InvalidDataException | IOException | JDOMException e) {
                            LOG.error(e);
                        }
                    }
                });
            }

            @Override
            protected void resetScheme(@NotNull InspectionProfileModifiableModel scheme2) {
                SingleInspectionProfilePanel panel2 = InspectionProfileSchemesPanel.this.getModel().getProfilePanel(scheme2);
                panel2.performProfileReset();
            }

            @Override
            protected void duplicateScheme(@NotNull InspectionProfileModifiableModel scheme2, @NotNull String newName) {
                InspectionProfileModifiableModel newProfile = InspectionProfileSchemesPanel.this.copyToNewProfile(scheme2, InspectionProfileSchemesPanel.this.myProject, newName, false);
                InspectionProfileSchemesPanel.this.addProfile(newProfile);
                InspectionProfileSchemesPanel.this.myConfigurable.selectProfile(newProfile);
                InspectionProfileSchemesPanel.this.selectScheme(newProfile);
            }

            @Override
            protected void onSchemeChanged(@Nullable InspectionProfileModifiableModel scheme2) {
                super.onSchemeChanged(scheme2);
                if (scheme2 != null) {
                    InspectionProfileSchemesPanel.this.myConfigurable.selectProfile(scheme2);
                }
            }

            @Override
            protected void renameScheme(@NotNull InspectionProfileModifiableModel scheme2, @NotNull String newName) {
                scheme2.setName(newName);
            }

            @Override
            protected void copyToProject(@NotNull InspectionProfileModifiableModel scheme2) {
                this.copyToAnotherLevel(scheme2, true);
            }

            @Override
            protected void copyToIDE(@NotNull InspectionProfileModifiableModel scheme2) {
                this.copyToAnotherLevel(scheme2, false);
            }

            @Override
            @NotNull
            protected Class<InspectionProfileModifiableModel> getSchemeType() {
                return InspectionProfileModifiableModel.class;
            }

            private void copyToAnotherLevel(@NotNull InspectionProfileModifiableModel profile2, boolean copyToProject) {
                this.getSchemesPanel().editNewSchemeName(profile2.getName(), copyToProject, newName -> {
                    InspectionProfileModifiableModel newProfile = InspectionProfileSchemesPanel.this.copyToNewProfile(profile2, InspectionProfileSchemesPanel.this.myProject, newName, true);
                    InspectionProfileSchemesPanel.this.addProfile(newProfile);
                    InspectionProfileSchemesPanel.this.selectScheme(newProfile);
                });
            }
        };
    }

    @Override
    @NotNull
    protected String getSchemeTypeName() {
        return "Profile";
    }

    void apply() {
        this.getModel().apply((InspectionProfileModifiableModel)this.getSelectedScheme(), (Consumer<? super InspectionProfileImpl>)((Consumer)p -> {
            if (this.myConfigurable.setActiveProfileAsDefaultOnApply()) {
                this.myConfigurable.applyRootProfile(p.getName(), p.isProjectLevel());
            }
        }));
    }

    void reset() {
        this.getModel().reset();
        this.getModel().updatePanel(this);
    }

    @NotNull
    private InspectionProfileModifiableModel copyToNewProfile(@NotNull InspectionProfileImpl selectedProfile, @NotNull Project project, @NotNull String newName, boolean modifyLevel) {
        boolean isProjectLevel = selectedProfile.isProjectLevel() ^ modifyLevel;
        BaseInspectionProfileManager profileManager = isProjectLevel ? this.myProjectProfileManager : this.myAppProfileManager;
        InspectionProfileImpl inspectionProfile = new InspectionProfileImpl(newName, (Supplier<List<InspectionToolWrapper>>)InspectionToolRegistrar.getInstance(), profileManager);
        inspectionProfile.copyFrom(selectedProfile);
        inspectionProfile.setName(newName);
        inspectionProfile.initInspectionTools(project);
        inspectionProfile.setProjectLevel(isProjectLevel);
        InspectionProfileModifiableModel modifiableModel = new InspectionProfileModifiableModel(inspectionProfile);
        modifiableModel.setModified(true);
        return modifiableModel;
    }

    private void addProfile(@NotNull InspectionProfileModifiableModel profile2) {
        InspectionProfileModifiableModel selected = (InspectionProfileModifiableModel)this.getSelectedScheme();
        this.getModel().addProfile(profile2);
        this.getModel().updatePanel(this);
        this.selectScheme(selected);
    }

    @Override
    @NotNull
    protected JComponent getConfigurableFocusComponent() {
        return this.myConfigurable.getPreferredFocusedComponent();
    }

    public void selectAnyProfile() {
        List<SingleInspectionProfilePanel> panels = this.myModel.getProfilePanels();
        if (panels.isEmpty()) {
            LOG.error("No profiles to select.");
            return;
        }
        this.selectScheme(panels.get(0).getProfile());
        if (this.getSelectedScheme() == null) {
            LOG.error("Selected scheme is still null.");
        }
    }

    @Nullable(value="returns null if xml has invalid format")
    public static InspectionProfileImpl importInspectionProfile(@NotNull Element rootElement, @NotNull BaseInspectionProfileManager profileManager, @NotNull Project project) {
        String profileName;
        if (Comparing.strEqual((String)rootElement.getName(), (String)"component")) {
            rootElement = (Element)rootElement.getChildren().get(0);
        }
        if ((profileName = InspectionProfileSchemesPanel.getProfileName(rootElement)) == null) {
            return null;
        }
        InspectionProfileImpl profile2 = new InspectionProfileImpl(profileName, (Supplier<List<InspectionToolWrapper>>)InspectionToolRegistrar.getInstance(), profileManager);
        HashSet<String> levels = new HashSet<String>();
        for (Element inspectElement : rootElement.getChildren("inspection_tool")) {
            ContainerUtil.addAllNotNull(levels, (Object[])new String[]{inspectElement.getAttributeValue("level")});
            for (Element s : inspectElement.getChildren("scope")) {
                ContainerUtil.addAllNotNull(levels, (Object[])new String[]{s.getAttributeValue("level")});
            }
        }
        levels.removeIf(level -> profileManager.getSeverityRegistrar().getSeverity((String)level) != null);
        if (!levels.isEmpty()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                if (Messages.showYesNoDialog((Project)project, (String)("Undefined severities detected: " + StringUtil.join(levels, (String)", ") + ". Do you want to create them?"), (String)"Warning", (Icon)Messages.getWarningIcon()) == 0) {
                    for (String level2 : levels) {
                        TextAttributes textAttributes = CodeInsightColors.WARNINGS_ATTRIBUTES.getDefaultAttributes();
                        HighlightInfoType.HighlightInfoTypeImpl info = new HighlightInfoType.HighlightInfoTypeImpl(new HighlightSeverity(level2, 50), TextAttributesKey.createTextAttributesKey((String)level2));
                        profileManager.getSeverityRegistrar().registerSeverity(new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes.clone(), info), textAttributes.getErrorStripeColor());
                    }
                }
            } else {
                throw new AssertionError((Object)("All of levels must exist in unit-test mode, but actual not exist levels = " + levels));
            }
        }
        profile2.readExternal(rootElement);
        profile2.setProjectLevel(false);
        profile2.initInspectionTools(project);
        return profile2;
    }

    private static String getProfileName(@NotNull Element rootElement) {
        for (Element option2 : rootElement.getChildren("option")) {
            String optionName = option2.getAttributeValue("name");
            if (!"myName".equals(optionName)) continue;
            return option2.getAttributeValue("value");
        }
        return null;
    }
}

