/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.inspectionsTree;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Getter;
import com.intellij.profile.codeInspection.ui.ToolDescriptors;
import com.intellij.util.containers.Queue;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.IntStream;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionConfigTreeNode
extends DefaultMutableTreeNode {
    private final ClearableLazyValue<Boolean> myProperSetting = ClearableLazyValue.create(this::calculateIsProperSettings);

    public final boolean isProperSetting() {
        return (Boolean)this.myProperSetting.getValue();
    }

    public final void dropCache() {
        this.myProperSetting.drop();
    }

    protected abstract boolean calculateIsProperSettings();

    @NotNull
    public abstract String getText();

    @Override
    public String toString() {
        Object userObject = this.getUserObject();
        if (userObject instanceof ToolDescriptors) {
            return ((ToolDescriptors)userObject).getDefaultDescriptor().getText();
        }
        if (userObject instanceof Descriptor) {
            return ((Descriptor)userObject).getText();
        }
        return super.toString();
    }

    public static void updateUpHierarchy(@NotNull InspectionConfigTreeNode node) {
        InspectionConfigTreeNode.updateUpHierarchy(Collections.singletonList(node));
    }

    public static void updateUpHierarchy(Collection<? extends InspectionConfigTreeNode> nodes) {
        Queue q = new Queue(nodes.size());
        THashSet alreadyUpdated = new THashSet();
        for (InspectionConfigTreeNode inspectionConfigTreeNode : nodes) {
            q.addLast((Object)inspectionConfigTreeNode);
        }
        while (!q.isEmpty()) {
            InspectionConfigTreeNode inspectionConfigTreeNode = (InspectionConfigTreeNode)q.pullFirst();
            if (!alreadyUpdated.add(inspectionConfigTreeNode)) continue;
            inspectionConfigTreeNode.dropCache();
            TreeNode treeNode = inspectionConfigTreeNode.getParent();
            if (treeNode == null || treeNode.getParent() == null) continue;
            q.addLast((Object)((InspectionConfigTreeNode)treeNode));
        }
    }

    public static class Tool
    extends InspectionConfigTreeNode {
        private final Getter<ToolDescriptors> myGetter;

        public Tool(Getter<ToolDescriptors> getter) {
            this.myGetter = getter;
        }

        @Override
        public Object getUserObject() {
            return this.myGetter.get();
        }

        @Override
        protected boolean calculateIsProperSettings() {
            Descriptor defaultDescriptor = this.getDescriptors().getDefaultDescriptor();
            return defaultDescriptor.getInspectionProfile().isProperSetting(defaultDescriptor.getToolWrapper().getShortName());
        }

        @Override
        @NotNull
        public String getText() {
            return this.getDefaultDescriptor().getText();
        }

        public HighlightDisplayKey getKey() {
            return this.getDefaultDescriptor().getKey();
        }

        @NotNull
        public Descriptor getDefaultDescriptor() {
            return this.getDescriptors().getDefaultDescriptor();
        }

        @NotNull
        public ToolDescriptors getDescriptors() {
            return (ToolDescriptors)this.getUserObject();
        }

        @Nullable
        public String getScopeName() {
            return this.getDescriptors().getDefaultScopeToolState().getScopeName();
        }
    }

    public static class Group
    extends InspectionConfigTreeNode {
        public Group(@NotNull String label2) {
            this.setUserObject(label2);
        }

        @Override
        protected boolean calculateIsProperSettings() {
            return IntStream.range(0, this.getChildCount()).mapToObj(i -> (InspectionConfigTreeNode)this.getChildAt(i)).anyMatch(InspectionConfigTreeNode::isProperSetting);
        }

        @Override
        @NotNull
        public String getText() {
            return this.getGroupName();
        }

        @NotNull
        public String getGroupName() {
            return (String)this.getUserObject();
        }
    }
}

