/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.table;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.SeverityEditorDialog;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.table.ScopesAndSeveritiesTable;
import com.intellij.util.Consumer;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JTable;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class SeverityRenderer
extends ComboBoxTableRenderer<HighlightSeverity> {
    static final HighlightSeverity EDIT_SEVERITIES = new HighlightSeverity(InspectionsBundle.message((String)"inspection.edit.severities.text", (Object[])new Object[0]), -1);
    @NotNull
    private final Runnable myOnClose;
    private final ScopesAndSeveritiesTable myTable;
    @NotNull
    private final Icon myDisabledIcon;
    @NotNull
    private final Project myProject;

    public SeverityRenderer(@NotNull InspectionProfileImpl inspectionProfile, @NotNull Project project, @NotNull Runnable onClose, @NotNull ScopesAndSeveritiesTable table) {
        super((Object[])SeverityRenderer.getSeverities(inspectionProfile));
        this.myOnClose = onClose;
        this.myTable = table;
        this.myDisabledIcon = HighlightDisplayLevel.createIconByMask((Color)UIUtil.getLabelDisabledForeground());
        this.myProject = project;
    }

    @NotNull
    public static HighlightSeverity[] getSeverities(InspectionProfileImpl inspectionProfile) {
        Stream severities = LevelChooserAction.getSeverities(inspectionProfile.getProfileManager().getSeverityRegistrar()).stream();
        return (HighlightSeverity[])StreamEx.of(severities).append((Object)EDIT_SEVERITIES).toArray(HighlightSeverity.class);
    }

    public static Icon getIcon(@NotNull HighlightDisplayLevel level) {
        Icon icon = level.getIcon();
        return icon instanceof HighlightDisplayLevel.ColoredIcon ? new ColorIcon(icon.getIconWidth(), ((HighlightDisplayLevel.ColoredIcon)icon).getColor()) : icon;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row2, column);
        component.setEnabled(((ScopesAndSeveritiesTable)((Object)table)).isRowEnabled(row2));
        return component;
    }

    protected void customizeComponent(HighlightSeverity value, JTable table, boolean isSelected) {
        super.customizeComponent((Object)value, table, isSelected);
        this.setDisabledIcon(this.myDisabledIcon);
    }

    protected String getTextFor(@NotNull HighlightSeverity value) {
        return SingleInspectionProfilePanel.renderSeverity(value);
    }

    protected Icon getIconFor(@NotNull HighlightSeverity value) {
        return value == EDIT_SEVERITIES ? EmptyIcon.create((int)HighlightDisplayLevel.getEmptyIconDim()) : SeverityRenderer.getIcon(HighlightDisplayLevel.find((HighlightSeverity)value));
    }

    public boolean isCellEditable(EventObject event) {
        return !(event instanceof MouseEvent) || ((MouseEvent)event).getClickCount() >= 1;
    }

    protected ListSeparator getSeparatorAbove(HighlightSeverity value) {
        return value == EDIT_SEVERITIES ? new ListSeparator() : null;
    }

    public void onClosed(@NotNull LightweightWindowEvent event) {
        super.onClosed(event);
        this.myOnClose.run();
        if (this.getCellEditorValue() == EDIT_SEVERITIES) {
            ApplicationManager.getApplication().invokeLater(() -> SeverityEditorDialog.show(this.myProject, null, SeverityRegistrar.getSeverityRegistrar(this.myProject), true, (Consumer<? super HighlightSeverity>)((Consumer)severity -> this.myTable.setSelectedSeverity((HighlightSeverity)severity))));
        }
    }
}

