/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.content;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.content.JpsExcludeFolder;
import com.intellij.project.model.impl.module.content.JpsSourceFolder;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsExcludePattern;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JpsContentEntry
implements ContentEntry,
Disposable {
    private final VirtualFilePointer myRoot;
    private final JpsModule myModule;
    private final JpsRootModel myRootModel;
    private final List<JpsSourceFolder> mySourceFolders;
    private final List<JpsExcludeFolder> myExcludeFolders;
    private final List<String> myExcludePatterns;

    public JpsContentEntry(JpsModule module, JpsRootModel rootModel, String rootUrl) {
        this.myModule = module;
        this.myRootModel = rootModel;
        this.myRoot = VirtualFilePointerManager.getInstance().create(rootUrl, (Disposable)this, null);
        this.mySourceFolders = new ArrayList<JpsSourceFolder>();
        String rootPath = VfsUtilCore.urlToPath((String)this.getUrl());
        for (JpsModuleSourceRoot root : this.myModule.getSourceRoots()) {
            if (!FileUtil.isAncestor((String)rootPath, (String)VfsUtilCore.urlToPath((String)root.getUrl()), (boolean)false)) continue;
            this.mySourceFolders.add(new JpsSourceFolder(root, this));
        }
        this.myExcludeFolders = new ArrayList<JpsExcludeFolder>();
        for (String excludedUrl : this.myModule.getExcludeRootsList().getUrls()) {
            if (!FileUtil.isAncestor((String)rootPath, (String)VfsUtilCore.urlToPath((String)excludedUrl), (boolean)false)) continue;
            this.myExcludeFolders.add(new JpsExcludeFolder(excludedUrl, this));
        }
        this.myExcludePatterns = new SmartList();
        for (JpsExcludePattern pattern : this.myModule.getExcludePatterns()) {
            if (!pattern.getBaseDirUrl().equals(rootUrl)) continue;
            this.myExcludePatterns.add(pattern.getPattern());
        }
    }

    public VirtualFile getFile() {
        return this.myRoot.getFile();
    }

    @NotNull
    public String getUrl() {
        return this.myRoot.getUrl();
    }

    @NotNull
    public SourceFolder[] getSourceFolders() {
        return this.mySourceFolders.toArray(new SourceFolder[0]);
    }

    @NotNull
    public List<SourceFolder> getSourceFolders(@NotNull JpsModuleSourceRootType<?> rootType) {
        return this.getSourceFolders(Collections.singleton(rootType));
    }

    @NotNull
    public List<SourceFolder> getSourceFolders(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        SmartList folders = new SmartList();
        for (JpsSourceFolder folder : this.mySourceFolders) {
            if (!rootTypes.contains(folder.getRootType())) continue;
            folders.add(folder);
        }
        return folders;
    }

    @NotNull
    public VirtualFile[] getSourceFolderFiles() {
        return JpsContentEntry.getFiles((ContentFolder[])this.getSourceFolders());
    }

    private static VirtualFile[] getFiles(ContentFolder[] sourceFolders) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(sourceFolders.length);
        for (ContentFolder sourceFolder : sourceFolders) {
            VirtualFile file2 = sourceFolder.getFile();
            if (file2 == null) continue;
            result2.add(file2);
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    @NotNull
    public ExcludeFolder[] getExcludeFolders() {
        return this.myExcludeFolders.toArray(new ExcludeFolder[0]);
    }

    @NotNull
    public List<String> getExcludeFolderUrls() {
        ArrayList<String> excluded = new ArrayList<String>();
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            excluded.add(folder.getUrl());
        }
        for (DirectoryIndexExcludePolicy excludePolicy : (DirectoryIndexExcludePolicy[])DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)this.myRootModel.getProject())) {
            for (VirtualFilePointer pointer : excludePolicy.getExcludeRootsForModule(this.myRootModel)) {
                excluded.add(pointer.getUrl());
            }
        }
        return excluded;
    }

    @NotNull
    public VirtualFile[] getExcludeFolderFiles() {
        ArrayList excluded = new ArrayList();
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            ContainerUtil.addIfNotNull(excluded, (Object)folder.getFile());
        }
        for (DirectoryIndexExcludePolicy excludePolicy : (DirectoryIndexExcludePolicy[])DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)this.myRootModel.getProject())) {
            for (VirtualFilePointer pointer : excludePolicy.getExcludeRootsForModule(this.myRootModel)) {
                ContainerUtil.addIfNotNull(excluded, (Object)pointer.getFile());
            }
        }
        return VfsUtilCore.toVirtualFileArray(excluded);
    }

    @NotNull
    public SourceFolder addSourceFolder(@NotNull VirtualFile file2, boolean isTestSource) {
        return this.addSourceFolder(file2, isTestSource, "");
    }

    @NotNull
    public SourceFolder addSourceFolder(@NotNull VirtualFile file2, boolean isTestSource, @NotNull String packagePrefix) {
        return this.addSourceFolder(file2.getUrl(), isTestSource, packagePrefix);
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file2, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties) {
        JpsModuleSourceRoot sourceRoot = this.myModule.addSourceRoot(file2.getUrl(), type, properties);
        JpsSourceFolder sourceFolder = new JpsSourceFolder(sourceRoot, this);
        this.mySourceFolders.add(sourceFolder);
        return sourceFolder;
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file2, @NotNull JpsModuleSourceRootType<P> type) {
        return this.addSourceFolder(file2, type, (JpsElement)type.createDefaultProperties());
    }

    private SourceFolder addSourceFolder(String url, boolean isTestSource, String packagePrefix) {
        JavaSourceRootType rootType = isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        JavaSourceRootProperties properties = JpsJavaExtensionService.getInstance().createSourceRootProperties(packagePrefix);
        return this.addSourceFolder(url, (JpsModuleSourceRootType)rootType, (JpsElement)properties);
    }

    @NotNull
    public SourceFolder addSourceFolder(@NotNull String url, boolean isTestSource) {
        return this.addSourceFolder(url, isTestSource, "");
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type) {
        return this.addSourceFolder(url, type, (JpsElement)type.createDefaultProperties());
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties) {
        JpsModuleSourceRoot sourceRoot = this.myModule.addSourceRoot(url, type, properties);
        JpsSourceFolder sourceFolder = new JpsSourceFolder(sourceRoot, this);
        this.mySourceFolders.add(sourceFolder);
        return sourceFolder;
    }

    public void removeSourceFolder(@NotNull SourceFolder sourceFolder) {
        JpsSourceFolder folder = (JpsSourceFolder)sourceFolder;
        this.mySourceFolders.remove(folder);
        this.myModule.removeSourceRoot(folder.getSourceRoot().getUrl(), folder.getSourceRoot().getRootType());
        Disposer.dispose((Disposable)folder);
    }

    public void clearSourceFolders() {
        ArrayList<JpsModuleSourceRoot> toRemove2 = new ArrayList<JpsModuleSourceRoot>();
        for (JpsSourceFolder folder : this.mySourceFolders) {
            toRemove2.add(folder.getSourceRoot());
            Disposer.dispose((Disposable)folder);
        }
        this.mySourceFolders.clear();
        for (JpsModuleSourceRoot root : toRemove2) {
            this.myModule.removeSourceRoot(root.getUrl(), root.getRootType());
        }
    }

    public ExcludeFolder addExcludeFolder(@NotNull VirtualFile file2) {
        return this.addExcludeFolder(file2.getUrl());
    }

    public ExcludeFolder addExcludeFolder(@NotNull String url) {
        JpsExcludeFolder folder = new JpsExcludeFolder(url, this);
        this.myModule.getExcludeRootsList().addUrl(url);
        this.myExcludeFolders.add(folder);
        return folder;
    }

    public void removeExcludeFolder(@NotNull ExcludeFolder excludeFolder) {
        JpsExcludeFolder folder = (JpsExcludeFolder)excludeFolder;
        this.myExcludeFolders.remove(folder);
        this.myModule.getExcludeRootsList().removeUrl(folder.getUrl());
        Disposer.dispose((Disposable)folder);
    }

    public boolean removeExcludeFolder(@NotNull String url) {
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            if (!folder.getUrl().equals(url)) continue;
            this.myExcludeFolders.remove(folder);
            this.myModule.getExcludeRootsList().removeUrl(url);
            Disposer.dispose((Disposable)folder);
            return true;
        }
        return false;
    }

    public void clearExcludeFolders() {
        ArrayList<String> toRemove2 = new ArrayList<String>();
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            toRemove2.add(folder.getUrl());
            Disposer.dispose((Disposable)folder);
        }
        this.myExcludeFolders.clear();
        for (String url : toRemove2) {
            this.myModule.getExcludeRootsList().removeUrl(url);
        }
    }

    @NotNull
    public List<String> getExcludePatterns() {
        return this.myExcludePatterns;
    }

    public void addExcludePattern(@NotNull String pattern) {
        this.myExcludePatterns.add(pattern);
        this.myModule.addExcludePattern(this.getUrl(), pattern);
    }

    public void removeExcludePattern(@NotNull String pattern) {
        this.myExcludePatterns.remove(pattern);
        this.myModule.removeExcludePattern(this.getUrl(), pattern);
    }

    public void setExcludePatterns(@NotNull List<String> patterns) {
        for (String pattern : this.myExcludePatterns) {
            this.myModule.removeExcludePattern(this.getUrl(), pattern);
        }
        this.myExcludePatterns.clear();
        for (String pattern : patterns) {
            this.addExcludePattern(pattern);
        }
    }

    public boolean isSynthetic() {
        return false;
    }

    public void dispose() {
        for (JpsSourceFolder jpsSourceFolder : this.mySourceFolders) {
            Disposer.dispose((Disposable)jpsSourceFolder);
        }
        for (JpsExcludeFolder jpsExcludeFolder : this.myExcludeFolders) {
            Disposer.dispose((Disposable)jpsExcludeFolder);
        }
    }
}

