/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.dependencies;

import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.dependencies.JpsExportableOrderEntry;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsLibraryOrderEntry
extends JpsExportableOrderEntry<JpsLibraryDependency>
implements LibraryOrderEntry {
    public JpsLibraryOrderEntry(@NotNull JpsRootModel rootModel, @NotNull JpsLibraryDependency dependencyElement) {
        super(rootModel, dependencyElement);
    }

    public Library getLibrary() {
        return null;
    }

    @NotNull
    public String getLibraryName() {
        return ((JpsLibraryDependency)this.myDependencyElement).getLibraryReference().getLibraryName();
    }

    @NotNull
    public String getPresentableName() {
        return this.getLibraryName();
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType type) {
        return this.getRootFiles(type);
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType rootType) {
        return this.getRootUrls(rootType);
    }

    @NotNull
    public VirtualFile[] getRootFiles(@NotNull OrderRootType type) {
        Library library = this.getLibrary();
        return library != null ? library.getFiles(type) : VirtualFile.EMPTY_ARRAY;
    }

    @NotNull
    public String[] getRootUrls(@NotNull OrderRootType type) {
        Library library = this.getLibrary();
        return library != null ? library.getUrls(type) : ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String getLibraryLevel() {
        JpsElementReference reference = ((JpsLibraryDependency)this.myDependencyElement).getLibraryReference().getParentReference();
        JpsCompositeElement parent = (JpsCompositeElement)reference.resolve();
        if (parent instanceof JpsGlobal) {
            return "application";
        }
        if (parent instanceof JpsProject) {
            return "project";
        }
        if (parent instanceof JpsModule) {
            return "module";
        }
        return "project";
    }

    public boolean isModuleLevel() {
        return "module".equals(this.getLibraryLevel());
    }

    public <R> R accept(@NotNull RootPolicy<R> policy, @Nullable R initialValue) {
        return (R)policy.visitLibraryOrderEntry((LibraryOrderEntry)this, initialValue);
    }
}

