/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.dependencies;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.dependencies.JpsExportableOrderEntry;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleDependency;

public class JpsModuleOrderEntry
extends JpsExportableOrderEntry<JpsModuleDependency>
implements ModuleOrderEntry {
    public JpsModuleOrderEntry(@NotNull JpsRootModel rootModel, JpsModuleDependency dependencyElement) {
        super(rootModel, dependencyElement);
    }

    public Module getModule() {
        return null;
    }

    @NotNull
    public String getModuleName() {
        return ((JpsModuleDependency)this.myDependencyElement).getModuleReference().getModuleName();
    }

    @NotNull
    public String getPresentableName() {
        return this.getModuleName();
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType type) {
        OrderRootsEnumerator enumerator2 = this.getEnumerator(type);
        return enumerator2 != null ? enumerator2.getRoots() : VirtualFile.EMPTY_ARRAY;
    }

    @Nullable
    private OrderRootsEnumerator getEnumerator(OrderRootType type) {
        Module module = this.getModule();
        if (module == null) {
            return null;
        }
        return ModuleRootManagerImpl.getCachingEnumeratorForType(type, module);
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType rootType) {
        OrderRootsEnumerator enumerator2 = this.getEnumerator(rootType);
        return enumerator2 != null ? enumerator2.getUrls() : ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public <R> R accept(@NotNull RootPolicy<R> policy, @Nullable R initialValue) {
        return (R)policy.visitModuleOrderEntry((ModuleOrderEntry)this, initialValue);
    }
}

