/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.dependencies;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.dependencies.JpsOrderEntry;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceDependency;

public class JpsModuleSourceOrderEntry
extends JpsOrderEntry<JpsModuleSourceDependency>
implements ModuleSourceOrderEntry {
    public JpsModuleSourceOrderEntry(@NotNull JpsRootModel rootModel, @NotNull JpsModuleSourceDependency dependencyElement) {
        super(rootModel, dependencyElement);
    }

    public <R> R accept(@NotNull RootPolicy<R> policy, @Nullable R initialValue) {
        return (R)policy.visitModuleSourceOrderEntry((ModuleSourceOrderEntry)this, initialValue);
    }

    @NotNull
    public String getPresentableName() {
        return ProjectBundle.message((String)"project.root.module.source", (Object[])new Object[0]);
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType type) {
        if (OrderRootType.SOURCES.equals((Object)type)) {
            return this.getRootModel().getSourceRoots();
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType type) {
        if (OrderRootType.SOURCES.equals((Object)type)) {
            ContentEntry[] content = this.getRootModel().getContentEntries();
            ArrayList<String> result2 = new ArrayList<String>();
            for (ContentEntry contentEntry : content) {
                SourceFolder[] sourceFolders;
                for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                    String url = sourceFolder.getUrl();
                    result2.add(url);
                }
            }
            return ArrayUtil.toStringArray(result2);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public ModuleRootModel getRootModel() {
        return this.myRootModel;
    }
}

