/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import com.intellij.psi.impl.file.PsiLargeBinaryFileImpl;
import com.intellij.psi.impl.file.PsiLargeTextFileImpl;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFileViewProvider
extends UserDataHolderBase
implements FileViewProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.AbstractFileViewProvider");
    public static final Key<Object> FREE_THREADED = Key.create((String)"FREE_THREADED");
    private static final Key<Set<AbstractFileViewProvider>> KNOWN_COPIES = Key.create((String)"KNOWN_COPIES");
    @NotNull
    private final PsiManagerEx myManager;
    @NotNull
    private final VirtualFile myVirtualFile;
    private final boolean myEventSystemEnabled;
    private final boolean myPhysical;
    private volatile Content myContent;
    private volatile Reference<Document> myDocument;
    @NotNull
    private final FileType myFileType;
    private final PsiLock myPsiLock = new PsiLock();

    protected AbstractFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull FileType type) {
        this.myManager = (PsiManagerEx)manager;
        this.myVirtualFile = virtualFile;
        this.myEventSystemEnabled = eventSystemEnabled;
        this.setContent(new VirtualFileContent());
        this.myPhysical = this.isEventSystemEnabled() && !(virtualFile instanceof LightVirtualFile) && !(virtualFile.getFileSystem() instanceof NonPhysicalFileSystem);
        virtualFile.putUserData(FREE_THREADED, (Object)AbstractFileViewProvider.isFreeThreaded(this));
        this.myFileType = type;
        if (virtualFile instanceof VirtualFileWindow && !(this instanceof FreeThreadedFileViewProvider)) {
            throw new IllegalArgumentException("Must not create " + ((Object)((Object)this)).getClass() + " for injected file " + virtualFile + "; InjectedFileViewProvider must be used instead");
        }
    }

    final boolean shouldCreatePsi() {
        if (this.isIgnored()) {
            return false;
        }
        VirtualFile vFile = this.getVirtualFile();
        if (this.isPhysical() && vFile.isInLocalFileSystem()) {
            FileIndexFacade indexFacade;
            VirtualFile parent = vFile.getParent();
            if (parent == null) {
                return false;
            }
            PsiDirectory psiDir = this.getManager().findDirectory(parent);
            if (psiDir == null && !(indexFacade = FileIndexFacade.getInstance((Project)this.getManager().getProject())).isInLibrarySource(vFile) && !indexFacade.isInLibraryClasses(vFile)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isFreeThreaded(@NotNull FileViewProvider provider) {
        return provider.getVirtualFile() instanceof LightVirtualFile && !provider.isEventSystemEnabled();
    }

    @NotNull
    public PsiLock getFilePsiLock() {
        return this.myPsiLock;
    }

    protected final boolean isIgnored() {
        VirtualFile file2 = this.getVirtualFile();
        return !(file2 instanceof LightVirtualFile) && FileTypeRegistry.getInstance().isFileIgnored(file2);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Project project, @NotNull VirtualFile file2, @NotNull FileType fileType) {
        PsiFile psiFile;
        if (fileType.isBinary() || file2.is(VFileProperty.SPECIAL)) {
            return SingleRootFileViewProvider.isTooLargeForContentLoading(file2) ? new PsiLargeBinaryFileImpl((PsiManagerImpl)this.getManager(), this) : new PsiBinaryFileImpl((PsiManagerImpl)this.getManager(), this);
        }
        if (!SingleRootFileViewProvider.isTooLargeForIntelligence(file2) && (psiFile = this.createFile(this.getBaseLanguage())) != null) {
            return psiFile;
        }
        if (SingleRootFileViewProvider.isTooLargeForContentLoading(file2)) {
            return new PsiLargeTextFileImpl(this);
        }
        return new PsiPlainTextFileImpl(this);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang != this.getBaseLanguage()) {
            return null;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null) {
            return parserDefinition.createFile((FileViewProvider)this);
        }
        return null;
    }

    @NotNull
    public final PsiManagerEx getManager() {
        return this.myManager;
    }

    @NotNull
    public CharSequence getContents() {
        return this.getContent().getText();
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Nullable
    private Document getCachedDocument() {
        Document document = (Document)SoftReference.dereference(this.myDocument);
        if (document != null) {
            return document;
        }
        return FileDocumentManager.getInstance().getCachedDocument(this.getVirtualFile());
    }

    public Document getDocument() {
        Document document = (Document)SoftReference.dereference(this.myDocument);
        if (document == null) {
            document = FileDocumentManager.getInstance().getDocument(this.getVirtualFile());
            this.myDocument = document == null ? null : new java.lang.ref.SoftReference<Document>(document);
        }
        return document;
    }

    @Nullable
    public final PsiFile getPsi(@NotNull Language target2) {
        VirtualFile virtualFile;
        FileManager fileManager;
        if (!this.isPhysical() && (fileManager = this.getManager().getFileManager()).findCachedViewProvider(virtualFile = this.getVirtualFile()) == null && this.getCachedPsiFiles().isEmpty()) {
            fileManager.setViewProvider(virtualFile, this);
        }
        return this.getPsiInner(target2);
    }

    @Nullable
    protected abstract PsiFile getPsiInner(Language var1);

    public FileViewProvider clone() {
        VirtualFile origFile = this.getVirtualFile();
        LightVirtualFile copy = new LightVirtualFile(origFile.getName(), this.myFileType, this.getContents(), origFile.getCharset(), this.getModificationStamp());
        origFile.copyCopyableDataTo((UserDataHolderBase)copy);
        copy.setOriginalFile(origFile);
        copy.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        copy.setCharset(origFile.getCharset());
        return this.createCopy((VirtualFile)copy);
    }

    public PsiElement findElementAt(int offset, @NotNull Language language) {
        PsiFile psiFile = this.getPsi(language);
        return psiFile != null ? AbstractFileViewProvider.findElementAt((PsiElement)psiFile, offset) : null;
    }

    @Nullable
    public PsiReference findReferenceAt(int offset, @NotNull Language language) {
        PsiFile psiFile = this.getPsi(language);
        return psiFile != null ? AbstractFileViewProvider.findReferenceAt(psiFile, offset) : null;
    }

    @Nullable
    protected static PsiReference findReferenceAt(@Nullable PsiFile psiFile, int offset) {
        if (psiFile == null) {
            return null;
        }
        int offsetInElement = offset;
        for (PsiElement child2 = psiFile.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
            int length = child2.getTextLength();
            if (length <= offsetInElement) {
                offsetInElement -= length;
                continue;
            }
            return child2.findReferenceAt(offsetInElement);
        }
        return null;
    }

    @Nullable
    public static PsiElement findElementAt(@Nullable PsiElement psiFile, int offset) {
        ASTNode node = psiFile == null ? null : psiFile.getNode();
        return node == null ? null : SourceTreeToPsiMap.treeElementToPsi(node.findLeafElementAt(offset));
    }

    public void beforeContentsSynchronized() {
    }

    public void contentsSynchronized() {
        if (this.myContent instanceof PsiFileContent) {
            this.setContent(new VirtualFileContent());
        }
        this.checkLengthConsistency();
    }

    public final void onContentReload() {
        List<PsiFile> files2 = this.getCachedPsiFiles();
        ArrayList<PsiTreeChangeEventImpl> events = new ArrayList<PsiTreeChangeEventImpl>(files2.size());
        ArrayList<PsiTreeChangeEventImpl> genericEvents = new ArrayList<PsiTreeChangeEventImpl>(files2.size());
        for (PsiFile file2 : files2) {
            genericEvents.add(this.createChildrenChangeEvent(file2, true));
            events.add(this.createChildrenChangeEvent(file2, false));
        }
        this.beforeContentsSynchronized();
        for (PsiTreeChangeEventImpl event : genericEvents) {
            ((PsiManagerImpl)this.getManager()).beforeChildrenChange(event);
        }
        for (PsiTreeChangeEventImpl event : events) {
            ((PsiManagerImpl)this.getManager()).beforeChildrenChange(event);
        }
        for (PsiFile psiFile : files2) {
            if (!(psiFile instanceof PsiFileEx)) continue;
            ((PsiFileEx)psiFile).onContentReload();
        }
        this.contentsSynchronized();
        for (PsiTreeChangeEventImpl event : events) {
            ((PsiManagerImpl)this.getManager()).childrenChanged(event);
        }
        for (PsiTreeChangeEventImpl event : genericEvents) {
            ((PsiManagerImpl)this.getManager()).childrenChanged(event);
        }
    }

    private PsiTreeChangeEventImpl createChildrenChangeEvent(PsiFile file2, boolean generic) {
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        event.setParent((PsiElement)file2);
        event.setFile(file2);
        event.setGenericChange(generic);
        if (file2 instanceof PsiFileImpl && ((PsiFileImpl)file2).isContentsLoaded()) {
            event.setOffset(0);
            event.setOldLength(file2.getTextLength());
        }
        return event;
    }

    public void rootChanged(@NotNull PsiFile psiFile) {
        if (psiFile instanceof PsiFileImpl && ((PsiFileImpl)psiFile).isContentsLoaded() && psiFile.isValid()) {
            this.setContent(new PsiFileContent(((PsiFileImpl)psiFile).calcTreeElement(), LocalTimeCounter.currentTime()));
        }
    }

    public boolean isEventSystemEnabled() {
        return this.myEventSystemEnabled;
    }

    public boolean isPhysical() {
        return this.myPhysical;
    }

    public long getModificationStamp() {
        return this.getContent().getModificationStamp();
    }

    public boolean supportsIncrementalReparse(@NotNull Language rootLanguage) {
        return true;
    }

    @NotNull
    private Content getContent() {
        return this.myContent;
    }

    private void setContent(@NotNull Content content) {
        this.myContent = content;
    }

    private void checkLengthConsistency() {
        Document document = this.getCachedDocument();
        if (document instanceof DocumentWindow) {
            return;
        }
        if (document != null && ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myManager.getProject())).getSynchronizer().isInSynchronization(document)) {
            return;
        }
        List<FileElement> knownTreeRoots = this.getKnownTreeRoots();
        if (knownTreeRoots.isEmpty()) {
            return;
        }
        int fileLength = this.myContent.getTextLength();
        for (FileElement fileElement : knownTreeRoots) {
            int nodeLength;
            if (this.isDocumentConsistentWithPsi(fileLength, fileElement, nodeLength = fileElement.getTextLength())) continue;
            PsiUtilCore.ensureValid((PsiElement)fileElement.getPsi());
            ArrayList attachments = ContainerUtil.newArrayList((Object[])new Attachment[]{new Attachment(this.myVirtualFile.getName(), this.myContent.getText().toString()), new Attachment(this.myVirtualFile.getNameWithoutExtension() + ".tree.txt", fileElement.getText())});
            if (document != null) {
                attachments.add(new Attachment(this.myVirtualFile.getNameWithoutExtension() + ".document.txt", document.getText()));
            }
            LOG.error("Inconsistent " + fileElement.getElementType() + " tree in " + (Object)((Object)this) + "; nodeLength=" + nodeLength + "; fileLength=" + fileLength, attachments.toArray(Attachment.EMPTY_ARRAY));
        }
    }

    private boolean isDocumentConsistentWithPsi(int fileLength, FileElement fileElement, int nodeLength) {
        if (nodeLength != fileLength) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !ApplicationInfoImpl.isInStressTest()) {
            return fileElement.textMatches(this.myContent.getText());
        }
        return true;
    }

    @NonNls
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{myVirtualFile=" + this.myVirtualFile + ", content=" + this.getContent() + '}';
    }

    public abstract PsiFile getCachedPsi(@NotNull Language var1);

    @NotNull
    public abstract List<PsiFile> getCachedPsiFiles();

    @NotNull
    public abstract List<FileElement> getKnownTreeRoots();

    public final void markInvalidated() {
        this.invalidateCachedPsi();
        this.forKnownCopies(copy -> this.myManager.getFileManager().setViewProvider(copy.getVirtualFile(), null));
    }

    public final void markPossiblyInvalidated() {
        this.invalidateCachedPsi();
        this.forKnownCopies(FileManagerImpl::markPossiblyInvalidated);
    }

    private void invalidateCachedPsi() {
        for (PsiFile file2 : this.getCachedPsiFiles()) {
            if (!(file2 instanceof PsiFileEx)) continue;
            ((PsiFileEx)file2).markInvalidated();
        }
    }

    private void forKnownCopies(Consumer<? super AbstractFileViewProvider> action) {
        Set knownCopies = (Set)this.getUserData(KNOWN_COPIES);
        if (knownCopies != null) {
            for (AbstractFileViewProvider copy : knownCopies) {
                if (!copy.getCachedPsiFiles().stream().anyMatch(f -> f.getOriginalFile().getViewProvider() == this)) continue;
                action.accept(copy);
            }
        }
    }

    public final void registerAsCopy(@NotNull AbstractFileViewProvider copy) {
        Set copies;
        if (copy instanceof FreeThreadedFileViewProvider) {
            LOG.assertTrue(this instanceof FreeThreadedFileViewProvider, (Object)"Injected file can't have non-injected original file");
        }
        if ((copies = (Set)this.getUserData(KNOWN_COPIES)) == null) {
            copies = (Set)this.putUserDataIfAbsent(KNOWN_COPIES, Collections.newSetFromMap(ContainerUtil.createConcurrentWeakMap()));
        }
        if (copy.getUserData(KNOWN_COPIES) != null) {
            LOG.error("A view provider copy must be registered before it may have its own copies, to avoid cycles");
        }
        copies.add(copy);
    }

    @NotNull
    private CharSequence getLastCommittedText(@NotNull Document document) {
        return PsiDocumentManager.getInstance((Project)this.myManager.getProject()).getLastCommittedText(document);
    }

    private long getLastCommittedStamp(@NotNull Document document) {
        return PsiDocumentManager.getInstance((Project)this.myManager.getProject()).getLastCommittedStamp(document);
    }

    @NotNull
    public PsiFile getStubBindingRoot() {
        PsiFile psi = this.getPsi(this.getBaseLanguage());
        assert (psi != null);
        return psi;
    }

    @NotNull
    public final FileType getFileType() {
        return this.myFileType;
    }

    private static class PsiFileContent
    implements Content {
        private final long myModificationStamp;
        private final FileElement myFileElement;

        PsiFileContent(@NotNull FileElement fileElement, long modificationStamp) {
            this.myModificationStamp = modificationStamp;
            this.myFileElement = fileElement;
        }

        @Override
        @NotNull
        public CharSequence getText() {
            return this.myFileElement.getText();
        }

        @Override
        public int getTextLength() {
            return this.myFileElement.getTextLength();
        }

        @Override
        public long getModificationStamp() {
            return this.myModificationStamp;
        }
    }

    private class VirtualFileContent
    implements Content {
        private VirtualFileContent() {
        }

        @Override
        @NotNull
        public CharSequence getText() {
            VirtualFile virtualFile = AbstractFileViewProvider.this.getVirtualFile();
            if (virtualFile instanceof LightVirtualFile) {
                Document doc = AbstractFileViewProvider.this.getCachedDocument();
                if (doc != null) {
                    return AbstractFileViewProvider.this.getLastCommittedText(doc);
                }
                return ((LightVirtualFile)virtualFile).getContent();
            }
            Document document = AbstractFileViewProvider.this.getDocument();
            if (document == null) {
                return LoadTextUtil.loadText(virtualFile);
            }
            return AbstractFileViewProvider.this.getLastCommittedText(document);
        }

        @Override
        public int getTextLength() {
            return this.getText().length();
        }

        @Override
        public long getModificationStamp() {
            Document document = AbstractFileViewProvider.this.getCachedDocument();
            if (document == null) {
                return AbstractFileViewProvider.this.getVirtualFile().getModificationStamp();
            }
            return AbstractFileViewProvider.this.getLastCommittedStamp(document);
        }

        @NonNls
        public String toString() {
            return "VirtualFileContent{size=" + AbstractFileViewProvider.this.getVirtualFile().getLength() + "}";
        }
    }

    private static interface Content {
        @NotNull
        public CharSequence getText();

        public int getTextLength();

        public long getModificationStamp();
    }
}

