/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DummyHolderViewProvider
extends AbstractFileViewProvider {
    private DummyHolder myHolder;
    private final long myModificationStamp = LocalTimeCounter.currentTime();

    public DummyHolderViewProvider(@NotNull PsiManager manager) {
        super(manager, (VirtualFile)new LightVirtualFile("DummyHolder"), false, UnknownFileType.INSTANCE);
    }

    @Override
    @NotNull
    public CharSequence getContents() {
        return this.myHolder != null ? this.myHolder.getNode().getText() : "";
    }

    @NotNull
    public Language getBaseLanguage() {
        return this.myHolder.getLanguage();
    }

    @NotNull
    public Set<Language> getLanguages() {
        return Collections.singleton(this.getBaseLanguage());
    }

    @Override
    @Nullable
    protected PsiFile getPsiInner(Language target2) {
        return this.getCachedPsi(target2);
    }

    @Override
    public PsiFile getCachedPsi(@NotNull Language target2) {
        this.getManager().getFileManager().setViewProvider(this.getVirtualFile(), this);
        return target2 == this.getBaseLanguage() ? this.myHolder : null;
    }

    @Override
    @NotNull
    public List<PsiFile> getCachedPsiFiles() {
        return Collections.singletonList(this.myHolder);
    }

    @Override
    @NotNull
    public List<FileElement> getKnownTreeRoots() {
        return Collections.singletonList(this.myHolder.getTreeElement());
    }

    @NotNull
    public List<PsiFile> getAllFiles() {
        return this.getCachedPsiFiles();
    }

    @Override
    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    public void setDummyHolder(@NotNull DummyHolder dummyHolder) {
        this.myHolder = dummyHolder;
        ((LightVirtualFile)this.getVirtualFile()).setFileType(dummyHolder.getFileType());
    }

    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt((PsiElement)this.getPsi(this.getBaseLanguage()), offset);
    }

    public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
        if (!lang.isAssignableFrom(this.getBaseLanguage().getClass())) {
            return null;
        }
        return this.findElementAt(offset);
    }

    @NotNull
    public FileViewProvider createCopy(@NotNull VirtualFile copy) {
        throw new RuntimeException("Clone is not supported for DummyHolderProviders. Use DummyHolder clone directly.");
    }

    public PsiElement findElementAt(int offset) {
        LeafElement element = this.myHolder.calcTreeElement().findLeafElementAt(offset);
        return element != null ? element.getPsi() : null;
    }
}

