/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleRootFileViewProvider
extends AbstractFileViewProvider
implements FileViewProvider {
    private static final Key<Boolean> OUR_NO_SIZE_LIMIT_KEY = Key.create((String)"no.size.limit");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.SingleRootFileViewProvider");
    private volatile PsiFile myPsiFile;
    private static final AtomicFieldUpdater<SingleRootFileViewProvider, PsiFile> myPsiFileUpdater = AtomicFieldUpdater.forFieldOfType(SingleRootFileViewProvider.class, PsiFile.class);
    @NotNull
    private final Language myBaseLanguage;

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file2) {
        this(manager, file2, true);
    }

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        this(manager, virtualFile, eventSystemEnabled, virtualFile.getFileType());
    }

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull FileType fileType) {
        this(manager, virtualFile, eventSystemEnabled, SingleRootFileViewProvider.calcBaseLanguage(virtualFile, manager.getProject(), fileType), fileType);
    }

    protected SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull Language language) {
        this(manager, virtualFile, eventSystemEnabled, language, virtualFile.getFileType());
    }

    protected SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull Language language, @NotNull FileType type) {
        super(manager, virtualFile, eventSystemEnabled, type);
        this.myBaseLanguage = language;
    }

    @NotNull
    public Language getBaseLanguage() {
        return this.myBaseLanguage;
    }

    private static Language calcBaseLanguage(@NotNull VirtualFile file2, @NotNull Project project, @NotNull FileType fileType) {
        if (fileType.isBinary()) {
            return Language.ANY;
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file2)) {
            return PlainTextLanguage.INSTANCE;
        }
        Language language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file2);
        return language != null ? language : PlainTextLanguage.INSTANCE;
    }

    @NotNull
    public Set<Language> getLanguages() {
        return Collections.singleton(this.getBaseLanguage());
    }

    @NotNull
    public List<PsiFile> getAllFiles() {
        return ContainerUtil.createMaybeSingletonList((Object)this.getPsi(this.getBaseLanguage()));
    }

    @Override
    @Nullable
    protected PsiFile getPsiInner(@NotNull Language target2) {
        if (target2 != this.getBaseLanguage()) {
            return null;
        }
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            boolean set2;
            psiFile = this.createFile();
            if (psiFile == null) {
                psiFile = PsiUtilCore.NULL_PSI_FILE;
            }
            if (!(set2 = myPsiFileUpdater.compareAndSet((Object)this, null, (Object)psiFile)) && psiFile != PsiUtilCore.NULL_PSI_FILE) {
                PsiFile alreadyCreated = this.myPsiFile;
                if (alreadyCreated == psiFile) {
                    LOG.error((Object)((Object)this) + ".createFile() must create new file instance but got the same: " + psiFile);
                }
                if (psiFile instanceof PsiFileEx) {
                    PsiFile finalPsiFile = psiFile;
                    DebugUtil.performPsiModification("invalidating throw-away copy", () -> ((PsiFileEx)finalPsiFile).markInvalidated());
                }
                psiFile = alreadyCreated;
            }
        }
        return psiFile == PsiUtilCore.NULL_PSI_FILE ? null : psiFile;
    }

    @Override
    public final PsiFile getCachedPsi(@NotNull Language target2) {
        if (target2 != this.getBaseLanguage()) {
            return null;
        }
        PsiFile file2 = this.myPsiFile;
        return file2 == PsiUtilCore.NULL_PSI_FILE ? null : file2;
    }

    @Override
    @NotNull
    public final List<PsiFile> getCachedPsiFiles() {
        return ContainerUtil.createMaybeSingletonList((Object)this.getCachedPsi(this.getBaseLanguage()));
    }

    @Override
    @NotNull
    public final List<FileElement> getKnownTreeRoots() {
        PsiFile psiFile = this.getCachedPsi(this.getBaseLanguage());
        if (!(psiFile instanceof PsiFileImpl)) {
            return Collections.emptyList();
        }
        FileElement element = ((PsiFileImpl)psiFile).getTreeElement();
        return ContainerUtil.createMaybeSingletonList((Object)element);
    }

    private PsiFile createFile() {
        try {
            return this.shouldCreatePsi() ? this.createFile(this.getManager().getProject(), this.getVirtualFile(), this.getFileType()) : null;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return null;
        }
    }

    public static boolean isTooLargeForIntelligence(@NotNull VirtualFile vFile) {
        if (!SingleRootFileViewProvider.checkFileSizeLimit(vFile)) {
            return false;
        }
        return SingleRootFileViewProvider.fileSizeIsGreaterThan(vFile, PersistentFSConstants.getMaxIntellisenseFileSize());
    }

    public static boolean isTooLargeForContentLoading(@NotNull VirtualFile vFile) {
        return SingleRootFileViewProvider.fileSizeIsGreaterThan(vFile, PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD);
    }

    private static boolean checkFileSizeLimit(@NotNull VirtualFile vFile) {
        VirtualFile original;
        if (Boolean.TRUE.equals(vFile.getCopyableUserData(OUR_NO_SIZE_LIMIT_KEY))) {
            return false;
        }
        if (vFile instanceof LightVirtualFile && (original = ((LightVirtualFile)vFile).getOriginalFile()) != null) {
            return SingleRootFileViewProvider.checkFileSizeLimit(original);
        }
        return true;
    }

    public static void doNotCheckFileSizeLimit(@NotNull VirtualFile vFile) {
        vFile.putCopyableUserData(OUR_NO_SIZE_LIMIT_KEY, (Object)Boolean.TRUE);
    }

    public static boolean isTooLargeForIntelligence(@NotNull VirtualFile vFile, long contentSize) {
        if (!SingleRootFileViewProvider.checkFileSizeLimit(vFile)) {
            return false;
        }
        return contentSize > (long)PersistentFSConstants.getMaxIntellisenseFileSize();
    }

    public static boolean isTooLargeForContentLoading(@NotNull VirtualFile vFile, long contentSize) {
        return contentSize > PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD;
    }

    public static boolean fileSizeIsGreaterThan(@NotNull VirtualFile vFile, long maxBytes) {
        if (vFile instanceof LightVirtualFile) {
            int lengthInChars = ((LightVirtualFile)vFile).getContent().length();
            if ((long)lengthInChars < maxBytes / 2L) {
                return false;
            }
            if ((long)lengthInChars > maxBytes) {
                return true;
            }
        }
        return vFile.getLength() > maxBytes;
    }

    @NotNull
    public SingleRootFileViewProvider createCopy(@NotNull VirtualFile copy) {
        return new SingleRootFileViewProvider((PsiManager)this.getManager(), copy, false, this.getBaseLanguage());
    }

    public PsiReference findReferenceAt(int offset) {
        PsiFile psiFile = this.getPsi(this.getBaseLanguage());
        return SingleRootFileViewProvider.findReferenceAt(psiFile, offset);
    }

    public PsiElement findElementAt(int offset) {
        return SingleRootFileViewProvider.findElementAt((PsiElement)this.getPsi(this.getBaseLanguage()), offset);
    }

    public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
        if (!ReflectionUtil.isAssignable(lang, this.getBaseLanguage().getClass())) {
            return null;
        }
        return this.findElementAt(offset);
    }

    public final void forceCachedPsi(@NotNull PsiFile psiFile) {
        PsiFile prev2;
        while (!myPsiFileUpdater.compareAndSet((Object)this, (Object)(prev2 = this.myPsiFile), (Object)psiFile)) {
        }
        if (prev2 != psiFile && prev2 instanceof PsiFileEx) {
            ((PsiFileEx)prev2).markInvalidated();
        }
        this.getManager().getFileManager().setViewProvider(this.getVirtualFile(), this);
    }
}

