/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.availability;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.availability.PsiAvailabilityService;
import com.intellij.util.concurrency.Semaphore;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAvailabilityServiceImpl
extends PsiAvailabilityService {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.availability.PsiAvailabilityServiceImpl");
    private final Project myProject;
    private final PsiDocumentManager myDocumentManager;

    public PsiAvailabilityServiceImpl(Project project) {
        this.myProject = project;
        this.myDocumentManager = PsiDocumentManager.getInstance((Project)project);
    }

    @Override
    public boolean makePsiAvailable(final @NotNull Document document, @Nls @NotNull String progressTitle) {
        final Ref success2 = Ref.create((Object)false);
        new Task.Modal(this.myProject, progressTitle, true){

            public void run(@NotNull ProgressIndicator indicator) {
                Semaphore semaphore = new Semaphore(1);
                ApplicationManager.getApplication().invokeLater(() -> PsiAvailabilityServiceImpl.this.myDocumentManager.performWhenAllCommitted(() -> semaphore.up()));
                while (!semaphore.waitFor(50L)) {
                    indicator.checkCanceled();
                }
                success2.set(ReadAction.compute(() -> PsiAvailabilityServiceImpl.this.ensureParsed(document)));
            }
        }.queue();
        return (Boolean)success2.get();
    }

    @Override
    public void performWhenPsiAvailable(@NotNull Document document, @NotNull Runnable callback2, @Nullable ProgressIndicator indicator) {
        new MyTask(document, callback2, indicator).rescheduleIfNeeded();
    }

    private boolean ensureParsed(@NotNull Document document) {
        PsiFile baseFile;
        LOG.trace("ensureParsed");
        if (this.myDocumentManager.isCommitted(document) && (baseFile = this.myDocumentManager.getPsiFile(document)) != null) {
            for (PsiFile file2 : baseFile.getViewProvider().getAllFiles()) {
                ProgressManager.checkCanceled();
                file2.getNode().getFirstChildNode();
            }
            return true;
        }
        return false;
    }

    static enum ParsedState {
        Obsolete,
        Uncommitted,
        NotParsed,
        Parsed;

    }

    private class MyTask {
        private final Document myDocument;
        private final long myOriginalStamp;
        private final Runnable myAction;
        private final ProgressIndicator myOriginalIndicator;

        private MyTask(Document document, Runnable action, ProgressIndicator indicator) {
            this.myDocument = document;
            this.myOriginalStamp = document.getModificationStamp();
            this.myAction = action;
            this.myOriginalIndicator = indicator == null ? new ProgressIndicatorBase() : indicator;
        }

        private boolean isObsolete(ProgressIndicator indicator) {
            return PsiAvailabilityServiceImpl.this.myProject.isDisposed() || indicator.isCanceled() || this.myDocument.getModificationStamp() != this.myOriginalStamp;
        }

        void rescheduleIfNeeded() {
            LOG.trace("rescheduleIfNeeded");
            switch (this.getParsedState(this.myOriginalIndicator)) {
                case Obsolete: {
                    return;
                }
                case Parsed: {
                    this.myAction.run();
                    return;
                }
            }
            PsiAvailabilityServiceImpl.this.myDocumentManager.performForCommittedDocument(this.myDocument, () -> ApplicationManager.getApplication().invokeLater(() -> {
                switch (this.getParsedState(this.myOriginalIndicator)) {
                    case Obsolete: {
                        return;
                    }
                    case Uncommitted: {
                        this.rescheduleIfNeeded();
                        return;
                    }
                    case NotParsed: {
                        break;
                    }
                    case Parsed: {
                        this.myAction.run();
                        return;
                    }
                }
                LOG.trace("scheduling background task");
                ProgressIndicatorUtils.scheduleWithWriteActionPriority(new SensitiveProgressWrapper(this.myOriginalIndicator), new ReadTask(){

                    @Override
                    @Nullable
                    public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                        if (MyTask.this.isObsolete(indicator)) {
                            return null;
                        }
                        if (PsiAvailabilityServiceImpl.this.ensureParsed(MyTask.this.myDocument)) {
                            return new ReadTask.Continuation(() -> {
                                switch (MyTask.this.getParsedState(indicator)) {
                                    case Obsolete: {
                                        break;
                                    }
                                    case Uncommitted: 
                                    case NotParsed: {
                                        MyTask.this.rescheduleIfNeeded();
                                        break;
                                    }
                                    case Parsed: {
                                        MyTask.this.myAction.run();
                                    }
                                }
                            });
                        }
                        return null;
                    }

                    @Override
                    public void onCanceled(@NotNull ProgressIndicator indicator) {
                        MyTask.this.rescheduleIfNeeded();
                    }
                });
            }));
        }

        ParsedState getParsedState(@NotNull ProgressIndicator indicator) {
            if (this.isObsolete(indicator)) {
                return ParsedState.Obsolete;
            }
            PsiFile baseFile = PsiAvailabilityServiceImpl.this.myDocumentManager.getPsiFile(this.myDocument);
            if (baseFile == null) {
                return ParsedState.Obsolete;
            }
            if (PsiAvailabilityServiceImpl.this.myDocumentManager.isUncommited(this.myDocument)) {
                return ParsedState.Uncommitted;
            }
            for (PsiFile file2 : baseFile.getViewProvider().getAllFiles()) {
                if (file2.getNode() == null || file2.getNode().isParsed()) continue;
                return ParsedState.NotParsed;
            }
            return ParsedState.Parsed;
        }
    }
}

