/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.lang.LanguageFormatting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DetectAndAdjustIndentOptionsTask;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.IndentStatusBarUIContributor;
import com.intellij.psi.codeStyle.TimeStampedIndentOptions;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetectableIndentOptionsProvider
extends FileIndentOptionsProvider {
    private static final ExecutorService BOUNDED_EXECUTOR = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"DetectableIndentOptionsProvider Pool");
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Automatic indent detection", NotificationDisplayType.STICKY_BALLOON, true);
    private boolean myIsEnabledInTest;
    private final Map<VirtualFile, CommonCodeStyleSettings.IndentOptions> myDiscardedOptions = ContainerUtil.createWeakMap();
    private boolean hasBeenAdvertised;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings settings, @NotNull PsiFile file2) {
        TimeStampedIndentOptions options;
        if (!this.isEnabled(settings, file2)) {
            return null;
        }
        Project project = file2.getProject();
        PsiDocumentManager psiManager = PsiDocumentManager.getInstance((Project)project);
        Document document = psiManager.getDocument(file2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        synchronized (document2) {
            options = this.getValidCachedIndentOptions(file2, document);
            if (options != null) {
                return options;
            }
            options = DetectAndAdjustIndentOptionsTask.getDefaultIndentOptions(file2, document);
            options.associateWithDocument(document);
        }
        this.scheduleDetectionInBackground(project, document, options);
        return options;
    }

    protected void scheduleDetectionInBackground(@NotNull Project project, @NotNull Document document, @NotNull TimeStampedIndentOptions options) {
        DetectAndAdjustIndentOptionsTask task2 = new DetectAndAdjustIndentOptionsTask(project, document, options, BOUNDED_EXECUTOR);
        task2.scheduleInBackgroundForCommittedDocument();
    }

    public boolean useOnFullReformat() {
        return false;
    }

    public void setEnabledInTest(boolean isEnabledInTest) {
        this.myIsEnabledInTest = isEnabledInTest;
    }

    private boolean isEnabled(@NotNull CodeStyleSettings settings, @NotNull PsiFile file2) {
        if (!file2.isWritable() || file2 instanceof PsiBinaryFile || file2 instanceof PsiCompiledFile || file2.getFileType() == ScratchFileType.INSTANCE) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myIsEnabledInTest;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null || vFile instanceof LightVirtualFile || this.myDiscardedOptions.containsKey(vFile)) {
            return false;
        }
        return LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null && settings.AUTODETECT_INDENTS;
    }

    @Nullable
    public static DetectableIndentOptionsProvider getInstance() {
        return (DetectableIndentOptionsProvider)((Object)FileIndentOptionsProvider.EP_NAME.findExtension(DetectableIndentOptionsProvider.class));
    }

    private void disableForFile(@NotNull VirtualFile file2, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        this.myDiscardedOptions.put(file2, indentOptions);
    }

    public TimeStampedIndentOptions getValidCachedIndentOptions(PsiFile file2, Document document) {
        TimeStampedIndentOptions defaultIndentOptions;
        TimeStampedIndentOptions cachedInDocument;
        CommonCodeStyleSettings.IndentOptions options = CommonCodeStyleSettings.IndentOptions.retrieveFromAssociatedDocument((PsiFile)file2);
        if (options instanceof TimeStampedIndentOptions && !(cachedInDocument = (TimeStampedIndentOptions)options).isOutdated(document, defaultIndentOptions = DetectAndAdjustIndentOptionsTask.getDefaultIndentOptions(file2, document))) {
            return cachedInDocument;
        }
        return null;
    }

    private static void showDisabledDetectionNotification(@NotNull Project project) {
        DetectionDisabledNotification notification = new DetectionDisabledNotification(project);
        notification.notify(project);
    }

    private static boolean areDetected(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        return indentOptions instanceof TimeStampedIndentOptions && ((TimeStampedIndentOptions)indentOptions).isDetected();
    }

    @Nullable
    public IndentStatusBarUIContributor getIndentStatusBarUiContributor(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        return new MyUIContributor(indentOptions);
    }

    private class MyUIContributor
    extends IndentStatusBarUIContributor {
        private MyUIContributor(CommonCodeStyleSettings.IndentOptions options) {
            super(options);
        }

        @Nullable
        public AnAction[] getActions(@NotNull PsiFile file2) {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptions();
            ArrayList actions = ContainerUtil.newArrayList();
            VirtualFile virtualFile = file2.getVirtualFile();
            Project project = file2.getProject();
            CommonCodeStyleSettings.IndentOptions projectOptions = CodeStyle.getSettings((Project)project).getIndentOptions(file2.getFileType());
            String projectOptionsTip = StringUtil.capitalizeWords((String)IndentStatusBarUIContributor.getIndentInfo((CommonCodeStyleSettings.IndentOptions)projectOptions), (boolean)true);
            if (indentOptions instanceof TimeStampedIndentOptions) {
                if (((TimeStampedIndentOptions)indentOptions).isDetected()) {
                    actions.add(DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.indent.detector.reject", (Object[])new Object[]{projectOptionsTip}), e -> {
                        DetectableIndentOptionsProvider.this.disableForFile(virtualFile, indentOptions);
                        FileIndentOptionsProvider.notifyIndentOptionsChanged((Project)project, (PsiFile)file2);
                    }));
                    actions.add(DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.indent.detector.reindent", (Object[])new Object[]{projectOptionsTip}), e -> {
                        DetectableIndentOptionsProvider.this.disableForFile(virtualFile, indentOptions);
                        FileIndentOptionsProvider.notifyIndentOptionsChanged((Project)project, (PsiFile)file2);
                        CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> CodeStyleManager.getInstance((Project)project).adjustLineIndent(file2, file2.getTextRange())));
                        DetectableIndentOptionsProvider.this.myDiscardedOptions.remove(virtualFile);
                    }));
                    actions.add(Separator.getInstance());
                }
            } else if (DetectableIndentOptionsProvider.this.myDiscardedOptions.containsKey(virtualFile)) {
                CommonCodeStyleSettings.IndentOptions discardedOptions = (CommonCodeStyleSettings.IndentOptions)DetectableIndentOptionsProvider.this.myDiscardedOptions.get(virtualFile);
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
                if (document != null) {
                    actions.add(DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.indent.detector.apply", (Object[])new Object[]{IndentStatusBarUIContributor.getIndentInfo((CommonCodeStyleSettings.IndentOptions)discardedOptions), ColorUtil.toHex((Color)JBColor.GRAY)}), e -> {
                        DetectableIndentOptionsProvider.this.myDiscardedOptions.remove(virtualFile);
                        discardedOptions.associateWithDocument(document);
                        FileIndentOptionsProvider.notifyIndentOptionsChanged((Project)project, (PsiFile)file2);
                    }));
                    actions.add(Separator.getInstance());
                }
            }
            return actions.toArray(AnAction.EMPTY_ARRAY);
        }

        @Nullable
        public AnAction createDisableAction(@NotNull Project project) {
            return DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.indent.detector.disable", (Object[])new Object[0]), e -> {
                CodeStyle.getSettings((Project)project).AUTODETECT_INDENTS = false;
                DetectableIndentOptionsProvider.this.myDiscardedOptions.clear();
                FileIndentOptionsProvider.notifyIndentOptionsChanged((Project)project, null);
                DetectableIndentOptionsProvider.showDisabledDetectionNotification(project);
            });
        }

        public String getHint() {
            if (DetectableIndentOptionsProvider.areDetected(this.getIndentOptions())) {
                return "detected";
            }
            return null;
        }

        public boolean areActionsAvailable(@NotNull VirtualFile file2) {
            return DetectableIndentOptionsProvider.areDetected(this.getIndentOptions()) || DetectableIndentOptionsProvider.this.myDiscardedOptions.containsKey(file2);
        }

        @Nullable
        public String getAdvertisementText(@NotNull PsiFile psiFile) {
            if (DetectableIndentOptionsProvider.areDetected(this.getIndentOptions()) && !DetectableIndentOptionsProvider.this.hasBeenAdvertised) {
                String actualOptionsHint = IndentStatusBarUIContributor.getIndentInfo((CommonCodeStyleSettings.IndentOptions)this.getIndentOptions());
                CommonCodeStyleSettings.IndentOptions projectOptions = CodeStyle.getSettings((Project)psiFile.getProject()).getIndentOptions(psiFile.getFileType());
                String projectOptionsHint = IndentStatusBarUIContributor.getIndentInfo((CommonCodeStyleSettings.IndentOptions)projectOptions);
                DetectableIndentOptionsProvider.this.hasBeenAdvertised = true;
                return ApplicationBundle.message((String)"code.style.different.indent.size.detected", (Object[])new Object[]{actualOptionsHint, projectOptionsHint});
            }
            return null;
        }
    }

    private static class ReEnableDetection
    extends DumbAwareAction {
        private final Project myProject;
        private final Notification myNotification;

        private ReEnableDetection(@NotNull Project project, Notification notification) {
            super(ApplicationBundle.message((String)"code.style.indent.provider.notification.re.enable", (Object[])new Object[0]));
            this.myProject = project;
            this.myNotification = notification;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            CodeStyle.getSettings((Project)this.myProject).AUTODETECT_INDENTS = true;
            FileIndentOptionsProvider.notifyIndentOptionsChanged((Project)this.myProject, null);
            this.myNotification.expire();
        }
    }

    private static class ShowIndentDetectionOptionAction
    extends DumbAwareAction {
        private ShowIndentDetectionOptionAction(@Nullable String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ShowSettingsUtilImpl.showSettingsDialog(e.getProject(), "preferences.sourceCode", "detect indent");
        }
    }

    private static class DetectionDisabledNotification
    extends Notification {
        private DetectionDisabledNotification(Project project) {
            super(NOTIFICATION_GROUP.getDisplayId(), ApplicationBundle.message((String)"code.style.indent.detector.notification.content", (Object[])new Object[0]), "", NotificationType.INFORMATION);
            this.addAction((AnAction)new ReEnableDetection(project, this));
            this.addAction((AnAction)new ShowIndentDetectionOptionAction(ApplicationBundle.message((String)"code.style.indent.provider.notification.settings", (Object[])new Object[0])));
        }
    }
}

