/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.statusbar;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.IndentStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.psi.codeStyle.statusbar.CodeStyleStatusBarWidgetProvider;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleStatusBarWidget
extends EditorBasedStatusBarPopup
implements CodeStyleSettingsListener {
    public static final String WIDGET_ID = CodeStyleStatusBarWidget.class.getName();

    public CodeStyleStatusBarWidget(@NotNull Project project) {
        super(project);
    }

    @Override
    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null || !psiFile.isWritable()) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)psiFile);
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions((PsiFile)psiFile);
        if (settings instanceof TransientCodeStyleSettings) {
            return CodeStyleStatusBarWidget.createWidgetState(psiFile, indentOptions, CodeStyleStatusBarWidget.getUiContributor((TransientCodeStyleSettings)settings));
        }
        return CodeStyleStatusBarWidget.createWidgetState(psiFile, indentOptions, (CodeStyleStatusBarUIContributor)CodeStyleStatusBarWidget.getUiContributor(file2, indentOptions));
    }

    @Nullable
    private static CodeStyleStatusBarUIContributor getUiContributor(@NotNull TransientCodeStyleSettings settings) {
        CodeStyleSettingsModifier modifier = settings.getModifier();
        return modifier != null ? modifier.getStatusBarUiContributor(settings) : null;
    }

    @Nullable
    private static IndentStatusBarUIContributor getUiContributor(@NotNull VirtualFile file2, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        FileIndentOptionsProvider provider = CodeStyleStatusBarWidget.findProvider(file2, indentOptions);
        if (provider != null) {
            return provider.getIndentStatusBarUiContributor(indentOptions);
        }
        return null;
    }

    @Nullable
    private static FileIndentOptionsProvider findProvider(@NotNull VirtualFile file2, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        FileIndentOptionsProvider optionsProvider = indentOptions.getFileIndentOptionsProvider();
        if (optionsProvider != null) {
            return optionsProvider;
        }
        for (FileIndentOptionsProvider provider : (FileIndentOptionsProvider[])FileIndentOptionsProvider.EP_NAME.getExtensions()) {
            IndentStatusBarUIContributor uiContributor = provider.getIndentStatusBarUiContributor(indentOptions);
            if (uiContributor == null || !uiContributor.areActionsAvailable(file2)) continue;
            return provider;
        }
        return null;
    }

    private static EditorBasedStatusBarPopup.WidgetState createWidgetState(@NotNull PsiFile psiFile, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable CodeStyleStatusBarUIContributor uiContributor) {
        if (uiContributor != null) {
            return new MyWidgetState(uiContributor.getTooltip(), uiContributor.getStatusText(psiFile), psiFile, indentOptions, uiContributor);
        }
        String indentInfo = IndentStatusBarUIContributor.getIndentInfo((CommonCodeStyleSettings.IndentOptions)indentOptions);
        String tooltip = IndentStatusBarUIContributor.createTooltip((String)indentInfo, null);
        return new MyWidgetState(tooltip, indentInfo, psiFile, indentOptions, null);
    }

    @Nullable
    private PsiFile getPsiFile() {
        Editor editor = this.getEditor();
        Project project = this.getProject();
        if (editor != null && project != null) {
            Document document = editor.getDocument();
            return PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        }
        return null;
    }

    @Override
    @Nullable
    protected ListPopup createPopup(DataContext context) {
        EditorBasedStatusBarPopup.WidgetState state = this.getWidgetState((VirtualFile)context.getData(CommonDataKeys.VIRTUAL_FILE));
        Editor editor = this.getEditor();
        PsiFile psiFile = this.getPsiFile();
        if (state instanceof MyWidgetState && editor != null && psiFile != null) {
            final AnAction[] actions = CodeStyleStatusBarWidget.getActions(((MyWidgetState)state).getContributor(), psiFile);
            ActionGroup actionGroup = new ActionGroup(){

                @NotNull
                public AnAction[] getChildren(@Nullable AnActionEvent e) {
                    return actions;
                }
            };
            return JBPopupFactory.getInstance().createActionGroupPopup(null, actionGroup, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        }
        return null;
    }

    @NotNull
    private static AnAction[] getActions(@Nullable CodeStyleStatusBarUIContributor uiContributor, @NotNull PsiFile psiFile) {
        AnAction disabledAction;
        AnAction[] actions;
        ArrayList allActions = ContainerUtilRt.newArrayList();
        if (uiContributor != null && (actions = uiContributor.getActions(psiFile)) != null) {
            allActions.addAll(Arrays.asList(actions));
        }
        if (uiContributor == null || uiContributor instanceof IndentStatusBarUIContributor && ((IndentStatusBarUIContributor)uiContributor).isShowFileIndentOptionsEnabled()) {
            allActions.add(CodeStyleStatusBarWidgetProvider.createDefaultIndentConfigureAction(psiFile));
        }
        if (uiContributor != null && (disabledAction = uiContributor.createDisableAction(psiFile.getProject())) != null) {
            allActions.add(disabledAction);
        }
        return allActions.toArray(AnAction.EMPTY_ARRAY);
    }

    @Override
    protected void registerCustomListeners() {
        CodeStyleSettingsManager.getInstance((Project)this.getProject()).addListener((CodeStyleSettingsListener)this);
    }

    public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        this.update();
    }

    @Override
    @NotNull
    protected StatusBarWidget createInstance(Project project) {
        return new CodeStyleStatusBarWidget(project);
    }

    @NotNull
    public String ID() {
        return WIDGET_ID;
    }

    @Override
    public void dispose() {
        CodeStyleSettingsManager.removeListener((Project)this.myProject, (CodeStyleSettingsListener)this);
        super.dispose();
    }

    @Override
    protected void afterVisibleUpdate(@NotNull EditorBasedStatusBarPopup.WidgetState state) {
        String message;
        MyWidgetState codeStyleWidgetState;
        CodeStyleStatusBarUIContributor uiContributor;
        if (state instanceof MyWidgetState && (uiContributor = (codeStyleWidgetState = (MyWidgetState)state).getContributor()) != null && (message = uiContributor.getAdvertisementText(codeStyleWidgetState.getPsiFile())) != null) {
            this.advertise(message);
        }
    }

    private void advertise(@NotNull String message) {
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        alarm.addRequest(() -> {
            BalloonBuilder builder2 = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(message));
            JComponent statusBarComponent = this.getComponent();
            Balloon balloon = builder2.setCalloutShift(statusBarComponent.getHeight() / 2).setDisposable((Disposable)this).setHideOnClickOutside(true).createBalloon();
            balloon.showInCenterOf(statusBarComponent);
        }, 500, ModalityState.NON_MODAL);
    }

    private static class MyWidgetState
    extends EditorBasedStatusBarPopup.WidgetState {
        @NotNull
        private final CommonCodeStyleSettings.IndentOptions myIndentOptions;
        @Nullable
        private final CodeStyleStatusBarUIContributor myContributor;
        @NotNull
        private final PsiFile myPsiFile;

        protected MyWidgetState(String toolTip, String text, @NotNull PsiFile psiFile, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable CodeStyleStatusBarUIContributor uiContributor) {
            super(toolTip, text, true);
            this.myIndentOptions = indentOptions;
            this.myContributor = uiContributor;
            this.myPsiFile = psiFile;
            if (uiContributor != null) {
                this.setIcon(uiContributor.getIcon());
            }
        }

        @Nullable
        public CodeStyleStatusBarUIContributor getContributor() {
            return this.myContributor;
        }

        @NotNull
        public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
            return this.myIndentOptions;
        }

        @NotNull
        public PsiFile getPsiFile() {
            return this.myPsiFile;
        }
    }
}

