/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.statusbar;

import com.intellij.application.options.CodeStyleConfigurableWrapper;
import com.intellij.application.options.CodeStyleSchemesConfigurable;
import com.intellij.application.options.codeStyle.OtherFileTypesCodeStyleConfigurable;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.statusbar.CodeStyleStatusBarWidget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleStatusBarWidgetProvider
implements StatusBarWidgetProvider {
    @Nullable
    public StatusBarWidget getWidget(@NotNull Project project) {
        return new CodeStyleStatusBarWidget(project);
    }

    @NotNull
    public String getAnchor() {
        return StatusBar.Anchors.after((String)"Encoding");
    }

    @NotNull
    public static DumbAwareAction createDefaultIndentConfigureAction(@NotNull PsiFile psiFile) {
        return DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.widget.configure.indents", (Object[])new Object[]{psiFile.getLanguage().getDisplayName()}), event -> {
            String id = CodeStyleStatusBarWidgetProvider.findCodeStyleConfigurableId(psiFile);
            ShowSettingsUtilImpl.showSettingsDialog(psiFile.getProject(), id, "Tab,Indent");
        });
    }

    @NotNull
    public static String findCodeStyleConfigurableId(@NotNull PsiFile file2) {
        CodeStyleSchemesConfigurable topConfigurable;
        SearchableConfigurable result2;
        String name;
        Project project = file2.getProject();
        Language language = file2.getLanguage();
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.findUsingBaseLanguage((Language)language);
        if (provider != null && provider.getIndentOptionsEditor() != null && (name = provider.getConfigurableDisplayName()) != null && (result2 = (topConfigurable = new CodeStyleSchemesConfigurable(project)).findSubConfigurable(name)) != null) {
            return result2.getId();
        }
        return CodeStyleConfigurableWrapper.getConfigurableId(OtherFileTypesCodeStyleConfigurable.DISPLAY_NAME);
    }
}

