/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWhiteSpaceFormattingStrategy
implements WhiteSpaceFormattingStrategy {
    @Override
    public boolean replaceDefaultStrategy() {
        return false;
    }

    @Override
    @NotNull
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull CharSequence text, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings, ASTNode nodeAfter) {
        return whiteSpaceText;
    }

    @Override
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull PsiElement startElement, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings) {
        assert (startElement.getTextRange().contains(startOffset)) : String.format("Element: %s, range: %s, offset: %d", startElement, startElement.getTextRange(), startOffset);
        StringBuilder buffer = new StringBuilder();
        PsiElement current = startElement;
        while (current != null && current.getTextRange().getStartOffset() < endOffset) {
            TextRange range2 = current.getTextRange();
            String text = current.getText();
            if (!StringUtil.isEmpty((String)text)) {
                int start2;
                int n = start2 = startOffset > range2.getStartOffset() ? startOffset - range2.getStartOffset() : 0;
                if (start2 < text.length()) {
                    int end;
                    int n2 = end = endOffset < range2.getEndOffset() ? text.length() - (range2.getEndOffset() - endOffset) : text.length();
                    if (end > start2) {
                        if (start2 == 0 && end == text.length()) {
                            buffer.append(text);
                        } else {
                            buffer.append(text, start2, end);
                        }
                    }
                }
            }
            current = AbstractWhiteSpaceFormattingStrategy.next(current);
        }
        return this.adjustWhiteSpaceIfNecessary(whiteSpaceText, buffer, 0, endOffset - startOffset, codeStyleSettings, null);
    }

    @Nullable
    private static PsiElement next(@NotNull PsiElement element) {
        for (PsiElement anchor2 = element; anchor2 != null; anchor2 = anchor2.getParent()) {
            PsiElement result2 = element.getNextSibling();
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Override
    public boolean containsWhitespacesOnly(@NotNull ASTNode node) {
        return false;
    }

    @Override
    public boolean addWhitespace(@NotNull ASTNode treePrev, @NotNull LeafElement whiteSpaceElement) {
        return false;
    }
}

