/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.InjectedLanguageBlockBuilder;
import com.intellij.psi.formatter.xml.AnotherLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlInjectedLanguageBlockBuilder
extends InjectedLanguageBlockBuilder {
    private final XmlFormattingPolicy myXmlFormattingPolicy;

    public XmlInjectedLanguageBlockBuilder(XmlFormattingPolicy formattingPolicy) {
        this.myXmlFormattingPolicy = formattingPolicy;
    }

    @Override
    @NotNull
    public Block createInjectedBlock(@NotNull ASTNode node, @NotNull Block originalBlock, Indent indent, int offset, TextRange range2, @Nullable Language language) {
        return new AnotherLanguageBlockWrapper(node, this.myXmlFormattingPolicy, originalBlock, indent, offset, range2);
    }

    @Override
    public Block createBlockBeforeInjection(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, TextRange range2) {
        return new XmlBlock(node, wrap, alignment, this.myXmlFormattingPolicy, indent, range2);
    }

    @Override
    public Block createBlockAfterInjection(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, TextRange range2) {
        return new XmlBlock(node, wrap, alignment, this.myXmlFormattingPolicy, indent, range2);
    }

    @Override
    public CodeStyleSettings getSettings() {
        return this.myXmlFormattingPolicy.getSettings();
    }

    @Override
    public boolean canProcessFragment(String text, ASTNode injectionHost) {
        IElementType type = injectionHost.getElementType();
        if (type == XmlElementType.XML_TEXT) {
            text = text.trim();
            text = text.replace("<![CDATA[", "");
            text = text.replace("]]>", "");
        } else if (type == XmlElementType.XML_COMMENT) {
            return true;
        }
        return text.isEmpty();
    }
}

