/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.graph.OutboundSemiGraph;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.DebugUtil");
    public static boolean CHECK = false;
    public static final boolean DO_EXPENSIVE_CHECKS;
    public static final boolean CHECK_INSIDE_ATOMIC_ACTION_ENABLED;
    private static final ThreadLocal<Object> ourPsiModificationTrace;
    private static final ThreadLocal<Integer> ourPsiModificationDepth;
    private static final Set<Integer> ourNonTransactedTraces;

    public static String psiTreeToString(@NotNull PsiElement element, boolean skipWhitespaces) {
        ASTNode node = SourceTreeToPsiMap.psiElementToTree(element);
        assert (node != null) : element;
        return DebugUtil.treeToString(node, skipWhitespaces);
    }

    public static String treeToString(@NotNull ASTNode root, boolean skipWhitespaces) {
        StringBuilder buffer = new StringBuilder();
        DebugUtil.treeToBuffer(buffer, root, 0, skipWhitespaces, false, false, true);
        return buffer.toString();
    }

    public static String nodeTreeToString(@NotNull ASTNode root, boolean skipWhitespaces) {
        StringBuilder buffer = new StringBuilder();
        DebugUtil.treeToBuffer(buffer, root, 0, skipWhitespaces, false, false, false);
        return buffer.toString();
    }

    public static String treeToString(@NotNull ASTNode root, boolean skipWhitespaces, boolean showRanges) {
        StringBuilder buffer = new StringBuilder();
        DebugUtil.treeToBuffer(buffer, root, 0, skipWhitespaces, showRanges, false, true);
        return buffer.toString();
    }

    public static void treeToBuffer(@NotNull Appendable buffer, @NotNull ASTNode root, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges, boolean usePsi) {
        DebugUtil.treeToBuffer(buffer, root, indent, skipWhiteSpaces, showRanges, showChildrenRanges, usePsi, null);
    }

    public static void treeToBuffer(@NotNull Appendable buffer, @NotNull ASTNode root, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges, boolean usePsi, @Nullable PairConsumer<? super PsiElement, Consumer<PsiElement>> extra) {
        ((TreeElement)root).acceptTree(new TreeToBuffer(buffer, indent, skipWhiteSpaces, showRanges, showChildrenRanges, usePsi, extra));
    }

    public static String lightTreeToString(@NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, boolean skipWhitespaces) {
        StringBuilder buffer = new StringBuilder();
        DebugUtil.lightTreeToBuffer(tree, (LighterASTNode)tree.getRoot(), buffer, 0, skipWhitespaces);
        return buffer.toString();
    }

    public static void lightTreeToBuffer(@NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode node, @NotNull Appendable buffer, int indent, boolean skipWhiteSpaces) {
        IElementType tokenType = node.getTokenType();
        if (skipWhiteSpaces && tokenType == TokenType.WHITE_SPACE) {
            return;
        }
        boolean isLeaf = node instanceof LighterASTTokenNode;
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indent);
        try {
            if (tokenType == TokenType.ERROR_ELEMENT) {
                buffer.append("PsiErrorElement:").append(PsiBuilderImpl.getErrorMessage(node));
            } else if (tokenType == TokenType.WHITE_SPACE) {
                buffer.append("PsiWhiteSpace");
            } else {
                buffer.append(isLeaf ? "PsiElement" : "Element").append('(').append(tokenType.toString()).append(')');
            }
            if (isLeaf) {
                String text = ((LighterASTTokenNode)node).getText().toString();
                buffer.append("('").append(DebugUtil.fixWhiteSpaces(text)).append("')");
            }
            buffer.append('\n');
            if (!isLeaf) {
                Ref kids = new Ref();
                int numKids = tree.getChildren((Object)node, kids);
                if (numKids == 0) {
                    StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)(indent + 2));
                    buffer.append("<empty list>\n");
                } else {
                    for (int i = 0; i < numKids; ++i) {
                        DebugUtil.lightTreeToBuffer(tree, ((LighterASTNode[])kids.get())[i], buffer, indent + 2, skipWhiteSpaces);
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static String stubTreeToString(Stub root) {
        StringBuilder builder2 = new StringBuilder();
        DebugUtil.stubTreeToBuffer(root, builder2, 0);
        return builder2.toString();
    }

    public static void stubTreeToBuffer(Stub node, Appendable buffer, int indent) {
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indent);
        try {
            ObjectStubSerializer stubType = node.getStubType();
            if (stubType != null) {
                buffer.append(stubType.toString()).append(':');
            }
            buffer.append(node.toString()).append('\n');
            List children2 = node.getChildrenStubs();
            for (Stub child2 : children2) {
                DebugUtil.stubTreeToBuffer(child2, buffer, indent + 2);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void treeToBufferWithUserData(Appendable buffer, TreeElement root, int indent, boolean skipWhiteSpaces) {
        if (skipWhiteSpaces && root.getElementType() == TokenType.WHITE_SPACE) {
            return;
        }
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indent);
        try {
            PsiElement psi = SourceTreeToPsiMap.treeElementToPsi(root);
            assert (psi != null) : root;
            if (root instanceof CompositeElement) {
                buffer.append(psi.toString());
            } else {
                String text = DebugUtil.fixWhiteSpaces(root.getText());
                buffer.append(root.toString()).append("('").append(text).append("')");
            }
            buffer.append(root.getUserDataString());
            buffer.append("\n");
            if (root instanceof CompositeElement) {
                PsiElement[] children2;
                for (PsiElement child2 : children2 = psi.getChildren()) {
                    DebugUtil.treeToBufferWithUserData(buffer, (TreeElement)SourceTreeToPsiMap.psiElementToTree(child2), indent + 2, skipWhiteSpaces);
                }
                if (children2.length == 0) {
                    StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)(indent + 2));
                    buffer.append("<empty list>\n");
                }
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void treeToBufferWithUserData(Appendable buffer, PsiElement root, int indent, boolean skipWhiteSpaces) {
        if (skipWhiteSpaces && root instanceof PsiWhiteSpace) {
            return;
        }
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indent);
        try {
            PsiElement[] children2;
            if (root instanceof CompositeElement) {
                buffer.append(root.toString());
            } else {
                String text = DebugUtil.fixWhiteSpaces(root.getText());
                buffer.append(root.toString()).append("('").append(text).append("')");
            }
            buffer.append(((UserDataHolderBase)root).getUserDataString());
            buffer.append("\n");
            for (PsiElement child2 : children2 = root.getChildren()) {
                DebugUtil.treeToBufferWithUserData(buffer, child2, indent + 2, skipWhiteSpaces);
            }
            if (children2.length == 0) {
                StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)(indent + 2));
                buffer.append("<empty list>\n");
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static void doCheckTreeStructure(@Nullable ASTNode anyElement) {
        if (anyElement == null) {
            return;
        }
        ASTNode root = anyElement;
        while (root.getTreeParent() != null) {
            root = root.getTreeParent();
        }
        if (root instanceof CompositeElement) {
            DebugUtil.checkSubtree((CompositeElement)root);
        }
    }

    private static void checkSubtree(CompositeElement root) {
        if (root.rawFirstChild() == null) {
            if (root.rawLastChild() != null) {
                throw new IncorrectTreeStructureException(root, "firstChild == null, but lastChild != null");
            }
        } else {
            for (TreeElement child2 = root.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
                if (child2 instanceof CompositeElement) {
                    DebugUtil.checkSubtree((CompositeElement)child2);
                }
                if (child2.getTreeParent() != root) {
                    throw new IncorrectTreeStructureException(child2, "child has wrong parent value");
                }
                if (child2 == root.getFirstChildNode()) {
                    if (child2.getTreePrev() != null) {
                        throw new IncorrectTreeStructureException(root, "firstChild.prev != null");
                    }
                } else {
                    if (child2.getTreePrev() == null) {
                        throw new IncorrectTreeStructureException(child2, "not first child has prev == null");
                    }
                    if (child2.getTreePrev().getTreeNext() != child2) {
                        throw new IncorrectTreeStructureException(child2, "element.prev.next != element");
                    }
                }
                if (child2.getTreeNext() != null || root.getLastChildNode() == child2) continue;
                throw new IncorrectTreeStructureException(child2, "not last child has next == null");
            }
        }
    }

    public static void checkParentChildConsistent(@NotNull ASTNode element) {
        ASTNode treeParent = element.getTreeParent();
        if (treeParent == null) {
            return;
        }
        Object[] elements = treeParent.getChildren(null);
        if (ArrayUtil.find((Object[])elements, (Object)element) == -1) {
            throw new IncorrectTreeStructureException(element, "child cannot be found among parents children");
        }
    }

    public static void checkSameCharTabs(@NotNull ASTNode element1, @NotNull ASTNode element2) {
        CharTable toCharTab;
        CharTable fromCharTab = SharedImplUtil.findCharTableByTree(element1);
        LOG.assertTrue(fromCharTab == (toCharTab = SharedImplUtil.findCharTableByTree(element2)));
    }

    public static String psiToString(@NotNull PsiElement element, boolean skipWhitespaces) {
        return DebugUtil.psiToString(element, skipWhitespaces, false);
    }

    public static String psiToString(@NotNull PsiElement root, boolean skipWhiteSpaces, boolean showRanges) {
        return DebugUtil.psiToString(root, skipWhiteSpaces, showRanges, null);
    }

    public static String psiToString(@NotNull PsiElement root, boolean skipWhiteSpaces, boolean showRanges, PairConsumer<? super PsiElement, Consumer<PsiElement>> extra) {
        StringBuilder buffer = new StringBuilder();
        DebugUtil.psiToBuffer(buffer, root, skipWhiteSpaces, showRanges, extra);
        return buffer.toString();
    }

    @NotNull
    public static String psiToStringIgnoringNonCode(@NotNull PsiElement element) {
        StringBuilder buffer = new StringBuilder();
        ((TreeElement)element.getNode()).acceptTree(new TreeToBuffer((Appendable)buffer, 0, true, false, false, false, null){

            @Override
            protected boolean shouldSkipNode(TreeElement node) {
                return super.shouldSkipNode(node) || node instanceof PsiErrorElement || node instanceof PsiComment || node instanceof LeafPsiElement && StringUtil.isEmptyOrSpaces((String)node.getText()) || node instanceof OuterLanguageElement;
            }

            @Override
            protected boolean showEmptyChildren() {
                return false;
            }
        });
        return buffer.toString();
    }

    private static void psiToBuffer(Appendable buffer, PsiElement root, boolean skipWhiteSpaces, boolean showRanges, PairConsumer<? super PsiElement, Consumer<PsiElement>> extra) {
        ASTNode node = root.getNode();
        if (node == null) {
            DebugUtil.psiToBuffer(buffer, root, 0, skipWhiteSpaces, showRanges, showRanges, extra);
        } else {
            DebugUtil.treeToBuffer(buffer, node, 0, skipWhiteSpaces, showRanges, showRanges, true, extra);
        }
    }

    public static void psiToBuffer(@NotNull Appendable buffer, @NotNull PsiElement root, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges) {
        DebugUtil.psiToBuffer(buffer, root, indent, skipWhiteSpaces, showRanges, showChildrenRanges, null);
    }

    public static void psiToBuffer(@NotNull Appendable buffer, @NotNull PsiElement root, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges, PairConsumer<? super PsiElement, Consumer<PsiElement>> extra) {
        if (skipWhiteSpaces && root instanceof PsiWhiteSpace) {
            return;
        }
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indent);
        try {
            buffer.append(root.toString());
            PsiElement child2 = root.getFirstChild();
            if (child2 == null) {
                String text = root.getText();
                assert (text != null) : "text is null for <" + root + ">";
                buffer.append("('").append(DebugUtil.fixWhiteSpaces(text)).append("')");
            }
            if (showRanges) {
                buffer.append(root.getTextRange().toString());
            }
            buffer.append("\n");
            while (child2 != null) {
                DebugUtil.psiToBuffer(buffer, child2, indent + 2, skipWhiteSpaces, showChildrenRanges, showChildrenRanges, extra);
                child2 = child2.getNextSibling();
            }
            if (extra != null) {
                extra.consume((Object)root, element -> DebugUtil.psiToBuffer(buffer, element, indent + 2, skipWhiteSpaces, showChildrenRanges, showChildrenRanges, null));
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static String fixWhiteSpaces(String text) {
        text = StringUtil.replace((String)text, (String)"\n", (String)"\\n");
        text = StringUtil.replace((String)text, (String)"\r", (String)"\\r");
        text = StringUtil.replace((String)text, (String)"\t", (String)"\\t");
        return text;
    }

    public static String currentStackTrace() {
        return ExceptionUtil.currentStackTrace();
    }

    @Deprecated
    public static void startPsiModification(@Nullable String trace) {
        Integer depth;
        if (!PsiInvalidElementAccessException.isTrackingInvalidation()) {
            return;
        }
        if (ourPsiModificationTrace.get() == null) {
            ourPsiModificationTrace.set(trace != null ? trace : new Throwable());
        }
        if ((depth = ourPsiModificationDepth.get()) == null) {
            depth = 0;
        }
        ourPsiModificationDepth.set(depth + 1);
    }

    @Deprecated
    public static void finishPsiModification() {
        if (!PsiInvalidElementAccessException.isTrackingInvalidation()) {
            return;
        }
        Integer depth = ourPsiModificationDepth.get();
        if (depth == null) {
            LOG.warn("Unmatched PSI modification end", new Throwable());
            depth = 0;
        } else {
            Integer n = depth;
            Integer n2 = depth = Integer.valueOf(depth - 1);
            ourPsiModificationDepth.set(depth);
        }
        if (depth == 0) {
            ourPsiModificationTrace.set(null);
        }
    }

    public static <T extends Throwable> void performPsiModification(String trace, @NotNull ThrowableRunnable<T> runnable2) throws T {
        DebugUtil.startPsiModification(trace);
        try {
            runnable2.run();
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    public static <T, E extends Throwable> T performPsiModification(String trace, @NotNull ThrowableComputable<T, E> runnable2) throws E {
        DebugUtil.startPsiModification(trace);
        try {
            Object object = runnable2.compute();
            return (T)object;
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    public static void onInvalidated(@NotNull ASTNode treeElement) {
        Object trace = DebugUtil.calcInvalidationTrace(treeElement);
        if (trace != null) {
            PsiInvalidElementAccessException.setInvalidationTrace((UserDataHolder)treeElement, (Object)trace);
        }
    }

    public static void onInvalidated(@NotNull PsiElement o) {
        Object trace = PsiInvalidElementAccessException.getInvalidationTrace((UserDataHolder)o);
        if (trace != null) {
            return;
        }
        PsiInvalidElementAccessException.setInvalidationTrace((UserDataHolder)o, (Object)DebugUtil.currentInvalidationTrace());
    }

    public static void onInvalidated(@NotNull FileViewProvider provider) {
        Object trace = DebugUtil.calcInvalidationTrace(null);
        if (trace != null) {
            PsiInvalidElementAccessException.setInvalidationTrace((UserDataHolder)provider, (Object)trace);
        }
    }

    @Nullable
    private static Object calcInvalidationTrace(@Nullable ASTNode treeElement) {
        if (!PsiInvalidElementAccessException.isTrackingInvalidation()) {
            return null;
        }
        if (PsiInvalidElementAccessException.findInvalidationTrace((ASTNode)treeElement) != null) {
            return null;
        }
        return DebugUtil.currentInvalidationTrace();
    }

    @NotNull
    private static Object currentInvalidationTrace() {
        Object trace = ourPsiModificationTrace.get();
        if (trace == null && ourNonTransactedTraces.add(ExceptionUtil.getThrowableText((Throwable)((Throwable)(trace = new Throwable()))).hashCode())) {
            LOG.info("PSI invalidated outside transaction", (Throwable)trace);
        }
        return trace;
    }

    public static void revalidateNode(@NotNull ASTNode element) {
        PsiInvalidElementAccessException.setInvalidationTrace((UserDataHolder)element, null);
    }

    public static void sleep(long millis) {
        TimeoutUtil.sleep((long)millis);
    }

    public static void checkTreeStructure(ASTNode element) {
        if (CHECK) {
            DebugUtil.doCheckTreeStructure(element);
        }
    }

    @NotNull
    public static String diagnosePsiDocumentInconsistency(@NotNull PsiElement element, @NotNull Document document) {
        int docLength;
        FileViewProvider actualViewProvider;
        PsiUtilCore.ensureValid((PsiElement)element);
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            return "no file for " + element + " of " + element.getClass();
        }
        PsiUtilCore.ensureValid((PsiElement)file2);
        FileViewProvider viewProvider = file2.getViewProvider();
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file2.getProject());
        Document actualDocument = manager.getDocument(file2);
        String fileDiagnostics = "File[" + file2 + " " + file2.getName() + ", " + file2.getLanguage() + ", " + viewProvider + "]";
        if (actualDocument != document) {
            return "wrong document for " + fileDiagnostics + "; expected " + document + "; actual " + actualDocument;
        }
        PsiFile cachedPsiFile = manager.getCachedPsiFile(document);
        FileViewProvider fileViewProvider = actualViewProvider = cachedPsiFile == null ? null : cachedPsiFile.getViewProvider();
        if (actualViewProvider != viewProvider) {
            return "wrong view provider for " + document + ", expected " + viewProvider + "; actual " + actualViewProvider;
        }
        if (!manager.isCommitted(document)) {
            return "not committed document " + document + ", " + fileDiagnostics;
        }
        int fileLength = file2.getTextLength();
        if (fileLength != (docLength = document.getTextLength())) {
            return "file/doc text length different, " + fileDiagnostics + " file.length=" + fileLength + "; doc.length=" + docLength;
        }
        return "unknown inconsistency in " + fileDiagnostics;
    }

    public static <T> String graphToString(InboundSemiGraph<T> graph2) {
        StringBuilder buffer = new StringBuilder();
        DebugUtil.printNodes(graph2.getNodes().iterator(), node -> graph2.getIn(node), 0, new HashSet(), buffer);
        return buffer.toString();
    }

    public static <T> String graphToString(OutboundSemiGraph<T> graph2) {
        StringBuilder buffer = new StringBuilder();
        DebugUtil.printNodes(graph2.getNodes().iterator(), node -> graph2.getOut(node), 0, new HashSet(), buffer);
        return buffer.toString();
    }

    private static <T> void printNodes(Iterator<? extends T> nodes, Function<? super T, ? extends Iterator<T>> getter, int indent, Set<? super T> visited, StringBuilder buffer) {
        while (nodes.hasNext()) {
            T node = nodes.next();
            StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indent);
            buffer.append(node);
            if (visited.add(node)) {
                buffer.append('\n');
                DebugUtil.printNodes((Iterator)getter.fun(node), getter, indent + 2, visited, buffer);
                continue;
            }
            buffer.append(" [...]\n");
        }
    }

    static {
        Application application = ApplicationManager.getApplication();
        CHECK_INSIDE_ATOMIC_ACTION_ENABLED = DO_EXPENSIVE_CHECKS = application != null && application.isUnitTestMode();
        ourPsiModificationTrace = new ThreadLocal();
        ourPsiModificationDepth = new ThreadLocal();
        ourNonTransactedTraces = ContainerUtil.newConcurrentSet();
    }

    public static class IncorrectTreeStructureException
    extends RuntimeException {
        private final ASTNode myElement;

        public IncorrectTreeStructureException(ASTNode element, String message) {
            super(message);
            this.myElement = element;
        }

        public ASTNode getElement() {
            return this.myElement;
        }
    }

    private static class TreeToBuffer
    extends RecursiveTreeElementWalkingVisitor {
        final Appendable buffer;
        final boolean skipWhiteSpaces;
        final boolean showRanges;
        final boolean showChildrenRanges;
        final boolean usePsi;
        final PairConsumer<? super PsiElement, Consumer<PsiElement>> extra;
        int indent;

        TreeToBuffer(Appendable buffer, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges, boolean usePsi, PairConsumer<? super PsiElement, Consumer<PsiElement>> extra) {
            this.buffer = buffer;
            this.skipWhiteSpaces = skipWhiteSpaces;
            this.showRanges = showRanges;
            this.showChildrenRanges = showChildrenRanges;
            this.usePsi = usePsi;
            this.extra = extra;
            this.indent = indent;
        }

        @Override
        protected void visitNode(TreeElement root) {
            if (this.shouldSkipNode(root)) {
                this.indent += 2;
                return;
            }
            StringUtil.repeatSymbol((Appendable)this.buffer, (char)' ', (int)this.indent);
            try {
                if (root instanceof CompositeElement) {
                    if (this.usePsi) {
                        PsiElement psiElement = root.getPsi();
                        if (psiElement != null) {
                            this.buffer.append(psiElement.toString());
                        } else {
                            this.buffer.append(root.getElementType().toString());
                        }
                    } else {
                        this.buffer.append(root.toString());
                    }
                } else {
                    String text = DebugUtil.fixWhiteSpaces(root.getText());
                    this.buffer.append(root.toString()).append("('").append(text).append("')");
                }
                if (this.showRanges) {
                    this.buffer.append(root.getTextRange().toString());
                }
                this.buffer.append("\n");
                this.indent += 2;
                if (root instanceof CompositeElement && root.getFirstChildNode() == null && this.showEmptyChildren()) {
                    StringUtil.repeatSymbol((Appendable)this.buffer, (char)' ', (int)this.indent);
                    this.buffer.append("<empty list>\n");
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            super.visitNode(root);
        }

        protected boolean showEmptyChildren() {
            return true;
        }

        protected boolean shouldSkipNode(TreeElement node) {
            return this.skipWhiteSpaces && node.getElementType() == TokenType.WHITE_SPACE;
        }

        @Override
        protected void elementFinished(@NotNull ASTNode e) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = this.extra != null && this.usePsi && e instanceof CompositeElement ? e.getPsi() : null;
            if (psiElement != null) {
                this.extra.consume((Object)psiElement, element -> DebugUtil.treeToBuffer(this.buffer, element.getNode(), this.indent, this.skipWhiteSpaces, this.showRanges, this.showChildrenRanges, true, null));
            }
            this.indent -= 2;
        }
    }
}

