/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.TreeAspectEvent;
import com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DiffLog
implements DiffTreeChangeBuilder<ASTNode, ASTNode> {
    private final List<LogEntry> myEntries = new ArrayList<LogEntry>();

    @NotNull
    public TreeChangeEventImpl performActualPsiChange(@NotNull PsiFile file2) {
        TreeAspect modelAspect = (TreeAspect)PomManager.getModel((Project)file2.getProject()).getModelAspect(TreeAspect.class);
        TreeChangeEventImpl event = new TreeChangeEventImpl(modelAspect, ((PsiFileImpl)file2).calcTreeElement());
        for (LogEntry entry : this.myEntries) {
            entry.doActualPsiChange(file2, event);
        }
        file2.subtreeChanged();
        return event;
    }

    public void nodeReplaced(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
        if (oldNode instanceof FileElement && newNode instanceof FileElement) {
            this.appendReplaceFileElement((FileElement)oldNode, (FileElement)newNode);
        } else {
            this.myEntries.add(new ReplaceEntry(oldNode, newNode));
        }
    }

    void appendReplaceElementWithEvents(@NotNull CompositeElement oldRoot, @NotNull CompositeElement newRoot) {
        this.myEntries.add(new ReplaceElementWithEvents(oldRoot, newRoot));
    }

    void appendReplaceFileElement(@NotNull FileElement oldNode, @NotNull FileElement newNode) {
        this.myEntries.add(new ReplaceFileElement(oldNode, newNode));
    }

    public void nodeDeleted(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
        this.myEntries.add(new DeleteEntry(oldParent, oldNode));
    }

    public void nodeInserted(@NotNull ASTNode oldParent, @NotNull ASTNode newNode, int pos) {
        this.myEntries.add(new InsertEntry(oldParent, newNode, pos));
    }

    private static PsiElement getPsi(ASTNode node, PsiFile file2) {
        node.putUserData(TreeUtil.CONTAINING_FILE_KEY_AFTER_REPARSE, (Object)((PsiFileImpl)file2).getTreeElement());
        PsiElement psiChild = file2.isPhysical() ? node.getPsi() : null;
        node.putUserData(TreeUtil.CONTAINING_FILE_KEY_AFTER_REPARSE, null);
        return psiChild;
    }

    public void doActualPsiChange(final @NotNull PsiFile file2) {
        CodeStyleManager.getInstance((Project)file2.getProject()).performActionWithFormatterDisabled(() -> {
            FileViewProvider viewProvider = file2.getViewProvider();
            PsiLock psiLock = ((AbstractFileViewProvider)viewProvider).getFilePsiLock();
            synchronized (psiLock) {
                viewProvider.beforeContentsSynchronized();
                Document document = viewProvider.getDocument();
                PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)file2.getProject());
                PsiToDocumentSynchronizer.DocumentChangeTransaction transaction = documentManager.getSynchronizer().getTransaction(document);
                if (transaction == null) {
                    final PomModel model = PomManager.getModel((Project)file2.getProject());
                    model.runTransaction((PomTransaction)new PomTransactionBase((PsiElement)file2, model.getModelAspect(TreeAspect.class)){

                        public PomModelEvent runInner() {
                            return new TreeAspectEvent(model, DiffLog.this.performActualPsiChange(file2));
                        }
                    });
                } else {
                    this.performActualPsiChange(file2);
                }
            }
        });
    }

    private static class ReplaceElementWithEvents
    extends LogEntry {
        @NotNull
        private final CompositeElement myOldRoot;
        @NotNull
        private final CompositeElement myNewRoot;

        private ReplaceElementWithEvents(@NotNull CompositeElement oldRoot, @NotNull CompositeElement newRoot) {
            this.myOldRoot = oldRoot;
            this.myNewRoot = newRoot;
            TreeUtil.ensureParsed(this.myOldRoot.getFirstChildNode());
            TreeUtil.ensureParsed(this.myNewRoot.getFirstChildNode());
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull TreeChangeEventImpl event) {
            this.myOldRoot.replaceAllChildrenToChildrenOf(this.myNewRoot);
        }
    }

    private static class ReplaceFileElement
    extends LogEntry {
        @NotNull
        private final FileElement myOldNode;
        @NotNull
        private final FileElement myNewNode;

        private ReplaceFileElement(@NotNull FileElement oldNode, @NotNull FileElement newNode) {
            this.myOldNode = oldNode;
            this.myNewNode = newNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull TreeChangeEventImpl event) {
            TreeElement firstChildNode;
            PsiFileImpl fileImpl = (PsiFileImpl)file2;
            int oldLength = this.myOldNode.getTextLength();
            PsiManagerImpl manager = (PsiManagerImpl)fileImpl.getManager();
            BlockSupportImpl.sendBeforeChildrenChangeEvent(manager, (PsiElement)fileImpl, false);
            if (this.myOldNode.getFirstChildNode() != null) {
                this.myOldNode.rawRemoveAllChildren();
            }
            if ((firstChildNode = this.myNewNode.getFirstChildNode()) != null) {
                this.myOldNode.rawAddChildren(firstChildNode);
            }
            fileImpl.calcTreeElement().setCharTable(this.myNewNode.getCharTable());
            this.myOldNode.subtreeChanged();
            BlockSupportImpl.sendAfterChildrenChangedEvent(manager, fileImpl, oldLength, false);
        }
    }

    private static class InsertEntry
    extends LogEntry {
        @NotNull
        private final CompositeElement myOldParent;
        @NotNull
        private final TreeElement myNewNode;
        private final int myPos;

        private InsertEntry(@NotNull ASTNode oldParent, @NotNull ASTNode newNode, int pos) {
            assert (pos >= 0) : pos;
            this.myOldParent = (CompositeElement)oldParent;
            this.myNewNode = (TreeElement)newNode;
            this.myPos = pos;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull TreeChangeEventImpl changeEvent) {
            TreeElement anchor2 = null;
            TreeElement firstChildNode = this.myOldParent.getFirstChildNode();
            for (int i = 0; i < this.myPos; ++i) {
                anchor2 = anchor2 == null ? firstChildNode : anchor2.getTreeNext();
            }
            PsiElement psiParent = this.myOldParent.getPsi();
            PsiElement psiChild = DiffLog.getPsi(this.myNewNode, file2);
            if (psiParent != null && psiChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file2.getManager());
                event.setParent(psiParent);
                event.setChild(psiChild);
                event.setFile(file2);
                ((PsiManagerEx)file2.getManager()).beforeChildAddition(event);
            }
            changeEvent.addElementaryChange(this.myOldParent);
            this.myNewNode.rawRemove();
            if (anchor2 != null) {
                anchor2.rawInsertAfterMe(this.myNewNode);
            } else if (firstChildNode != null) {
                firstChildNode.rawInsertBeforeMe(this.myNewNode);
            } else {
                this.myOldParent.rawAddChildren(this.myNewNode);
            }
            this.myNewNode.clearCaches();
            this.myOldParent.subtreeChanged();
            DebugUtil.checkTreeStructure(this.myOldParent);
        }
    }

    private static class DeleteEntry
    extends LogEntry {
        @NotNull
        private final CompositeElement myOldParent;
        @NotNull
        private final TreeElement myOldNode;

        private DeleteEntry(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
            this.myOldParent = (CompositeElement)oldParent;
            this.myOldNode = (TreeElement)oldNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull TreeChangeEventImpl changeEvent) {
            PsiElement psiChild;
            PsiElement psiParent = this.myOldParent.getPsi();
            PsiElement psiElement = psiChild = file2.isPhysical() ? this.myOldNode.getPsi() : null;
            if (psiParent != null && psiChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file2.getManager());
                event.setParent(psiParent);
                event.setChild(psiChild);
                event.setFile(file2);
                ((PsiManagerEx)file2.getManager()).beforeChildRemoval(event);
            }
            changeEvent.addElementaryChange(this.myOldParent);
            this.myOldNode.rawRemove();
            this.myOldParent.subtreeChanged();
            DebugUtil.checkTreeStructure(this.myOldParent);
        }
    }

    private static class ReplaceEntry
    extends LogEntry {
        private final TreeElement myOldChild;
        private final TreeElement myNewChild;

        private ReplaceEntry(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
            this.myOldChild = (TreeElement)oldNode;
            this.myNewChild = (TreeElement)newNode;
            ASTNode parent = oldNode.getTreeParent();
            assert (parent != null) : "old:" + oldNode + " new:" + newNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull TreeChangeEventImpl changeEvent) {
            PsiElement psiOldChild;
            CompositeElement parent = this.myOldChild.getTreeParent();
            assert (parent != null) : "old:" + this.myOldChild + " new:" + this.myNewChild;
            PsiElement psiParent = parent.getPsi();
            PsiElement psiElement = psiOldChild = file2.isPhysical() ? this.myOldChild.getPsi() : null;
            if (psiParent != null && psiOldChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file2.getManager());
                event.setParent(psiParent);
                event.setFile(file2);
                event.setOldChild(psiOldChild);
                PsiElement psiNewChild = DiffLog.getPsi(this.myNewChild, file2);
                event.setNewChild(psiNewChild);
                ((PsiManagerEx)file2.getManager()).beforeChildReplacement(event);
            }
            if (!(this.myOldChild instanceof FileElement) || !(this.myNewChild instanceof FileElement)) {
                changeEvent.addElementaryChange(this.myOldChild.getTreeParent());
            }
            this.myNewChild.rawRemove();
            this.myOldChild.rawReplaceWithList(this.myNewChild);
            this.myNewChild.clearCaches();
            if (!(this.myNewChild instanceof FileElement)) {
                this.myNewChild.getTreeParent().subtreeChanged();
            }
            DebugUtil.checkTreeStructure(parent);
        }
    }

    private static abstract class LogEntry {
        protected LogEntry() {
            ProgressIndicatorProvider.checkCanceled();
        }

        abstract void doActualPsiChange(@NotNull PsiFile var1, @NotNull TreeChangeEventImpl var2);
    }
}

