/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.event.RetargetRangeMarkers;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.BooleanRunnable;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiDocumentManagerBase
extends PsiDocumentManager
implements DocumentListener,
Disposable {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiDocumentManagerImpl");
    private static final Key<Document> HARD_REF_TO_DOCUMENT = Key.create((String)"HARD_REFERENCE_TO_DOCUMENT");
    private static final Key<List<Runnable>> ACTION_AFTER_COMMIT = Key.create((String)"ACTION_AFTER_COMMIT");
    protected final Project myProject;
    private final PsiManager myPsiManager;
    private final DocumentCommitProcessor myDocumentCommitProcessor;
    final Set<Document> myUncommittedDocuments = ContainerUtil.newConcurrentSet();
    private final Map<Document, UncommittedInfo> myUncommittedInfos = ContainerUtil.newConcurrentMap();
    boolean myStopTrackingDocuments;
    private boolean myPerformBackgroundCommit = true;
    private volatile boolean myIsCommitInProgress;
    private static volatile boolean ourIsFullReparseInProgress;
    private final PsiToDocumentSynchronizer mySynchronizer;
    private final List<PsiDocumentManager.Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Map<Object, Runnable> actionsWhenAllDocumentsAreCommitted = new LinkedHashMap<Object, Runnable>();
    private static final Object PERFORM_ALWAYS_KEY;

    protected PsiDocumentManagerBase(@NotNull Project project, @NotNull PsiManager psiManager, @NotNull MessageBus bus, @NotNull DocumentCommitProcessor documentCommitProcessor) {
        this.myProject = project;
        this.myPsiManager = psiManager;
        this.myDocumentCommitProcessor = documentCommitProcessor;
        this.mySynchronizer = new PsiToDocumentSynchronizer(this, bus);
        this.myPsiManager.addPsiTreeChangeListener((PsiTreeChangeListener)this.mySynchronizer);
        bus.connect((Disposable)this).subscribe(PsiDocumentTransactionListener.TOPIC, (document, file2) -> this.myUncommittedDocuments.remove(document));
    }

    @Nullable
    public PsiFile getPsiFile(@NotNull Document document) {
        if (document instanceof DocumentWindow && !((DocumentWindow)document).isValid()) {
            return null;
        }
        PsiFile psiFile = this.getCachedPsiFile(document);
        if (psiFile != null) {
            return PsiDocumentManagerBase.ensureValidFile(psiFile, "Cached PSI");
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        psiFile = this.getPsiFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        this.fireFileCreated(document, psiFile);
        return psiFile;
    }

    @NotNull
    private static PsiFile ensureValidFile(@NotNull PsiFile psiFile, @NotNull String debugInfo) {
        if (!psiFile.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)psiFile, debugInfo);
        }
        return psiFile;
    }

    @Deprecated
    public static void cachePsi(@NotNull Document document, @Nullable PsiFile file2) {
        LOG.warn("Unsupported method", new Throwable());
    }

    public void associatePsi(@NotNull Document document, @Nullable PsiFile file2) {
        throw new UnsupportedOperationException();
    }

    public PsiFile getCachedPsiFile(@NotNull Document document) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return this.getCachedPsiFile(virtualFile);
    }

    @Nullable
    FileViewProvider getCachedViewProvider(@NotNull Document document) {
        VirtualFile virtualFile = PsiDocumentManagerBase.getVirtualFile(document);
        if (virtualFile == null) {
            return null;
        }
        return this.getFileManager().findCachedViewProvider(virtualFile);
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull Document document) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return virtualFile;
    }

    @Nullable
    PsiFile getCachedPsiFile(@NotNull VirtualFile virtualFile) {
        return this.getFileManager().getCachedPsiFile(virtualFile);
    }

    @Nullable
    private PsiFile getPsiFile(@NotNull VirtualFile virtualFile) {
        return this.getFileManager().findFile(virtualFile);
    }

    @NotNull
    private FileManager getFileManager() {
        return ((PsiManagerEx)this.myPsiManager).getFileManager();
    }

    public Document getDocument(@NotNull PsiFile file2) {
        Document document = this.getCachedDocument(file2);
        if (document != null) {
            if (!file2.getViewProvider().isPhysical()) {
                PsiUtilCore.ensureValid((PsiElement)file2);
                this.associatePsi(document, file2);
            }
            return document;
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        if (!viewProvider.isEventSystemEnabled()) {
            return null;
        }
        document = FileDocumentManager.getInstance().getDocument(viewProvider.getVirtualFile());
        if (document != null) {
            if (document.getTextLength() != file2.getTextLength()) {
                String message = "Document/PSI mismatch: " + file2 + " (" + file2.getClass() + "); physical=" + viewProvider.isPhysical();
                if (document.getTextLength() + file2.getTextLength() < 8096) {
                    message = message + "\n=== document ===\n" + document.getText() + "\n=== PSI ===\n" + file2.getText();
                }
                throw new AssertionError((Object)message);
            }
            if (!viewProvider.isPhysical()) {
                PsiUtilCore.ensureValid((PsiElement)file2);
                this.associatePsi(document, file2);
                file2.putUserData(HARD_REF_TO_DOCUMENT, (Object)document);
            }
        }
        return document;
    }

    public Document getCachedDocument(@NotNull PsiFile file2) {
        if (!file2.isPhysical()) {
            return null;
        }
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        return FileDocumentManager.getInstance().getCachedDocument(vFile);
    }

    public void commitAllDocuments() {
        Document[] documents;
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        if (this.myUncommittedDocuments.isEmpty()) {
            return;
        }
        for (Document document : documents = this.getUncommittedDocuments()) {
            if (this.isCommitted(document)) {
                boolean success2 = this.doCommitWithoutReparse(document);
                LOG.error("Committed document in uncommitted set: " + document + ", force-committed=" + success2);
                continue;
            }
            if (this.doCommit(document)) continue;
            LOG.error("Couldn't commit " + document);
        }
        this.assertEverythingCommitted();
    }

    private void assertEverythingCommitted() {
        LOG.assertTrue(!this.hasUncommitedDocuments(), this.myUncommittedDocuments);
    }

    @VisibleForTesting
    public boolean doCommitWithoutReparse(@NotNull Document document) {
        return this.finishCommitInWriteAction(document, Collections.emptyList(), Collections.emptyList(), true, true);
    }

    public void performForCommittedDocument(@NotNull Document doc, @NotNull Runnable action) {
        Document document = PsiDocumentManagerBase.getTopLevelDocument(doc);
        if (this.isCommitted(document)) {
            action.run();
        } else {
            PsiDocumentManagerBase.addRunOnCommit(document, action);
        }
    }

    public boolean cancelAndRunWhenAllCommitted(@NonNls @NotNull Object key, @NotNull Runnable action) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            action.run();
            return true;
        }
        if (this.myUncommittedDocuments.isEmpty()) {
            if (!this.isCommitInProgress()) assert (this.actionsWhenAllDocumentsAreCommitted.isEmpty()) : this.actionsWhenAllDocumentsAreCommitted;
            action.run();
            return true;
        }
        this.checkWeAreOutsideAfterCommitHandler();
        this.actionsWhenAllDocumentsAreCommitted.put(key, action);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRunOnCommit(@NotNull Document document, @NotNull Runnable action) {
        Key<List<Runnable>> key = ACTION_AFTER_COMMIT;
        synchronized (key) {
            List list2 = (List)document.getUserData(ACTION_AFTER_COMMIT);
            if (list2 == null) {
                list2 = new SmartList();
                document.putUserData(ACTION_AFTER_COMMIT, (Object)list2);
            }
            list2.add(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Runnable> getAndClearActionsAfterCommit(@NotNull Document document) {
        ArrayList<Runnable> list2;
        Key<List<Runnable>> key = ACTION_AFTER_COMMIT;
        synchronized (key) {
            list2 = (ArrayList<Runnable>)document.getUserData(ACTION_AFTER_COMMIT);
            if (list2 != null) {
                list2 = new ArrayList<Runnable>(list2);
                document.putUserData(ACTION_AFTER_COMMIT, null);
            }
        }
        return list2;
    }

    public void commitDocument(@NotNull Document doc) {
        Document document = PsiDocumentManagerBase.getTopLevelDocument(doc);
        if (this.isEventSystemEnabled(document)) {
            ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        }
        if (!this.isCommitted(document)) {
            this.doCommit(document);
        }
    }

    private boolean isEventSystemEnabled(Document document) {
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        return viewProvider != null && viewProvider.isEventSystemEnabled() && !AbstractFileViewProvider.isFreeThreaded(viewProvider);
    }

    boolean finishCommit(final @NotNull Document document, final @NotNull List<? extends BooleanRunnable> finishProcessors, final @NotNull List<? extends BooleanRunnable> reparseInjectedProcessors, final boolean synchronously, @NotNull Object reason) {
        assert (!this.myProject.isDisposed()) : "Already disposed";
        ApplicationManager.getApplication().assertIsDispatchThread();
        final boolean[] ok = new boolean[]{true};
        DocumentRunnable runnable2 = new DocumentRunnable(document, this.myProject){

            public void run() {
                ok[0] = PsiDocumentManagerBase.this.finishCommitInWriteAction(document, finishProcessors, reparseInjectedProcessors, synchronously, false);
            }
        };
        if (synchronously) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().runWriteAction((Runnable)runnable2);
        }
        if (ok[0]) {
            this.runAfterCommitActions(document);
            if (DebugUtil.DO_EXPENSIVE_CHECKS && !ApplicationInfoImpl.isInStressTest()) {
                this.checkAllElementsValid(document, reason);
            }
        }
        return ok[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean finishCommitInWriteAction(@NotNull Document document, @NotNull List<? extends BooleanRunnable> finishProcessors, @NotNull List<? extends BooleanRunnable> reparseInjectedProcessors, boolean synchronously, boolean forceNoPsiCommit) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return false;
        }
        assert (!(document instanceof DocumentWindow));
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile != null) {
            this.getSmartPointerManager().fastenBelts(virtualFile);
        }
        FileViewProvider viewProvider = forceNoPsiCommit ? null : this.getCachedViewProvider(document);
        this.myIsCommitInProgress = true;
        Ref success2 = new Ref((Object)true);
        try {
            ProgressManager.getInstance().executeNonCancelableSection(() -> {
                if (viewProvider == null) {
                    this.handleCommitWithoutPsi(document);
                } else {
                    success2.set((Object)this.commitToExistingPsi(document, finishProcessors, reparseInjectedProcessors, synchronously, virtualFile));
                }
            });
        }
        catch (Throwable e) {
            try {
                this.forceReload(virtualFile, viewProvider);
            }
            finally {
                LOG.error(e);
            }
        }
        finally {
            if (((Boolean)success2.get()).booleanValue()) {
                this.myUncommittedDocuments.remove(document);
            }
            this.myIsCommitInProgress = false;
        }
        return (Boolean)success2.get();
    }

    private boolean commitToExistingPsi(@NotNull Document document, @NotNull List<? extends BooleanRunnable> finishProcessors, @NotNull List<? extends BooleanRunnable> reparseInjectedProcessors, boolean synchronously, @Nullable VirtualFile virtualFile) {
        FileViewProvider viewProvider;
        for (BooleanRunnable booleanRunnable : finishProcessors) {
            boolean bl = booleanRunnable.run();
            if (synchronously) assert (bl) : booleanRunnable + " in " + finishProcessors;
            if (bl) continue;
            return false;
        }
        this.clearUncommittedInfo(document);
        if (virtualFile != null) {
            this.getSmartPointerManager().updatePointerTargetsAfterReparse(virtualFile);
        }
        if ((viewProvider = this.getCachedViewProvider(document)) != null) {
            viewProvider.contentsSynchronized();
        }
        for (BooleanRunnable booleanRunnable : reparseInjectedProcessors) {
            if (booleanRunnable.run()) continue;
            return false;
        }
        return true;
    }

    void forceReload(VirtualFile virtualFile, @Nullable FileViewProvider viewProvider) {
        if (viewProvider != null) {
            ((AbstractFileViewProvider)viewProvider).markInvalidated();
        }
        if (virtualFile != null) {
            ((FileManagerImpl)this.getFileManager()).forceReload(virtualFile);
        }
    }

    private void checkAllElementsValid(@NotNull Document document, final @NotNull Object reason) {
        final PsiFile psiFile = this.getCachedPsiFile(document);
        if (psiFile != null) {
            psiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    if (!element.isValid()) {
                        throw new AssertionError((Object)("Commit to '" + psiFile.getVirtualFile() + "' has led to invalid element: " + element + "; Reason: '" + reason + "'"));
                    }
                }
            });
        }
    }

    private boolean doCommit(@NotNull Document document) {
        assert (!this.myIsCommitInProgress) : "Do not call commitDocument() from inside PSI change listener";
        if (this.getSynchronizer().isDocumentAffectedByTransactions(document)) {
            return false;
        }
        PsiFile psiFile = this.getPsiFile(document);
        if (psiFile == null) {
            this.myUncommittedDocuments.remove(document);
            this.runAfterCommitActions(document);
            return true;
        }
        Runnable runnable2 = () -> {
            this.myIsCommitInProgress = true;
            try {
                this.myDocumentCommitProcessor.commitSynchronously(document, this.myProject, psiFile);
            }
            finally {
                this.myIsCommitInProgress = false;
            }
            assert (!this.isInUncommittedSet(document)) : "Document :" + document;
        };
        ApplicationManager.getApplication().runWriteAction(runnable2);
        return true;
    }

    public boolean isCommitInProgress() {
        return this.myIsCommitInProgress || PsiDocumentManagerBase.isFullReparseInProgress();
    }

    public static boolean isFullReparseInProgress() {
        return ourIsFullReparseInProgress;
    }

    public <T> T commitAndRunReadAction(@NotNull Computable<T> computation) {
        Ref ref = Ref.create(null);
        this.commitAndRunReadAction(() -> ref.set(computation.compute()));
        return (T)ref.get();
    }

    public void reparseFiles(@NotNull Collection<VirtualFile> files2, boolean includeOpenFiles) {
        FileContentUtilCore.reparseFiles(files2);
    }

    public void commitAndRunReadAction(@NotNull Runnable runnable2) {
        boolean executed;
        Application application = ApplicationManager.getApplication();
        if (SwingUtilities.isEventDispatchThread()) {
            this.commitAllDocuments();
            runnable2.run();
            return;
        }
        if (application.isReadAccessAllowed()) {
            LOG.error("Don't call commitAndRunReadAction inside ReadAction, it will cause a deadlock. " + Thread.currentThread());
        }
        while (!(executed = ((Boolean)ReadAction.compute(() -> {
            if (this.myUncommittedDocuments.isEmpty()) {
                runnable2.run();
                return true;
            }
            return false;
        })).booleanValue())) {
            TransactionId contextTransaction = TransactionGuard.getInstance().getContextTransaction();
            Semaphore semaphore = new Semaphore(1);
            application.invokeLater(() -> {
                if (this.myProject.isDisposed()) {
                    semaphore.up();
                    return;
                }
                this.performWhenAllCommitted(() -> semaphore.up(), contextTransaction);
            }, ModalityState.any());
            while (!semaphore.waitFor(10L)) {
                ProgressManager.checkCanceled();
            }
        }
    }

    public boolean performWhenAllCommitted(@NotNull Runnable action) {
        return this.performWhenAllCommitted(action, TransactionGuard.getInstance().getContextTransaction());
    }

    private boolean performWhenAllCommitted(@NotNull Runnable action, @Nullable TransactionId context) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkWeAreOutsideAfterCommitHandler();
        assert (!this.myProject.isDisposed()) : "Already disposed: " + this.myProject;
        if (this.myUncommittedDocuments.isEmpty()) {
            action.run();
            return true;
        }
        CompositeRunnable actions = (CompositeRunnable)this.actionsWhenAllDocumentsAreCommitted.get(PERFORM_ALWAYS_KEY);
        if (actions == null) {
            actions = new CompositeRunnable();
            this.actionsWhenAllDocumentsAreCommitted.put(PERFORM_ALWAYS_KEY, actions);
        }
        actions.add(action);
        if (context != null) {
            for (Document document : this.myUncommittedDocuments) {
                this.myDocumentCommitProcessor.commitAsynchronously(this.myProject, document, "re-added with context " + context + " because performWhenAllCommitted(" + context + ") was called", context);
            }
        }
        return false;
    }

    public void performLaterWhenAllCommitted(@NotNull Runnable runnable2) {
        this.performLaterWhenAllCommitted(runnable2, ModalityState.defaultModalityState());
    }

    public void performLaterWhenAllCommitted(@NotNull Runnable runnable2, ModalityState modalityState) {
        Runnable whenAllCommitted = () -> ApplicationManager.getApplication().invokeLater(() -> {
            if (this.hasUncommitedDocuments()) {
                this.performLaterWhenAllCommitted(runnable2);
            } else {
                runnable2.run();
            }
        }, modalityState, this.myProject.getDisposed());
        if (ApplicationManager.getApplication().isDispatchThread() && this.isInsideCommitHandler()) {
            whenAllCommitted.run();
        } else {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (!this.myProject.isDisposed()) {
                    this.performWhenAllCommitted(whenAllCommitted);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAfterCommitActions(@NotNull Document document) {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myProject.isDisposed() && this.isCommitted(document)) {
                    this.runAfterCommitActions(document);
                }
            });
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<Runnable> list2 = PsiDocumentManagerBase.getAndClearActionsAfterCommit(document);
        if (list2 != null) {
            for (Runnable runnable2 : list2) {
                runnable2.run();
            }
        }
        if (!this.hasUncommitedDocuments() && !this.actionsWhenAllDocumentsAreCommitted.isEmpty()) {
            ArrayList<Runnable> actions = new ArrayList<Runnable>(this.actionsWhenAllDocumentsAreCommitted.values());
            this.beforeCommitHandler();
            ArrayList<Pair> exceptions = new ArrayList<Pair>();
            try {
                for (Runnable action : actions) {
                    try {
                        action.run();
                    }
                    catch (ProcessCanceledException processCanceledException) {
                    }
                    catch (Throwable e) {
                        exceptions.add(Pair.create((Object)action, (Object)e));
                    }
                }
            }
            finally {
                this.actionsWhenAllDocumentsAreCommitted.clear();
            }
            for (Pair pair : exceptions) {
                Runnable action = (Runnable)pair.getFirst();
                Throwable e = (Throwable)pair.getSecond();
                LOG.error("During running " + action, e);
            }
        }
    }

    private void beforeCommitHandler() {
        this.actionsWhenAllDocumentsAreCommitted.put(PERFORM_ALWAYS_KEY, EmptyRunnable.getInstance());
    }

    private void checkWeAreOutsideAfterCommitHandler() {
        if (this.isInsideCommitHandler()) {
            throw new IncorrectOperationException("You must not call performWhenAllCommitted()/cancelAndRunWhenCommitted() from within after-commit handler");
        }
    }

    private boolean isInsideCommitHandler() {
        return this.actionsWhenAllDocumentsAreCommitted.get(PERFORM_ALWAYS_KEY) == EmptyRunnable.getInstance();
    }

    public void addListener(@NotNull PsiDocumentManager.Listener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull PsiDocumentManager.Listener listener2) {
        this.myListeners.remove(listener2);
    }

    public boolean isDocumentBlockedByPsi(@NotNull Document doc) {
        return false;
    }

    public void doPostponedOperationsAndUnblockDocument(@NotNull Document doc) {
    }

    void fireDocumentCreated(@NotNull Document document, PsiFile file2) {
        for (PsiDocumentManager.Listener listener2 : this.myListeners) {
            listener2.documentCreated(document, file2);
        }
    }

    private void fireFileCreated(@NotNull Document document, @NotNull PsiFile file2) {
        for (PsiDocumentManager.Listener listener2 : this.myListeners) {
            listener2.fileCreated(file2, document);
        }
    }

    @NotNull
    public CharSequence getLastCommittedText(@NotNull Document document) {
        return this.getLastCommittedDocument(document).getImmutableCharSequence();
    }

    public long getLastCommittedStamp(@NotNull Document document) {
        return this.getLastCommittedDocument(PsiDocumentManagerBase.getTopLevelDocument(document)).getModificationStamp();
    }

    @Nullable
    public Document getLastCommittedDocument(@NotNull PsiFile file2) {
        Document document = this.getDocument(file2);
        return document == null ? null : this.getLastCommittedDocument(document);
    }

    @NotNull
    public DocumentEx getLastCommittedDocument(@NotNull Document document) {
        if (document instanceof FrozenDocument) {
            return (DocumentEx)document;
        }
        if (document instanceof DocumentWindow) {
            DocumentWindow answer;
            DocumentWindow window = (DocumentWindow)document;
            Document delegate = window.getDelegate();
            if (delegate instanceof FrozenDocument) {
                return (DocumentEx)window;
            }
            if (!window.isValid()) {
                throw new AssertionError((Object)("host committed: " + this.isCommitted(delegate) + ", window=" + window));
            }
            UncommittedInfo info = this.myUncommittedInfos.get(delegate);
            DocumentWindow documentWindow = answer = info == null ? null : (DocumentWindow)info.myFrozenWindows.get(document);
            if (answer == null) {
                answer = this.freezeWindow(window);
            }
            if (info != null) {
                answer = (DocumentWindow)ConcurrencyUtil.cacheOrGet((ConcurrentMap)info.myFrozenWindows, (Object)window, (Object)answer);
            }
            return (DocumentEx)answer;
        }
        assert (document instanceof DocumentImpl);
        UncommittedInfo info = this.myUncommittedInfos.get(document);
        return info != null ? info.myFrozen : ((DocumentImpl)document).freeze();
    }

    @NotNull
    protected DocumentWindow freezeWindow(@NotNull DocumentWindow document) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public List<DocumentEvent> getEventsSinceCommit(@NotNull Document document) {
        assert (document instanceof DocumentImpl) : document;
        UncommittedInfo info = this.myUncommittedInfos.get(document);
        if (info != null) {
            return new ArrayList<DocumentEvent>(info.myEvents);
        }
        return Collections.emptyList();
    }

    @NotNull
    public Document[] getUncommittedDocuments() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document[] documents = this.myUncommittedDocuments.toArray(Document.EMPTY_ARRAY);
        return documents;
    }

    boolean isInUncommittedSet(@NotNull Document document) {
        return this.myUncommittedDocuments.contains(PsiDocumentManagerBase.getTopLevelDocument(document));
    }

    public boolean isUncommited(@NotNull Document document) {
        return !this.isCommitted(document);
    }

    public boolean isCommitted(@NotNull Document document) {
        document = PsiDocumentManagerBase.getTopLevelDocument(document);
        if (this.getSynchronizer().isInSynchronization(document)) {
            return true;
        }
        return (!(document instanceof DocumentEx) || !((DocumentEx)document).isInEventsHandling()) && !this.isInUncommittedSet(document);
    }

    @NotNull
    private static Document getTopLevelDocument(@NotNull Document document) {
        return document instanceof DocumentWindow ? ((DocumentWindow)document).getDelegate() : document;
    }

    public boolean hasUncommitedDocuments() {
        return !this.myIsCommitInProgress && !this.myUncommittedDocuments.isEmpty();
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        FileViewProvider viewProvider;
        boolean inMyProject;
        boolean isRelevant;
        if (this.myStopTrackingDocuments || this.myProject.isDisposed()) {
            return;
        }
        Document document = event.getDocument();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        boolean bl = isRelevant = virtualFile != null && this.isRelevant(virtualFile);
        if (document instanceof DocumentImpl && !this.myUncommittedInfos.containsKey(document)) {
            this.myUncommittedInfos.put(document, new UncommittedInfo((DocumentImpl)document));
        }
        boolean bl2 = inMyProject = (viewProvider = this.getCachedViewProvider(document)) != null && viewProvider.getManager() == this.myPsiManager;
        if (!isRelevant || !inMyProject) {
            return;
        }
        List files2 = viewProvider.getAllFiles();
        PsiFile psiCause = null;
        for (PsiFile file2 : files2) {
            if (file2 == null) {
                throw new AssertionError((Object)("View provider " + viewProvider + " (" + viewProvider.getClass() + ") returned null in its files array: " + files2 + " for file " + viewProvider.getVirtualFile()));
            }
            if (!PsiToDocumentSynchronizer.isInsideAtomicChange(file2)) continue;
            psiCause = file2;
        }
        if (psiCause == null) {
            this.beforeDocumentChangeOnUnlockedDocument(viewProvider);
        }
    }

    protected void beforeDocumentChangeOnUnlockedDocument(@NotNull FileViewProvider viewProvider) {
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        boolean forceCommit;
        boolean inMyProject;
        if (this.myStopTrackingDocuments || this.myProject.isDisposed()) {
            return;
        }
        Document document = event.getDocument();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        boolean isRelevant = virtualFile != null && this.isRelevant(virtualFile);
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        if (viewProvider == null) {
            this.handleCommitWithoutPsi(document);
            return;
        }
        boolean bl = inMyProject = viewProvider.getManager() == this.myPsiManager;
        if (!isRelevant || !inMyProject) {
            this.clearUncommittedInfo(document);
            return;
        }
        List files2 = viewProvider.getAllFiles();
        if (files2.isEmpty()) {
            this.handleCommitWithoutPsi(document);
            return;
        }
        boolean commitNecessary = files2.stream().noneMatch(file2 -> PsiToDocumentSynchronizer.isInsideAtomicChange(file2) || !(file2 instanceof PsiFileImpl));
        boolean bl2 = forceCommit = ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.class) && (SystemProperties.getBooleanProperty((String)"idea.force.commit.on.external.change", (boolean)false) || ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode());
        if (event.isWholeTextReplaced() && document.getTextLength() > 100000) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, (Object)Boolean.TRUE);
        }
        if (commitNecessary) {
            assert (!(document instanceof DocumentWindow));
            this.myUncommittedDocuments.add(document);
            if (forceCommit) {
                this.commitDocument(document);
            } else if (!((DocumentEx)document).isInBulkUpdate() && this.myPerformBackgroundCommit) {
                this.myDocumentCommitProcessor.commitAsynchronously(this.myProject, document, event, TransactionGuard.getInstance().getContextTransaction());
            }
        } else {
            this.clearUncommittedInfo(document);
        }
    }

    void handleCommitWithoutPsi(@NotNull Document document) {
        UncommittedInfo prevInfo = this.clearUncommittedInfo(document);
        if (prevInfo == null) {
            return;
        }
        this.myUncommittedDocuments.remove(document);
        if (!this.myProject.isInitialized() || this.myProject.isDisposed() || this.myProject.isDefault()) {
            return;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile != null) {
            FileManager fileManager = this.getFileManager();
            FileViewProvider viewProvider = fileManager.findCachedViewProvider(virtualFile);
            if (viewProvider != null) {
                ApplicationManager.getApplication().runWriteAction(() -> ((AbstractFileViewProvider)viewProvider).onContentReload());
            } else if (FileIndexFacade.getInstance((Project)this.myProject).isInContent(virtualFile)) {
                ApplicationManager.getApplication().runWriteAction(() -> ((FileManagerImpl)fileManager).firePropertyChangedForUnloadedPsi());
            }
        }
        this.runAfterCommitActions(document);
    }

    @Nullable
    private UncommittedInfo clearUncommittedInfo(@NotNull Document document) {
        UncommittedInfo info = this.myUncommittedInfos.remove(document);
        if (info != null) {
            this.getSmartPointerManager().updatePointers(document, info.myFrozen, info.myEvents);
        }
        return info;
    }

    private SmartPointerManagerImpl getSmartPointerManager() {
        return (SmartPointerManagerImpl)SmartPointerManager.getInstance((Project)this.myProject);
    }

    private boolean isRelevant(@NotNull VirtualFile virtualFile) {
        return !virtualFile.getFileType().isBinary() && !this.myProject.isDisposed();
    }

    public static boolean checkConsistency(@NotNull PsiFile psiFile, @NotNull Document document) {
        int i;
        if (psiFile.getVirtualFile() == null) {
            return true;
        }
        CharSequence editorText = document.getCharsSequence();
        int documentLength = document.getTextLength();
        if (psiFile.textMatches(editorText)) {
            LOG.assertTrue(psiFile.getTextLength() == documentLength);
            return true;
        }
        char[] fileText = psiFile.textToCharArray();
        String error = "File '" + psiFile.getName() + "' text mismatch after reparse. File length=" + fileText.length + "; Doc length=" + documentLength + "\n";
        for (i = 0; i < documentLength; ++i) {
            if (i >= fileText.length) {
                error = error + "editorText.length > psiText.length i=" + i + "\n";
                break;
            }
            if (i >= editorText.length()) {
                error = error + "editorText.length > psiText.length i=" + i + "\n";
                break;
            }
            if (editorText.charAt(i) == fileText[i]) continue;
            error = error + "first unequal char i=" + i + "\n";
            break;
        }
        error = error + "*********************************************\n";
        error = error + "Editor Text tail:(" + (documentLength - i) + ")\n";
        error = error + "*********************************************\n";
        error = error + "Psi Text tail:(" + (fileText.length - i) + ")\n";
        error = error + "*********************************************\n";
        if (document instanceof DocumentWindow) {
            error = error + "doc: '" + document.getText() + "'\n";
            error = error + "psi: '" + psiFile.getText() + "'\n";
            error = error + "ast: '" + psiFile.getNode().getText() + "'\n";
            error = error + psiFile.getLanguage() + "\n";
            PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getInjectionHost((PsiElement)psiFile);
            if (context != null) {
                error = error + "context: " + context + "; text: '" + context.getText() + "'\n";
                error = error + "context file: " + context.getContainingFile() + "\n";
            }
            error = error + "document window ranges: " + Arrays.asList(((DocumentWindow)document).getHostRanges()) + "\n";
        }
        LOG.error(error);
        return false;
    }

    @VisibleForTesting
    public void clearUncommittedDocuments() {
        this.myUncommittedInfos.clear();
        this.myUncommittedDocuments.clear();
        this.mySynchronizer.cleanupForNextTest();
    }

    public void disableBackgroundCommit(@NotNull Disposable parentDisposable) {
        assert (this.myPerformBackgroundCommit);
        this.myPerformBackgroundCommit = false;
        Disposer.register((Disposable)parentDisposable, () -> {
            this.myPerformBackgroundCommit = true;
        });
    }

    public void dispose() {
        this.clearUncommittedDocuments();
    }

    @NotNull
    public PsiToDocumentSynchronizer getSynchronizer() {
        return this.mySynchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparseFileFromText(@NotNull PsiFileImpl file2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isCommitInProgress()) {
            throw new IllegalStateException("Re-entrant commit is not allowed");
        }
        FileElement node = file2.calcTreeElement();
        CharSequence text = node.getChars();
        ourIsFullReparseInProgress = true;
        try {
            WriteAction.run(() -> {
                ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
                if (indicator == null) {
                    indicator = new EmptyProgressIndicator();
                }
                DiffLog log2 = BlockSupportImpl.makeFullParse((PsiFileImpl)file2, (FileASTNode)node, (CharSequence)text, (ProgressIndicator)indicator, (CharSequence)text).log;
                log2.doActualPsiChange(file2);
                file2.getViewProvider().contentsSynchronized();
            });
        }
        finally {
            ourIsFullReparseInProgress = false;
        }
    }

    @NotNull
    List<BooleanRunnable> reparseChangedInjectedFragments(@NotNull Document hostDocument, @NotNull PsiFile hostPsiFile, @NotNull TextRange range2, @NotNull ProgressIndicator indicator, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot) {
        return Collections.emptyList();
    }

    static {
        PERFORM_ALWAYS_KEY = ObjectUtils.sentinel((String)"PERFORM_ALWAYS");
    }

    private static class UncommittedInfo {
        private final FrozenDocument myFrozen;
        private final List<DocumentEvent> myEvents = ContainerUtil.newArrayList();
        private final ConcurrentMap<DocumentWindow, DocumentWindow> myFrozenWindows = ContainerUtil.newConcurrentMap();

        private UncommittedInfo(@NotNull DocumentImpl original) {
            this.myFrozen = original.freeze();
        }
    }

    class PriorityEventCollector
    implements PrioritizedInternalDocumentListener {
        PriorityEventCollector() {
        }

        @Override
        public int getPriority() {
            return 40;
        }

        @Override
        public void moveTextHappened(@NotNull Document document, int start2, int end, int base) {
            UncommittedInfo info = (UncommittedInfo)PsiDocumentManagerBase.this.myUncommittedInfos.get(document);
            if (info != null) {
                info.myEvents.add(new RetargetRangeMarkers(document, start2, end, base));
            }
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            UncommittedInfo info = (UncommittedInfo)PsiDocumentManagerBase.this.myUncommittedInfos.get(event.getDocument());
            if (info != null) {
                info.myEvents.add(event);
            }
        }
    }

    private static class CompositeRunnable
    extends ArrayList<Runnable>
    implements Runnable {
        private CompositeRunnable() {
        }

        @Override
        public void run() {
            for (Runnable runnable2 : this) {
                runnable2.run();
            }
        }
    }
}

