/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.AppTopics;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.impl.event.EditorEventMulticasterImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.BooleanRunnable;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDocumentManagerImpl
extends PsiDocumentManagerBase {
    private final DocumentCommitProcessor myDocumentCommitThread;
    private final boolean myUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();

    public PsiDocumentManagerImpl(final @NotNull Project project, @NotNull PsiManager psiManager, @NotNull EditorFactory editorFactory, @NotNull MessageBus bus, final @NotNull DocumentCommitProcessor documentCommitThread) {
        super(project, psiManager, bus, documentCommitThread);
        this.myDocumentCommitThread = documentCommitThread;
        editorFactory.getEventMulticaster().addDocumentListener((DocumentListener)this, (Disposable)project);
        ((EditorEventMulticasterImpl)editorFactory.getEventMulticaster()).addPrioritizedDocumentListener(new PsiDocumentManagerBase.PriorityEventCollector(), (Disposable)project);
        MessageBusConnection connection = bus.connect((Disposable)this);
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void fileContentLoaded(@NotNull VirtualFile virtualFile, @NotNull Document document) {
                PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiDocumentManagerImpl.this.myProject.isDisposed() || !virtualFile.isValid() ? null : PsiDocumentManagerImpl.this.getCachedPsiFile(virtualFile));
                PsiDocumentManagerImpl.this.fireDocumentCreated(document, psiFile);
            }
        });
        connection.subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

            @Override
            public void updateFinished(@NotNull Document doc) {
                documentCommitThread.commitAsynchronously(project, doc, "Bulk update finished", TransactionGuard.getInstance().getContextTransaction());
            }
        });
        Disposer.register((Disposable)project, () -> ((DocumentCommitThread)this.myDocumentCommitThread).cancelTasksOnProjectDispose(project));
    }

    @Override
    @Nullable
    public PsiFile getPsiFile(@NotNull Document document) {
        Collection projects;
        VirtualFile virtualFile;
        PsiFile psiFile = super.getPsiFile(document);
        if (this.myUnitTestMode && (virtualFile = FileDocumentManager.getInstance().getFile(document)) != null && virtualFile.isValid() && !(projects = ProjectLocator.getInstance().getProjectsForFile(virtualFile)).isEmpty() && !projects.contains(this.myProject)) {
            LOG.error("Trying to get PSI for an alien project. VirtualFile=" + virtualFile + ";\n myProject=" + this.myProject + ";\n projects returned: " + projects);
        }
        return psiFile;
    }

    @Override
    public void documentChanged(@NotNull DocumentEvent event) {
        super.documentChanged(event);
        if (this.isUncommited(event.getDocument()) && FileDocumentManagerImpl.areTooManyDocumentsInTheQueue(this.myUncommittedDocuments)) {
            if (this.myUnitTestMode) {
                this.myStopTrackingDocuments = true;
                try {
                    LOG.error("Too many uncommitted documents for " + this.myProject + "(" + this.myUncommittedDocuments.size() + "):\n" + StringUtil.join((Iterable)this.myUncommittedDocuments, (String)"\n") + "\n\n Project creation trace: " + (String)this.myProject.getUserData(ProjectImpl.CREATION_TRACE));
                }
                finally {
                    this.clearUncommittedDocuments();
                }
            }
            if (PomModelImpl.isAllowPsiModification() && ApplicationManager.getApplication().isWriteAccessAllowed()) {
                for (Document document : this.myUncommittedDocuments) {
                    if (document == event.getDocument()) continue;
                    this.doCommitWithoutReparse(document);
                    break;
                }
            }
        }
    }

    @Override
    protected void beforeDocumentChangeOnUnlockedDocument(@NotNull FileViewProvider viewProvider) {
        PostprocessReformattingAspect.getInstance(this.myProject).assertDocumentChangeIsAllowed(viewProvider);
        super.beforeDocumentChangeOnUnlockedDocument(viewProvider);
    }

    @Override
    protected boolean finishCommitInWriteAction(@NotNull Document document, @NotNull List<? extends BooleanRunnable> finishProcessors, @NotNull List<? extends BooleanRunnable> reparseInjectedProcessors, boolean synchronously, boolean forceNoPsiCommit) {
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            InjectedLanguageManagerImpl.disposeInvalidEditors();
        }
        return super.finishCommitInWriteAction(document, finishProcessors, reparseInjectedProcessors, synchronously, forceNoPsiCommit);
    }

    @Override
    public boolean isDocumentBlockedByPsi(@NotNull Document doc) {
        FileViewProvider viewProvider = this.getCachedViewProvider(doc);
        return viewProvider != null && PostprocessReformattingAspect.getInstance(this.myProject).isViewProviderLocked(viewProvider);
    }

    @Override
    public void doPostponedOperationsAndUnblockDocument(@NotNull Document doc) {
        if (doc instanceof DocumentWindow) {
            doc = ((DocumentWindow)doc).getDelegate();
        }
        PostprocessReformattingAspect component = (PostprocessReformattingAspect)this.myProject.getComponent(PostprocessReformattingAspect.class);
        FileViewProvider viewProvider = this.getCachedViewProvider(doc);
        if (viewProvider != null && component != null) {
            component.doPostponedFormatting(viewProvider);
        }
    }

    @Override
    public void clearUncommittedDocuments() {
        super.clearUncommittedDocuments();
        ((DocumentCommitThread)this.myDocumentCommitThread).clearQueue();
    }

    @Override
    @NotNull
    List<BooleanRunnable> reparseChangedInjectedFragments(@NotNull Document hostDocument, @NotNull PsiFile hostPsiFile, @NotNull TextRange hostChangedRange, @NotNull ProgressIndicator indicator, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot) {
        List changedInjected = InjectedLanguageManager.getInstance((Project)this.myProject).getCachedInjectedDocumentsInRange(hostPsiFile, hostChangedRange);
        if (changedInjected.isEmpty()) {
            return Collections.emptyList();
        }
        FileViewProvider hostViewProvider = hostPsiFile.getViewProvider();
        ArrayList<DocumentWindow> fromLast = new ArrayList<DocumentWindow>(changedInjected);
        fromLast.sort(Collections.reverseOrder(Comparator.comparingInt(doc -> ((Segment)ArrayUtil.getLastElement((Object[])doc.getHostRanges())).getEndOffset())));
        ArrayList<BooleanRunnable> result2 = new ArrayList<BooleanRunnable>(changedInjected.size());
        for (DocumentWindow document : fromLast) {
            PsiFile injectedPsiFile;
            Segment[] ranges = document.getHostRanges();
            if (ranges.length == 0 || (injectedPsiFile = this.getCachedPsiFile((Document)document)) == null || !injectedPsiFile.isValid()) continue;
            BooleanRunnable runnable2 = InjectedLanguageUtil.reparse(injectedPsiFile, document, hostPsiFile, hostDocument, hostViewProvider, indicator, oldRoot, newRoot, this);
            ContainerUtil.addIfNotNull(result2, (Object)runnable2);
        }
        return result2;
    }

    @NonNls
    public String toString() {
        return super.toString() + " for the project " + this.myProject + ".";
    }

    @Override
    public void reparseFiles(@NotNull Collection<VirtualFile> files2, boolean includeOpenFiles) {
        FileContentUtil.reparseFiles((Project)this.myProject, files2, (boolean)includeOpenFiles);
    }

    @Override
    @NotNull
    protected DocumentWindow freezeWindow(@NotNull DocumentWindow document) {
        return InjectedLanguageManager.getInstance((Project)this.myProject).freezeWindow(document);
    }

    @Override
    public void associatePsi(@NotNull Document document, @Nullable PsiFile file2) {
        if (file2 != null) {
            VirtualFile vFile = file2.getViewProvider().getVirtualFile();
            Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument(vFile);
            if (cachedDocument != null && cachedDocument != document) {
                throw new IllegalStateException("Can't replace existing document");
            }
            FileDocumentManagerImpl.registerDocument(document, vFile);
        }
    }
}

