/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.PsiBuilderFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.PsiTreeChangePreprocessorBase;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiManagerImpl
extends PsiManagerEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiManagerImpl");
    private final Project myProject;
    private final FileIndexFacade myFileIndex;
    private final MessageBus myMessageBus;
    private final PsiModificationTracker myModificationTracker;
    private final FileManagerImpl myFileManager;
    private final List<PsiTreeChangePreprocessor> myTreeChangePreprocessors = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<PsiTreeChangeListener> myTreeChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myTreeChangeEventIsFiring;
    private boolean myIsDisposed;
    private VirtualFileFilter myAssertOnFileLoadingFilter = VirtualFileFilter.NONE;
    private final AtomicInteger myBatchFilesProcessingModeCount = new AtomicInteger(0);
    public static final Topic<AnyPsiChangeListener> ANY_PSI_CHANGE_TOPIC = Topic.create((String)"ANY_PSI_CHANGE_TOPIC", AnyPsiChangeListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_PARENT);

    public PsiManagerImpl(Project project, FileDocumentManager fileDocumentManager, PsiBuilderFactory psiBuilderFactory, FileIndexFacade fileIndex, MessageBus messageBus, PsiModificationTracker modificationTracker) {
        this.myProject = project;
        this.myFileIndex = fileIndex;
        this.myMessageBus = messageBus;
        this.myModificationTracker = modificationTracker;
        this.myFileManager = new FileManagerImpl(this, fileDocumentManager, fileIndex);
        this.myTreeChangePreprocessors.add((PsiTreeChangePreprocessor)modificationTracker);
        Disposer.register((Disposable)project, () -> {
            this.myIsDisposed = true;
        });
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    public void dropResolveCaches() {
        this.myFileManager.processQueue();
        this.beforeChange(true);
    }

    public void dropPsiCaches() {
        this.dropResolveCaches();
        WriteAction.run(this.myFileManager::firePropertyChangedForUnloadedPsi);
    }

    public boolean isInProject(@NotNull PsiElement element) {
        if (element instanceof PsiDirectoryContainer) {
            PsiDirectory[] dirs;
            for (PsiDirectory dir : dirs = ((PsiDirectoryContainer)element).getDirectories()) {
                if (this.isInProject((PsiElement)dir)) continue;
                return false;
            }
            return true;
        }
        PsiFile file2 = element.getContainingFile();
        VirtualFile virtualFile = null;
        if (file2 != null) {
            virtualFile = file2.getViewProvider().getVirtualFile();
        } else if (element instanceof PsiFileSystemItem) {
            virtualFile = ((PsiFileSystemItem)element).getVirtualFile();
        }
        if (file2 != null && file2.isPhysical() && virtualFile.getFileSystem() instanceof NonPhysicalFileSystem) {
            return true;
        }
        return virtualFile != null && this.myFileIndex.isInContent(virtualFile);
    }

    @Override
    public void setAssertOnFileLoadingFilter(@NotNull VirtualFileFilter filter, @NotNull Disposable parentDisposable) {
        this.myAssertOnFileLoadingFilter = filter;
        Disposer.register((Disposable)parentDisposable, () -> {
            this.myAssertOnFileLoadingFilter = VirtualFileFilter.NONE;
        });
    }

    @Override
    public boolean isAssertOnFileLoading(@NotNull VirtualFile file2) {
        return this.myAssertOnFileLoadingFilter.accept(file2);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public FileManager getFileManager() {
        return this.myFileManager;
    }

    public boolean areElementsEquivalent(PsiElement element1, PsiElement element2) {
        ProgressIndicatorProvider.checkCanceled();
        if (element1 == element2) {
            return true;
        }
        if (element1 == null || element2 == null) {
            return false;
        }
        return element1.equals(element2) || element1.isEquivalentTo(element2) || element2.isEquivalentTo(element1);
    }

    public PsiFile findFile(@NotNull VirtualFile file2) {
        ProgressIndicatorProvider.checkCanceled();
        return this.myFileManager.findFile(file2);
    }

    @Nullable
    public FileViewProvider findViewProvider(@NotNull VirtualFile file2) {
        ProgressIndicatorProvider.checkCanceled();
        return this.myFileManager.findViewProvider(file2);
    }

    public PsiDirectory findDirectory(@NotNull VirtualFile file2) {
        ProgressIndicatorProvider.checkCanceled();
        return this.myFileManager.findDirectory(file2);
    }

    public void reloadFromDisk(@NotNull PsiFile file2) {
        this.myFileManager.reloadFromDisk(file2);
    }

    public void addPsiTreeChangeListener(@NotNull PsiTreeChangeListener listener2) {
        this.myTreeChangeListeners.add(listener2);
    }

    public void addPsiTreeChangeListener(@NotNull PsiTreeChangeListener listener2, @NotNull Disposable parentDisposable) {
        this.addPsiTreeChangeListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removePsiTreeChangeListener(listener2));
    }

    public void removePsiTreeChangeListener(@NotNull PsiTreeChangeListener listener2) {
        this.myTreeChangeListeners.remove(listener2);
    }

    private static String logPsi(@Nullable PsiElement element) {
        return element == null ? " null" : element.getClass().getName();
    }

    @Override
    public void beforeChildAddition(@NotNull PsiTreeChangeEventImpl event) {
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_ADDITION);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildAddition: event = " + (Object)((Object)event));
        }
        this.fireEvent(event);
    }

    @Override
    public void beforeChildRemoval(@NotNull PsiTreeChangeEventImpl event) {
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REMOVAL);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildRemoval: child = " + PsiManagerImpl.logPsi(event.getChild()) + ", parent = " + PsiManagerImpl.logPsi(event.getParent()));
        }
        this.fireEvent(event);
    }

    @Override
    public void beforeChildReplacement(@NotNull PsiTreeChangeEventImpl event) {
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REPLACEMENT);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildReplacement: oldChild = " + PsiManagerImpl.logPsi(event.getOldChild()));
        }
        this.fireEvent(event);
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEventImpl event) {
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILDREN_CHANGE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildrenChange: parent = " + PsiManagerImpl.logPsi(event.getParent()));
        }
        this.fireEvent(event);
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEventImpl event) {
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_MOVEMENT);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeChildMovement: child = " + PsiManagerImpl.logPsi(event.getChild()) + ", oldParent = " + PsiManagerImpl.logPsi(event.getOldParent()) + ", newParent = " + PsiManagerImpl.logPsi(event.getNewParent()));
        }
        this.fireEvent(event);
    }

    public void beforePropertyChange(@NotNull PsiTreeChangeEventImpl event) {
        this.beforeChange(true);
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.BEFORE_PROPERTY_CHANGE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforePropertyChange: element = " + PsiManagerImpl.logPsi(event.getElement()) + ", propertyName = " + event.getPropertyName() + ", oldValue = " + PsiManagerImpl.arrayToString(event.getOldValue()));
        }
        this.fireEvent(event);
    }

    private static Object arrayToString(Object value) {
        return value instanceof Object[] ? Arrays.deepToString((Object[])value) : value;
    }

    public void childAdded(@NotNull PsiTreeChangeEventImpl event) {
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_ADDED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childAdded: child = " + PsiManagerImpl.logPsi(event.getChild()) + ", parent = " + PsiManagerImpl.logPsi(event.getParent()));
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void childRemoved(@NotNull PsiTreeChangeEventImpl event) {
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childRemoved: child = " + PsiManagerImpl.logPsi(event.getChild()) + ", parent = " + PsiManagerImpl.logPsi(event.getParent()));
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void childReplaced(@NotNull PsiTreeChangeEventImpl event) {
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_REPLACED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childReplaced: oldChild = " + PsiManagerImpl.logPsi(event.getOldChild()) + ", newChild = " + PsiManagerImpl.logPsi(event.getNewChild()) + ", parent = " + PsiManagerImpl.logPsi(event.getParent()));
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void childMoved(@NotNull PsiTreeChangeEventImpl event) {
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILD_MOVED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childMoved: child = " + PsiManagerImpl.logPsi(event.getChild()) + ", oldParent = " + PsiManagerImpl.logPsi(event.getOldParent()) + ", newParent = " + PsiManagerImpl.logPsi(event.getNewParent()));
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEventImpl event) {
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.CHILDREN_CHANGED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("childrenChanged: parent = " + PsiManagerImpl.logPsi(event.getParent()));
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void propertyChanged(@NotNull PsiTreeChangeEventImpl event) {
        event.setCode(PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("propertyChanged: element = " + PsiManagerImpl.logPsi(event.getElement()) + ", propertyName = " + event.getPropertyName() + ", oldValue = " + PsiManagerImpl.arrayToString(event.getOldValue()) + ", newValue = " + PsiManagerImpl.arrayToString(event.getNewValue()));
        }
        this.fireEvent(event);
        this.afterChange(true);
    }

    public void addTreeChangePreprocessor(@NotNull PsiTreeChangePreprocessor preprocessor) {
        this.myTreeChangePreprocessors.add(preprocessor);
    }

    public void removeTreeChangePreprocessor(@NotNull PsiTreeChangePreprocessor preprocessor) {
        this.myTreeChangePreprocessors.remove(preprocessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(@NotNull PsiTreeChangeEventImpl event) {
        boolean isRealTreeChange = event.getCode() != PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED && event.getCode() != PsiTreeChangeEventImpl.PsiEventType.BEFORE_PROPERTY_CHANGE;
        PsiFile file2 = event.getFile();
        if (file2 == null || file2.isPhysical()) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        if (isRealTreeChange) {
            LOG.assertTrue(!this.myTreeChangeEventIsFiring, (Object)"Changes to PSI are not allowed inside event processing");
            this.myTreeChangeEventIsFiring = true;
        }
        try {
            for (PsiTreeChangePreprocessor preprocessor : this.myTreeChangePreprocessors) {
                preprocessor.treeChanged(event);
            }
            boolean enableOutOfCodeBlockTracking = ((PsiModificationTrackerImpl)this.myModificationTracker).isEnableCodeBlockTracker();
            for (PsiTreeChangePreprocessor preprocessor : PsiTreeChangePreprocessor.EP.getExtensions((AreaInstance)this.myProject)) {
                if (!enableOutOfCodeBlockTracking && preprocessor instanceof PsiTreeChangePreprocessorBase) continue;
                try {
                    preprocessor.treeChanged(event);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
            if (!enableOutOfCodeBlockTracking) {
                for (PsiTreeChangePreprocessor preprocessor : PsiTreeChangePreprocessor.EP.getExtensions((AreaInstance)this.myProject)) {
                    if (!(preprocessor instanceof PsiTreeChangePreprocessorBase)) continue;
                    try {
                        ((PsiTreeChangePreprocessorBase)preprocessor).onOutOfCodeBlockModification(event);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }
            for (PsiTreeChangeListener listener2 : this.myTreeChangeListeners) {
                try {
                    switch (event.getCode()) {
                        case BEFORE_CHILD_ADDITION: {
                            listener2.beforeChildAddition((PsiTreeChangeEvent)event);
                            break;
                        }
                        case BEFORE_CHILD_REMOVAL: {
                            listener2.beforeChildRemoval((PsiTreeChangeEvent)event);
                            break;
                        }
                        case BEFORE_CHILD_REPLACEMENT: {
                            listener2.beforeChildReplacement((PsiTreeChangeEvent)event);
                            break;
                        }
                        case BEFORE_CHILD_MOVEMENT: {
                            listener2.beforeChildMovement((PsiTreeChangeEvent)event);
                            break;
                        }
                        case BEFORE_CHILDREN_CHANGE: {
                            listener2.beforeChildrenChange((PsiTreeChangeEvent)event);
                            break;
                        }
                        case BEFORE_PROPERTY_CHANGE: {
                            listener2.beforePropertyChange((PsiTreeChangeEvent)event);
                            break;
                        }
                        case CHILD_ADDED: {
                            listener2.childAdded((PsiTreeChangeEvent)event);
                            break;
                        }
                        case CHILD_REMOVED: {
                            listener2.childRemoved((PsiTreeChangeEvent)event);
                            break;
                        }
                        case CHILD_REPLACED: {
                            listener2.childReplaced((PsiTreeChangeEvent)event);
                            break;
                        }
                        case CHILD_MOVED: {
                            listener2.childMoved((PsiTreeChangeEvent)event);
                            break;
                        }
                        case CHILDREN_CHANGED: {
                            listener2.childrenChanged((PsiTreeChangeEvent)event);
                            break;
                        }
                        case PROPERTY_CHANGED: {
                            listener2.propertyChanged((PsiTreeChangeEvent)event);
                        }
                    }
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        finally {
            if (isRealTreeChange) {
                this.myTreeChangeEventIsFiring = false;
            }
        }
    }

    @Override
    public void registerRunnableToRunOnChange(final @NotNull Runnable runnable2) {
        this.myMessageBus.connect().subscribe(ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener.Adapter(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                if (isPhysical) {
                    runnable2.run();
                }
            }
        });
    }

    @Override
    public void registerRunnableToRunOnAnyChange(final @NotNull Runnable runnable2) {
        this.myMessageBus.connect().subscribe(ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener.Adapter(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                runnable2.run();
            }
        });
    }

    @Override
    public void registerRunnableToRunAfterAnyChange(final @NotNull Runnable runnable2) {
        this.myMessageBus.connect().subscribe(ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener.Adapter(){

            @Override
            public void afterPsiChanged(boolean isPhysical) {
                runnable2.run();
            }
        });
    }

    @Override
    public void beforeChange(boolean isPhysical) {
        ((AnyPsiChangeListener)this.myMessageBus.syncPublisher(ANY_PSI_CHANGE_TOPIC)).beforePsiChanged(isPhysical);
    }

    @Override
    public void afterChange(boolean isPhysical) {
        ((AnyPsiChangeListener)this.myMessageBus.syncPublisher(ANY_PSI_CHANGE_TOPIC)).afterPsiChanged(isPhysical);
    }

    @NotNull
    public PsiModificationTracker getModificationTracker() {
        return this.myModificationTracker;
    }

    public void startBatchFilesProcessingMode() {
        this.myBatchFilesProcessingModeCount.incrementAndGet();
    }

    public void finishBatchFilesProcessingMode() {
        this.myBatchFilesProcessingModeCount.decrementAndGet();
        LOG.assertTrue(this.myBatchFilesProcessingModeCount.get() >= 0);
    }

    @Override
    public boolean isBatchFilesProcessingMode() {
        return this.myBatchFilesProcessingModeCount.get() > 0;
    }

    public void cleanupForNextTest() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myFileManager.cleanupForNextTest();
        this.dropPsiCaches();
    }

    public void dropResolveCacheRegularly(@NotNull ProgressIndicator indicator) {
        if ((indicator = ProgressWrapper.unwrap(indicator)) instanceof ProgressIndicatorEx) {
            ((ProgressIndicatorEx)indicator).addStateDelegate(new AbstractProgressIndicatorExBase(){
                private final AtomicLong lastClearedTimeStamp = new AtomicLong();

                @Override
                public void setFraction(double fraction) {
                    long last;
                    long current = System.currentTimeMillis();
                    if (current - (last = this.lastClearedTimeStamp.get()) >= 500L && this.lastClearedTimeStamp.compareAndSet(last, current)) {
                        PsiManagerImpl.this.dropResolveCaches();
                    }
                }
            });
        }
    }
}

