/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiModificationTrackerImpl
implements PsiModificationTracker,
PsiTreeChangePreprocessor {
    private static final RegistryValue ourEnableCodeBlockTracker = Registry.get((String)"psi.modification.tracker.code-block");
    private static final RegistryValue ourEnableJavaStructureTracker = Registry.get((String)"psi.modification.tracker.java-structure");
    private static final RegistryValue ourEnableLanguageTracker = Registry.get((String)"psi.modification.tracker.per-language");
    private final boolean myTestMode = false;
    private final SimpleModificationTracker myModificationCount = new SimpleModificationTracker();
    private final SimpleModificationTracker myOutOfCodeBlockModificationTracker = PsiModificationTrackerImpl.wrapped(ourEnableCodeBlockTracker, this.myModificationCount, false);
    private final SimpleModificationTracker myJavaStructureModificationTracker = PsiModificationTrackerImpl.wrapped(ourEnableJavaStructureTracker, this.myModificationCount, false);
    private final Map<Language, ModificationTracker> myLanguageTrackers = ConcurrentFactoryMap.createMap(language -> new SimpleModificationTracker());
    private final PsiModificationTracker.Listener myPublisher;

    public PsiModificationTrackerImpl(Project project) {
        MessageBus bus = project.getMessageBus();
        this.myPublisher = (PsiModificationTracker.Listener)bus.syncPublisher(TOPIC);
        bus.connect().subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            private void doIncCounter() {
                ApplicationManager.getApplication().runWriteAction(() -> PsiModificationTrackerImpl.this.incCounter());
            }

            public void enteredDumbMode() {
                this.doIncCounter();
            }

            public void exitDumbMode() {
                this.doIncCounter();
            }
        });
    }

    public void incCounter() {
        this.incCountersInner(7);
    }

    public void incOutOfCodeBlockModificationCounter() {
        this.incCountersInner(3);
    }

    private void fireEvent() {
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        this.myPublisher.modificationCountChanged();
    }

    private void incCountersInner(int bits) {
        if ((bits & 1) != 0) {
            this.myModificationCount.incModificationCount();
        }
        if ((bits & 2) != 0) {
            this.myOutOfCodeBlockModificationTracker.incModificationCount();
        }
        if ((bits & 4) != 0) {
            this.myJavaStructureModificationTracker.incModificationCount();
        }
        this.fireEvent();
    }

    @Override
    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (!PsiModificationTrackerImpl.canAffectPsi(event)) {
            return;
        }
        this.incLanguageTrackers(event);
        PsiTreeChangeEventImpl.PsiEventType code = event.getCode();
        boolean outOfCodeBlock = code == PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED ? event.getPropertyName() == "propUnloadedPsi" || event.getPropertyName() == "roots" : (code == PsiTreeChangeEventImpl.PsiEventType.CHILD_MOVED ? event.getOldParent() instanceof PsiDirectory || event.getNewParent() instanceof PsiDirectory : event.getParent() instanceof PsiDirectory);
        this.incCountersInner(outOfCodeBlock ? 7 : 1);
    }

    public static boolean canAffectPsi(@NotNull PsiTreeChangeEventImpl event) {
        return !"writable".equals(event.getPropertyName());
    }

    protected void incLanguageTrackers(@NotNull PsiTreeChangeEventImpl event) {
        if (!ourEnableLanguageTracker.asBoolean()) {
            return;
        }
        this.incLanguageModificationCount(Language.ANY);
        PsiElement[] elements = new PsiElement[]{event.getFile(), event.getParent(), event.getOldParent(), event.getNewParent(), event.getElement(), event.getChild(), event.getOldChild(), event.getNewChild()};
        HashSet languages = ContainerUtil.newHashSet((int)elements.length);
        languages.add(Language.ANY);
        for (PsiElement o : elements) {
            PsiFile file2;
            PsiFile psiFile = file2 = o instanceof PsiFile ? (PsiFile)o : null;
            if (file2 == null) {
                try {
                    IElementType type = PsiUtilCore.getElementType((PsiElement)o);
                    Language language = type != null ? type.getLanguage() : (o != null ? o.getLanguage() : null);
                    ContainerUtil.addIfNotNull((Collection)languages, (Object)language);
                }
                catch (PsiInvalidElementAccessException e) {
                    PsiDocumentManagerBase.LOG.warn((Throwable)e);
                }
                continue;
            }
            for (Language language : file2.getViewProvider().getLanguages()) {
                ContainerUtil.addIfNotNull((Collection)languages, (Object)language);
            }
        }
        for (Language language : languages) {
            this.incLanguageModificationCount(language);
        }
    }

    public long getModificationCount() {
        return this.myModificationCount.getModificationCount();
    }

    public long getOutOfCodeBlockModificationCount() {
        return this.myOutOfCodeBlockModificationTracker.getModificationCount();
    }

    public long getJavaStructureModificationCount() {
        return this.myJavaStructureModificationTracker.getModificationCount();
    }

    @NotNull
    public ModificationTracker getOutOfCodeBlockModificationTracker() {
        return this.myOutOfCodeBlockModificationTracker;
    }

    @NotNull
    public ModificationTracker getJavaStructureModificationTracker() {
        return this.myJavaStructureModificationTracker;
    }

    @ApiStatus.Experimental
    public boolean isEnableCodeBlockTracker() {
        return ourEnableCodeBlockTracker.asBoolean();
    }

    @ApiStatus.Experimental
    public boolean isEnableLanguageTracker() {
        return ourEnableLanguageTracker.asBoolean();
    }

    @ApiStatus.Experimental
    public void incLanguageModificationCount(@Nullable Language language) {
        if (language == null) {
            return;
        }
        ((SimpleModificationTracker)this.myLanguageTrackers.get(language)).incModificationCount();
    }

    @ApiStatus.Experimental
    @NotNull
    public ModificationTracker forLanguage(@NotNull Language language) {
        if (!ourEnableLanguageTracker.asBoolean()) {
            return this;
        }
        return this.myLanguageTrackers.get(language);
    }

    @ApiStatus.Experimental
    @NotNull
    public ModificationTracker forLanguages(@NotNull Condition<? super Language> condition) {
        if (!ourEnableLanguageTracker.asBoolean()) {
            return this;
        }
        return () -> {
            long result2 = 0L;
            for (Language l : this.myLanguageTrackers.keySet()) {
                if (!condition.value((Object)l)) continue;
                result2 += this.myLanguageTrackers.get(l).getModificationCount();
            }
            return result2;
        };
    }

    @NotNull
    private static SimpleModificationTracker wrapped(final RegistryValue value, final SimpleModificationTracker fallback, boolean testMode) {
        if (testMode) {
            return new SimpleModificationTracker();
        }
        return new SimpleModificationTracker(){

            public long getModificationCount() {
                return value.asBoolean() ? super.getModificationCount() : fallback.getModificationCount();
            }

            public void incModificationCount() {
                if (value.asBoolean()) {
                    super.incModificationCount();
                }
            }
        };
    }
}

