/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiParserFacadeImpl
implements PsiParserFacade {
    protected final PsiManagerEx myManager;

    public PsiParserFacadeImpl(PsiManagerEx manager) {
        this.myManager = manager;
    }

    @NotNull
    public PsiElement createWhiteSpaceFromText(@NotNull @NonNls String text) throws IncorrectOperationException {
        FileElement holderElement = DummyHolderFactory.createHolder(this.myManager, null).getTreeElement();
        LeafElement newElement = ASTFactory.leaf(TokenType.WHITE_SPACE, holderElement.getCharTable().intern((CharSequence)text));
        holderElement.rawAddChildren(newElement);
        GeneratedMarkerVisitor.markGenerated(newElement.getPsi());
        return newElement.getPsi();
    }

    @NotNull
    public PsiComment createLineCommentFromText(@NotNull LanguageFileType fileType, @NotNull String text) throws IncorrectOperationException {
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(fileType.getLanguage());
        assert (commenter != null);
        String prefix = commenter.getLineCommentPrefix();
        if (prefix == null) {
            throw new IncorrectOperationException("No line comment prefix defined for language " + fileType.getLanguage().getID());
        }
        PsiFile aFile = this.createDummyFile(prefix + text, fileType);
        return this.findPsiCommentChild(aFile);
    }

    @NotNull
    public PsiComment createBlockCommentFromText(@NotNull Language language, @NotNull String text) throws IncorrectOperationException {
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        assert (commenter != null) : language;
        String blockCommentPrefix = commenter.getBlockCommentPrefix();
        String blockCommentSuffix = commenter.getBlockCommentSuffix();
        PsiFile aFile = PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText("_Dummy_", language, (CharSequence)(blockCommentPrefix + text + blockCommentSuffix));
        return this.findPsiCommentChild(aFile);
    }

    @NotNull
    public PsiComment createLineOrBlockCommentFromText(@NotNull Language lang, @NotNull String text) throws IncorrectOperationException {
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(lang);
        assert (commenter != null) : lang;
        String prefix = commenter.getLineCommentPrefix();
        String blockCommentPrefix = commenter.getBlockCommentPrefix();
        String blockCommentSuffix = commenter.getBlockCommentSuffix();
        assert (prefix != null || blockCommentPrefix != null && blockCommentSuffix != null);
        PsiFile aFile = PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText("_Dummy_", lang, (CharSequence)(prefix != null ? prefix + text : blockCommentPrefix + text + blockCommentSuffix));
        return this.findPsiCommentChild(aFile);
    }

    private PsiComment findPsiCommentChild(PsiFile aFile) {
        PsiElement[] children2;
        for (PsiElement aChildren : children2 = aFile.getChildren()) {
            if (!(aChildren instanceof PsiComment)) continue;
            PsiComment comment = (PsiComment)aChildren;
            DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)comment), null);
            return comment;
        }
        throw new IncorrectOperationException("Incorrect comment \"" + aFile.getText() + "\".");
    }

    protected PsiFile createDummyFile(String text, LanguageFileType fileType) {
        String ext = fileType.getDefaultExtension();
        String fileName2 = "_Dummy_." + ext;
        return PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText((FileType)fileType, fileName2, (CharSequence)text, 0, text.length());
    }
}

