/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiTreeChangePreprocessorBase
implements PsiTreeChangePreprocessor {
    protected final PsiManager myPsiManager;

    public PsiTreeChangePreprocessorBase(@NotNull PsiManager psiManager) {
        this.myPsiManager = psiManager;
    }

    protected abstract boolean acceptsEvent(@NotNull PsiTreeChangeEventImpl var1);

    protected abstract boolean isOutOfCodeBlock(@NotNull PsiElement var1);

    protected boolean isOutOfCodeBlock(@NotNull PsiFileSystemItem file2) {
        return true;
    }

    private boolean _outOfCodeBlock(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return false;
        }
        if (element instanceof PsiDirectory) {
            return false;
        }
        if (element instanceof PsiFileSystemItem) {
            return this.isOutOfCodeBlock((PsiFileSystemItem)element);
        }
        return this.isOutOfCodeBlock(element);
    }

    protected boolean containsStructuralElements(@NotNull PsiElement element) {
        return false;
    }

    private boolean _containsStructuralElements(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        if (element instanceof PsiFileSystemItem) {
            return true;
        }
        return this.containsStructuralElements(element);
    }

    @Override
    public final void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (!PsiModificationTrackerImpl.canAffectPsi(event)) {
            return;
        }
        if (!this.acceptsEvent(event)) {
            return;
        }
        this.onTreeChanged(event);
    }

    protected void onTreeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (this.isOutOfCodeBlockChangeEvent(event)) {
            this.onOutOfCodeBlockModification(event);
            this.doIncOutOfCodeBlockCounter();
        }
    }

    protected final boolean isOutOfCodeBlockChangeEvent(@NotNull PsiTreeChangeEventImpl event) {
        switch (event.getCode()) {
            case BEFORE_PROPERTY_CHANGE: 
            case BEFORE_CHILD_ADDITION: 
            case BEFORE_CHILD_MOVEMENT: {
                return false;
            }
            case BEFORE_CHILD_REMOVAL: 
            case BEFORE_CHILD_REPLACEMENT: {
                return this._containsStructuralElements(event.getChild()) || this._containsStructuralElements(event.getOldChild());
            }
            case BEFORE_CHILDREN_CHANGE: 
            case CHILDREN_CHANGED: {
                return !event.isGenericChange() && (this._outOfCodeBlock(event.getParent()) || this._containsStructuralElements(event.getParent()));
            }
            case CHILD_ADDED: 
            case CHILD_REMOVED: 
            case CHILD_REPLACED: {
                return this._outOfCodeBlock(event.getParent()) || this._containsStructuralElements(event.getChild()) || this._containsStructuralElements(event.getOldChild()) || this._containsStructuralElements(event.getNewChild());
            }
            case PROPERTY_CHANGED: {
                return true;
            }
            case CHILD_MOVED: {
                return this._outOfCodeBlock(event.getOldParent()) || this._outOfCodeBlock(event.getNewParent()) || this._containsStructuralElements(event.getChild());
            }
        }
        return true;
    }

    protected void onOutOfCodeBlockModification(@NotNull PsiTreeChangeEventImpl event) {
    }

    protected void doIncOutOfCodeBlockCounter() {
        ((PsiModificationTrackerImpl)this.myPsiManager.getModificationTracker()).incOutOfCodeBlockModificationCounter();
    }
}

