/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.search.IndexPattern;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.TIntArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFilterLexer
extends DelegateLexer
implements IdTableBuilding.ScanWordProcessor {
    private final OccurrenceConsumer myOccurrenceConsumer;
    private int myTodoScannedBound = 0;
    private int myOccurenceMask;
    private TodoScanningState myTodoScanningState;
    private CharSequence myCachedBufferSequence;
    private char[] myCachedArraySequence;

    protected BaseFilterLexer(Lexer originalLexer, OccurrenceConsumer occurrenceConsumer) {
        super(originalLexer);
        this.myOccurrenceConsumer = occurrenceConsumer;
    }

    protected final void advanceTodoItemCountsInToken() {
        if (!this.myOccurrenceConsumer.isNeedToDo()) {
            return;
        }
        int start2 = this.getTokenStart();
        int end = this.getTokenEnd();
        if ((start2 = Math.max(start2, this.myTodoScannedBound)) >= end) {
            return;
        }
        CharSequence input = this.myCachedBufferSequence.subSequence(start2, end);
        this.myTodoScanningState = BaseFilterLexer.advanceTodoItemsCount(input, this.myOccurrenceConsumer, this.myTodoScanningState);
        this.myTodoScannedBound = end;
    }

    public static TodoScanningState advanceTodoItemsCount(CharSequence input, OccurrenceConsumer consumer, TodoScanningState todoScanningState) {
        if (todoScanningState == null) {
            IndexPattern[] patterns = IndexPatternUtil.getIndexPatterns();
            Matcher[] matchers = new Matcher[patterns.length];
            todoScanningState = new TodoScanningState(patterns, matchers);
            for (int i = 0; i < patterns.length; ++i) {
                Pattern pattern = patterns[i].getOptimizedIndexingPattern();
                if (pattern == null) continue;
                matchers[i] = pattern.matcher("");
            }
        } else {
            todoScanningState.myOccurences.resetQuick();
        }
        for (int i = todoScanningState.myMatchers.length - 1; i >= 0; --i) {
            Matcher matcher = todoScanningState.myMatchers[i];
            if (matcher == null) continue;
            matcher.reset(input);
            while (matcher.find()) {
                int start2 = matcher.start();
                if (start2 == matcher.end() || todoScanningState.myOccurences.indexOf(start2) != -1) continue;
                consumer.incTodoOccurrence(todoScanningState.myPatterns[i]);
                todoScanningState.myOccurences.add(start2);
            }
        }
        return todoScanningState;
    }

    @Override
    public final void run(CharSequence chars, @Nullable char[] charsArray, int start2, int end) {
        this.myOccurrenceConsumer.addOccurrence(chars, charsArray, start2, end, this.myOccurenceMask);
    }

    protected final void addOccurrenceInToken(int occurrenceMask) {
        this.myOccurrenceConsumer.addOccurrence(this.myCachedBufferSequence, this.myCachedArraySequence, this.getTokenStart(), this.getTokenEnd(), occurrenceMask);
    }

    protected final void addOccurrenceInToken(int occurrenceMask, int offset, int length) {
        this.myOccurrenceConsumer.addOccurrence(this.myCachedBufferSequence, this.myCachedArraySequence, this.getTokenStart() + offset, Math.min(this.getTokenStart() + offset + length, this.getTokenEnd()), occurrenceMask);
    }

    protected final void scanWordsInToken(int occurrenceMask, boolean mayHaveFileRefs, boolean mayHaveEscapes) {
        this.myOccurenceMask = occurrenceMask;
        int start2 = this.getTokenStart();
        int end = this.getTokenEnd();
        IdTableBuilding.scanWords(this, this.myCachedBufferSequence, this.myCachedArraySequence, start2, end, mayHaveEscapes);
        if (mayHaveFileRefs) {
            this.processPossibleComplexFileName(this.myCachedBufferSequence, this.myCachedArraySequence, start2, end);
        }
    }

    private void processPossibleComplexFileName(CharSequence chars, char[] cachedArraySequence, int startOffset, int endOffset) {
        int offset = BaseFilterLexer.findCharsWithinRange(chars, startOffset, endOffset, "/\\");
        offset = Math.min(offset, endOffset);
        int start2 = startOffset;
        while (start2 < endOffset) {
            if (start2 != offset) {
                this.myOccurrenceConsumer.addOccurrence(chars, cachedArraySequence, start2, offset, 8);
            }
            start2 = offset + 1;
            offset = Math.min(endOffset, BaseFilterLexer.findCharsWithinRange(chars, start2, endOffset, "/\\"));
        }
    }

    private static int findCharsWithinRange(CharSequence chars, int startOffset, int endOffset, String charsToFind) {
        while (startOffset < endOffset) {
            if (charsToFind.indexOf(chars.charAt(startOffset)) != -1) {
                return startOffset;
            }
            ++startOffset;
        }
        return startOffset;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        super.start(buffer, startOffset, endOffset, initialState);
        this.myCachedBufferSequence = this.getBufferSequence();
        this.myCachedArraySequence = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)this.myCachedBufferSequence);
    }

    public static class TodoScanningState {
        final IndexPattern[] myPatterns;
        final Matcher[] myMatchers;
        TIntArrayList myOccurences;

        public TodoScanningState(IndexPattern[] patterns, Matcher[] matchers) {
            this.myPatterns = patterns;
            this.myMatchers = matchers;
            this.myOccurences = new TIntArrayList(1);
        }
    }
}

