/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.todo.TodoIndex;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class IndexTodoCacheManagerImpl
implements TodoCacheManager {
    private final Project myProject;

    public IndexTodoCacheManagerImpl(@NotNull Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public PsiFile[] getFilesWithTodoItems() {
        if (this.myProject.isDefault()) {
            return PsiFile.EMPTY_ARRAY;
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        HashSet allFiles = new HashSet();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        for (IndexPattern indexPattern : IndexPatternUtil.getIndexPatterns()) {
            Collection files2 = fileBasedIndex.getContainingFiles(TodoIndex.NAME, (Object)new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), GlobalSearchScope.allScope((Project)this.myProject));
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            ApplicationManager.getApplication().runReadAction(() -> {
                for (VirtualFile file2 : files2) {
                    PsiFile psiFile;
                    if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file2, (Project)this.myProject) || !projectFileIndex.isInContent(file2) || (psiFile = psiManager.findFile(file2)) == null) continue;
                    allFiles.add(psiFile);
                }
            });
        }
        return allFiles.isEmpty() ? PsiFile.EMPTY_ARRAY : PsiUtilCore.toPsiFileArray(allFiles);
    }

    @Override
    public int getTodoCount(@NotNull VirtualFile file2, @NotNull IndexPatternProvider patternProvider) {
        if (this.myProject.isDefault() || !ProjectFileIndex.getInstance((Project)this.myProject).isInContent(file2)) {
            return 0;
        }
        if (file2 instanceof VirtualFileWindow) {
            return -1;
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        return Arrays.stream(patternProvider.getIndexPatterns()).mapToInt(indexPattern -> this.fetchCount(fileBasedIndex, file2, (IndexPattern)indexPattern)).sum();
    }

    @Override
    public int getTodoCount(@NotNull VirtualFile file2, @NotNull IndexPattern pattern) {
        if (this.myProject.isDefault() || !ProjectFileIndex.getInstance((Project)this.myProject).isInContent(file2)) {
            return 0;
        }
        if (file2 instanceof VirtualFileWindow) {
            return -1;
        }
        return this.fetchCount(FileBasedIndex.getInstance(), file2, pattern);
    }

    private int fetchCount(@NotNull FileBasedIndex fileBasedIndex, @NotNull VirtualFile file2, @NotNull IndexPattern indexPattern) {
        int[] count = new int[]{0};
        fileBasedIndex.processValues(TodoIndex.NAME, (Object)new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), file2, (file1, value) -> {
            count[0] = count[0] + value;
            return true;
        }, GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)file2));
        return count[0];
    }
}

