/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.lang.cacheBuilder.VersionedWordsScanner;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdIndexer;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IdDataConsumer;
import com.intellij.util.text.CharArrayUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ScanningIdIndexer
implements IdIndexer {
    protected abstract WordsScanner createScanner();

    @NotNull
    public Map<IdIndexEntry, Integer> map(@NotNull FileContent inputData) {
        final CharSequence chars = inputData.getContentAsText();
        final char[] charsArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)chars);
        final IdDataConsumer consumer = new IdDataConsumer();
        this.createScanner().processWords(chars, (Processor)new Processor<WordOccurrence>(){

            public boolean process(WordOccurrence t) {
                if (charsArray != null && t.getBaseText() == chars) {
                    consumer.addOccurrence(charsArray, t.getStart(), t.getEnd(), this.convertToMask(t.getKind()));
                } else {
                    consumer.addOccurrence(t.getBaseText(), t.getStart(), t.getEnd(), this.convertToMask(t.getKind()));
                }
                return true;
            }

            private int convertToMask(WordOccurrence.Kind kind) {
                if (kind == null) {
                    return 255;
                }
                if (kind == WordOccurrence.Kind.CODE) {
                    return 1;
                }
                if (kind == WordOccurrence.Kind.COMMENTS) {
                    return 2;
                }
                if (kind == WordOccurrence.Kind.LITERALS) {
                    return 4;
                }
                if (kind == WordOccurrence.Kind.FOREIGN_LANGUAGE) {
                    return 8;
                }
                return 0;
            }
        });
        return consumer.getResult();
    }

    @Override
    public int getVersion() {
        WordsScanner scanner = this.createScanner();
        return scanner instanceof VersionedWordsScanner ? ((VersionedWordsScanner)scanner).getVersion() : -1;
    }
}

