/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class PsiFileImplUtil {
    private PsiFileImplUtil() {
    }

    public static PsiFile setName(@NotNull PsiFile file2, @NotNull String newName) throws IncorrectOperationException {
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        PsiManagerImpl manager = (PsiManagerImpl)file2.getManager();
        try {
            FileDocumentManager fdm;
            Document doc;
            FileType newFileType = FileTypeRegistry.getInstance().getFileTypeByFileName(newName);
            if ((UnknownFileType.INSTANCE.equals(newFileType) || newFileType.isBinary()) && (doc = (fdm = FileDocumentManager.getInstance()).getCachedDocument(vFile)) != null) {
                fdm.saveDocumentAsIs(doc);
            }
            vFile.rename((Object)manager, newName);
        }
        catch (IOException e) {
            throw new IncorrectOperationException((Throwable)e);
        }
        return file2.getViewProvider().isPhysical() ? manager.findFile(vFile) : file2;
    }

    public static void checkSetName(@NotNull PsiFile file2, @NotNull String name) throws IncorrectOperationException {
        VirtualFile vFile = file2.getVirtualFile();
        VirtualFile parentFile = vFile.getParent();
        if (parentFile == null) {
            return;
        }
        VirtualFile child2 = parentFile.findChild(name);
        if (child2 != null && !child2.equals(vFile)) {
            throw new IncorrectOperationException("File " + child2.getPresentableUrl() + " already exists.");
        }
    }

    public static void doDelete(@NotNull PsiFile file2) throws IncorrectOperationException {
        PsiManagerImpl manager = (PsiManagerImpl)file2.getManager();
        VirtualFile vFile = file2.getVirtualFile();
        try {
            vFile.delete((Object)manager);
        }
        catch (IOException e) {
            throw new IncorrectOperationException((Throwable)e);
        }
    }
}

