/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconLayerProvider;
import com.intellij.ide.IconProvider;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.roots.ui.configuration.SourceRootPresentation;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceRootIconProvider {
    @NotNull
    public static Icon getDirectoryIcon(VirtualFile vFile, Project project) {
        SourceFolder sourceFolder = ProjectRootsUtil.getModuleSourceRoot(vFile, project);
        if (sourceFolder != null) {
            return SourceRootPresentation.getSourceRootIcon(sourceFolder);
        }
        Icon excludedIcon = SourceRootIconProvider.getIconIfExcluded(project, vFile);
        return excludedIcon != null ? excludedIcon : PlatformIcons.FOLDER_ICON;
    }

    @Nullable
    public static Icon getIconIfExcluded(@NotNull Project project, @NotNull VirtualFile vFile) {
        boolean ignored;
        if (!Registry.is((String)"ide.hide.excluded.files") && (ignored = ProjectRootManager.getInstance((Project)project).getFileIndex().isExcluded(vFile))) {
            return AllIcons.Modules.ExcludeRoot;
        }
        return null;
    }

    @Nullable
    private static Icon calcFileLayerIcon(VirtualFile vFile, Project project) {
        ProjectFileIndexImpl index = (ProjectFileIndexImpl)ProjectFileIndex.getInstance((Project)project);
        if (vFile != null) {
            VirtualFile parent = vFile.getParent();
            if (index.isExcluded(vFile)) {
                if (parent == null || !index.isExcluded(parent)) {
                    return AllIcons.Nodes.ExcludedFromCompile;
                }
            } else {
                SourceFolder sourceFolder = index.getSourceFolder(vFile);
                if (sourceFolder != null && vFile.equals(sourceFolder.getFile())) {
                    SourceFolder parentSourceFolder;
                    SourceFolder sourceFolder2 = parentSourceFolder = parent == null ? null : index.getSourceFolder(parent);
                    if (parentSourceFolder == null || !sourceFolder.equals(parentSourceFolder)) {
                        return SourceRootPresentation.getSourceRootFileLayerIcon(sourceFolder);
                    }
                }
            }
        }
        return null;
    }

    public static class FileLayerProvider
    implements IconLayerProvider,
    DumbAware {
        @Nullable
        public Icon getLayerIcon(@NotNull Iconable element, boolean isLocked) {
            if (element instanceof PsiFile) {
                Project project = ((PsiFile)element).getProject();
                VirtualFile virtualFile = ((PsiFile)element).getVirtualFile();
                return (Icon)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)element), () -> CachedValueProvider.Result.create((Object)SourceRootIconProvider.calcFileLayerIcon(virtualFile, project), (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)}));
            }
            return null;
        }

        @NotNull
        public String getLayerDescription() {
            return "Source root files";
        }
    }

    public static class DirectoryProvider
    extends IconProvider
    implements DumbAware {
        public Icon getIcon(@NotNull PsiElement element, int flags) {
            if (element instanceof PsiDirectory) {
                PsiDirectory psiDirectory = (PsiDirectory)element;
                return SourceRootIconProvider.getDirectoryIcon(psiDirectory.getVirtualFile(), psiDirectory.getProject());
            }
            return null;
        }
    }
}

