/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.StackOverflowPreventedException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileTypeFileViewProviders;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileManagerImpl
implements FileManager {
    private static final Key<Boolean> IN_COMA = Key.create((String)"IN_COMA");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.impl.FileManagerImpl");
    private final Key<FileViewProvider> myPsiHardRefKey = Key.create((String)"HARD_REFERENCE_TO_PSI");
    private final PsiManagerImpl myManager;
    private final FileIndexFacade myFileIndex;
    private final AtomicReference<ConcurrentMap<VirtualFile, PsiDirectory>> myVFileToPsiDirMap = new AtomicReference();
    private final AtomicReference<ConcurrentMap<VirtualFile, FileViewProvider>> myVFileToViewProviderMap = new AtomicReference();
    private final ThreadLocal<Map<VirtualFile, FileViewProvider>> myTempProviders = ThreadLocal.withInitial(() -> new HashMap());
    private boolean myDisposed;
    private final FileDocumentManager myFileDocumentManager;
    private final MessageBusConnection myConnection;
    private static final VirtualFile NULL = new LightVirtualFile();
    private boolean myProcessingFileTypesChange;

    public FileManagerImpl(PsiManagerImpl manager, FileDocumentManager fileDocumentManager, FileIndexFacade fileIndex) {
        this.myManager = manager;
        this.myFileIndex = fileIndex;
        this.myConnection = manager.getProject().getMessageBus().connect();
        this.myFileDocumentManager = fileDocumentManager;
        Disposer.register((Disposable)manager.getProject(), (Disposable)this);
        LowMemoryWatcher.register(this::processQueue, (Disposable)this);
        this.myConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                FileManagerImpl.this.processFileTypesChanged();
            }

            public void exitDumbMode() {
                FileManagerImpl.this.processFileTypesChanged();
            }
        });
    }

    public void processQueue() {
        ConcurrentMap<VirtualFile, FileViewProvider> map2 = this.myVFileToViewProviderMap.get();
        if (map2 != null) {
            map2.remove(NULL);
        }
    }

    @VisibleForTesting
    @NotNull
    public ConcurrentMap<VirtualFile, FileViewProvider> getVFileToViewProviderMap() {
        ConcurrentMap map2 = this.myVFileToViewProviderMap.get();
        if (map2 == null) {
            map2 = (ConcurrentMap)ConcurrencyUtil.cacheOrGet(this.myVFileToViewProviderMap, (Object)ContainerUtil.createConcurrentWeakValueMap());
        }
        return map2;
    }

    @NotNull
    private ConcurrentMap<VirtualFile, PsiDirectory> getVFileToPsiDirMap() {
        ConcurrentMap map2 = this.myVFileToPsiDirMap.get();
        if (map2 == null) {
            map2 = (ConcurrentMap)ConcurrencyUtil.cacheOrGet(this.myVFileToPsiDirMap, (Object)ContainerUtil.createConcurrentSoftValueMap());
        }
        return map2;
    }

    public static void clearPsiCaches(@NotNull FileViewProvider provider) {
        ((AbstractFileViewProvider)provider).getCachedPsiFiles().forEach(PsiFile::clearCaches);
    }

    public void forceReload(@NotNull VirtualFile vFile) {
        LanguageSubstitutors.cancelReparsing((VirtualFile)vFile);
        FileViewProvider viewProvider = this.findCachedViewProvider(vFile);
        if (viewProvider == null) {
            return;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile dir = vFile.getParent();
        PsiDirectory parentDir = dir == null ? null : this.getCachedDirectory(dir);
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        if (parentDir == null) {
            event.setPropertyName("propUnloadedPsi");
            this.myManager.beforePropertyChange(event);
            this.setViewProvider(vFile, null);
            this.myManager.propertyChanged(event);
        } else {
            event.setParent((PsiElement)parentDir);
            this.myManager.beforeChildrenChange(event);
            this.setViewProvider(vFile, null);
            this.myManager.childrenChanged(event);
        }
    }

    public void firePropertyChangedForUnloadedPsi() {
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        event.setPropertyName("propUnloadedPsi");
        this.myManager.beforePropertyChange(event);
        this.myManager.propertyChanged(event);
    }

    public void dispose() {
        this.myConnection.disconnect();
        this.clearViewProviders();
        this.myDisposed = true;
    }

    private void clearViewProviders() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        DebugUtil.performPsiModification("clearViewProviders", () -> {
            ConcurrentMap<VirtualFile, FileViewProvider> map2 = this.myVFileToViewProviderMap.get();
            if (map2 != null) {
                for (FileViewProvider provider : map2.values()) {
                    this.markInvalidated(provider);
                }
            }
            this.myVFileToViewProviderMap.set(null);
        });
    }

    @Override
    public void cleanupForNextTest() {
        ApplicationManager.getApplication().runWriteAction(this::clearViewProviders);
        this.myVFileToPsiDirMap.set(null);
        ((PsiModificationTrackerImpl)this.myManager.getModificationTracker()).incCounter();
    }

    @Override
    @NotNull
    public FileViewProvider findViewProvider(@NotNull VirtualFile file2) {
        assert (!file2.isDirectory());
        FileViewProvider viewProvider = this.findCachedViewProvider(file2);
        if (viewProvider != null) {
            return viewProvider;
        }
        if (file2 instanceof VirtualFileWindow) {
            throw new IllegalStateException("File " + file2 + " is invalid");
        }
        Map<VirtualFile, FileViewProvider> tempMap = this.myTempProviders.get();
        if (tempMap.containsKey(file2)) {
            return Objects.requireNonNull(tempMap.get(file2), "Recursive file view provider creation");
        }
        viewProvider = this.createFileViewProvider(file2, true);
        if (file2 instanceof LightVirtualFile) {
            return (FileViewProvider)file2.putUserDataIfAbsent(this.myPsiHardRefKey, (Object)viewProvider);
        }
        return (FileViewProvider)ConcurrencyUtil.cacheOrGet(this.getVFileToViewProviderMap(), (Object)file2, (Object)viewProvider);
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file2) {
        FileViewProvider viewProvider = this.getRawCachedViewProvider(file2);
        if (viewProvider instanceof AbstractFileViewProvider && viewProvider.getUserData(IN_COMA) != null) {
            Map<VirtualFile, FileViewProvider> tempMap = this.myTempProviders.get();
            if (tempMap.containsKey(file2)) {
                return tempMap.get(file2);
            }
            if (!this.evaluateValidity((AbstractFileViewProvider)viewProvider)) {
                return null;
            }
        }
        return viewProvider;
    }

    @Nullable
    private FileViewProvider getRawCachedViewProvider(@NotNull VirtualFile file2) {
        ConcurrentMap<VirtualFile, FileViewProvider> map2 = this.myVFileToViewProviderMap.get();
        FileViewProvider viewProvider = map2 == null ? null : (FileViewProvider)map2.get(file2);
        return viewProvider == null ? (FileViewProvider)file2.getUserData(this.myPsiHardRefKey) : viewProvider;
    }

    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile, @Nullable FileViewProvider fileViewProvider) {
        FileViewProvider prev2 = this.getRawCachedViewProvider(virtualFile);
        if (prev2 == fileViewProvider) {
            return;
        }
        if (prev2 != null) {
            DebugUtil.performPsiModification(null, () -> this.markInvalidated(prev2));
        }
        if (fileViewProvider == null) {
            this.getVFileToViewProviderMap().remove(virtualFile);
        } else if (virtualFile instanceof LightVirtualFile) {
            virtualFile.putUserData(this.myPsiHardRefKey, (Object)fileViewProvider);
        } else {
            this.getVFileToViewProviderMap().put(virtualFile, fileViewProvider);
        }
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file2, boolean eventSystemEnabled) {
        FileType fileType = file2.getFileType();
        Language language = LanguageUtil.getLanguageForPsi((Project)this.myManager.getProject(), (VirtualFile)file2);
        FileViewProviderFactory factory = language == null ? (FileViewProviderFactory)FileTypeFileViewProviders.INSTANCE.forFileType(fileType) : (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        SingleRootFileViewProvider viewProvider = factory == null ? null : factory.createFileViewProvider(file2, language, (PsiManager)this.myManager, eventSystemEnabled);
        return viewProvider == null ? new SingleRootFileViewProvider((PsiManager)this.myManager, file2, eventSystemEnabled, fileType) : viewProvider;
    }

    @Deprecated
    public void markInitialized() {
    }

    @Deprecated
    public boolean isInitialized() {
        return true;
    }

    void processFileTypesChanged() {
        if (this.myProcessingFileTypesChange) {
            return;
        }
        this.myProcessingFileTypesChange = true;
        DebugUtil.performPsiModification(null, () -> {
            try {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
                    event.setPropertyName("propFileTypes");
                    this.myManager.beforePropertyChange(event);
                    this.possiblyInvalidatePhysicalPsi();
                    this.myManager.propertyChanged(event);
                });
            }
            finally {
                this.myProcessingFileTypesChange = false;
            }
        });
    }

    void possiblyInvalidatePhysicalPsi() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.removeInvalidDirs();
        for (FileViewProvider provider : this.getVFileToViewProviderMap().values()) {
            FileManagerImpl.markPossiblyInvalidated(provider);
        }
    }

    void dispatchPendingEvents() {
        if (this.myDisposed) {
            LOG.error("Project is already disposed: " + this.myManager.getProject());
        }
        this.myConnection.deliverImmediately();
    }

    void checkConsistency() {
        for (Object file2 : new ArrayList(this.getVFileToViewProviderMap().keySet())) {
            this.findCachedViewProvider((VirtualFile)file2);
        }
        HashMap<VirtualFile, FileViewProvider> fileToViewProvider = new HashMap<VirtualFile, FileViewProvider>(this.getVFileToViewProviderMap());
        this.myVFileToViewProviderMap.set(null);
        for (Map.Entry entry : fileToViewProvider.entrySet()) {
            FileViewProvider fileViewProvider = (FileViewProvider)entry.getValue();
            VirtualFile vFile = (VirtualFile)entry.getKey();
            LOG.assertTrue(vFile.isValid());
            PsiFile psiFile1 = this.findFile(vFile);
            if (psiFile1 == null || fileViewProvider == null || !fileViewProvider.isPhysical()) continue;
            PsiFile psi = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
            assert (psi != null) : fileViewProvider + "; " + fileViewProvider.getBaseLanguage() + "; " + psiFile1;
            assert (psiFile1.getClass().equals(psi.getClass())) : psiFile1 + "; " + psi + "; " + psiFile1.getClass() + "; " + psi.getClass();
        }
        HashMap<VirtualFile, PsiDirectory> fileToPsiDirMap = new HashMap<VirtualFile, PsiDirectory>(this.getVFileToPsiDirMap());
        this.myVFileToPsiDirMap.set(null);
        for (VirtualFile vFile : fileToPsiDirMap.keySet()) {
            LOG.assertTrue(vFile.isValid());
            PsiDirectory psiDir1 = this.findDirectory(vFile);
            LOG.assertTrue(psiDir1 != null);
            VirtualFile parent = vFile.getParent();
            if (parent == null) continue;
            LOG.assertTrue(this.getVFileToPsiDirMap().get(parent) != null);
        }
    }

    @Override
    @Nullable
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        if (vFile.isDirectory()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("Invalid file: " + vFile);
            return null;
        }
        this.dispatchPendingEvents();
        FileViewProvider viewProvider = this.findViewProvider(vFile);
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            throw new InvalidVirtualFileAccessException(vFile);
        }
        if (this.myDisposed) {
            LOG.error("Project is already disposed: " + this.myManager.getProject());
        }
        this.dispatchPendingEvents();
        return this.getCachedPsiFileInner(vFile);
    }

    @Override
    @Nullable
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        if (this.myDisposed) {
            LOG.error("Access to psi files should not be performed after project disposal: " + this.myManager.getProject());
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("File is not valid:" + vFile);
            return null;
        }
        if (!vFile.isDirectory()) {
            return null;
        }
        this.dispatchPendingEvents();
        return this.findDirectoryImpl(vFile, this.getVFileToPsiDirMap());
    }

    @Nullable
    private PsiDirectory findDirectoryImpl(@NotNull VirtualFile vFile, @NotNull ConcurrentMap<VirtualFile, PsiDirectory> psiDirMap) {
        PsiDirectory psiDir = (PsiDirectory)psiDirMap.get(vFile);
        if (psiDir != null) {
            return psiDir;
        }
        if (Registry.is((String)"ide.hide.excluded.files") ? this.myFileIndex.isExcludedFile(vFile) : this.myFileIndex.isUnderIgnored(vFile)) {
            return null;
        }
        VirtualFile parent = vFile.getParent();
        if (parent != null) {
            this.findDirectoryImpl(parent, psiDirMap);
        }
        psiDir = PsiDirectoryFactory.getInstance(this.myManager.getProject()).createDirectory(vFile);
        return (PsiDirectory)ConcurrencyUtil.cacheOrGet(psiDirMap, (Object)vFile, (Object)psiDir);
    }

    public PsiDirectory getCachedDirectory(@NotNull VirtualFile vFile) {
        return (PsiDirectory)this.getVFileToPsiDirMap().get(vFile);
    }

    void removeFilesAndDirsRecursively(@NotNull VirtualFile vFile) {
        DebugUtil.performPsiModification("removeFilesAndDirsRecursively", () -> VfsUtilCore.visitChildrenRecursively((VirtualFile)vFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2.isDirectory()) {
                    FileManagerImpl.this.getVFileToPsiDirMap().remove(file2);
                } else {
                    FileViewProvider viewProvider = (FileViewProvider)FileManagerImpl.this.getVFileToViewProviderMap().remove(file2);
                    if (viewProvider != null) {
                        FileManagerImpl.this.markInvalidated(viewProvider);
                    }
                }
                return true;
            }
        }));
    }

    private void markInvalidated(@NotNull FileViewProvider viewProvider) {
        viewProvider.putUserData(IN_COMA, null);
        ((AbstractFileViewProvider)viewProvider).markInvalidated();
        viewProvider.getVirtualFile().putUserData(this.myPsiHardRefKey, null);
    }

    public static void markPossiblyInvalidated(@NotNull FileViewProvider viewProvider) {
        LOG.assertTrue(!(viewProvider instanceof FreeThreadedFileViewProvider));
        viewProvider.putUserData(IN_COMA, (Object)true);
        ((AbstractFileViewProvider)viewProvider).markPossiblyInvalidated();
        FileManagerImpl.clearPsiCaches(viewProvider);
    }

    @Nullable
    PsiFile getCachedPsiFileInner(@NotNull VirtualFile file2) {
        FileViewProvider fileViewProvider = this.findCachedViewProvider(file2);
        return fileViewProvider != null ? ((AbstractFileViewProvider)fileViewProvider).getCachedPsi(fileViewProvider.getBaseLanguage()) : null;
    }

    @Override
    @NotNull
    public List<PsiFile> getAllCachedFiles() {
        ArrayList<PsiFile> files2 = new ArrayList<PsiFile>();
        for (VirtualFile file2 : new ArrayList(this.getVFileToViewProviderMap().keySet())) {
            FileViewProvider provider = this.findCachedViewProvider(file2);
            if (provider == null) continue;
            ContainerUtil.addIfNotNull(files2, (Object)((AbstractFileViewProvider)provider).getCachedPsi(provider.getBaseLanguage()));
        }
        return files2;
    }

    private void removeInvalidDirs() {
        this.myVFileToPsiDirMap.set(null);
    }

    void removeInvalidFilesAndDirs(boolean useFind) {
        this.removeInvalidDirs();
        THashMap fileToPsiFileMap = new THashMap(this.getVFileToViewProviderMap());
        THashMap originalFileToPsiFileMap = new THashMap(this.getVFileToViewProviderMap());
        if (useFind) {
            this.myVFileToViewProviderMap.set(null);
        }
        Iterator iterator = fileToPsiFileMap.keySet().iterator();
        while (iterator.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator.next();
            if (!vFile.isValid()) {
                iterator.remove();
                continue;
            }
            FileViewProvider view = (FileViewProvider)fileToPsiFileMap.get(vFile);
            if (useFind) {
                if (view == null) {
                    iterator.remove();
                    continue;
                }
                PsiFile psiFile1 = this.findFile(vFile);
                if (psiFile1 == null) {
                    iterator.remove();
                    continue;
                }
                if (!FileManagerImpl.areViewProvidersEquivalent(view, psiFile1.getViewProvider())) {
                    iterator.remove();
                    continue;
                }
                FileManagerImpl.clearPsiCaches(view);
                continue;
            }
            if (this.evaluateValidity((AbstractFileViewProvider)view)) continue;
            iterator.remove();
        }
        this.myVFileToViewProviderMap.set(null);
        this.getVFileToViewProviderMap().putAll((Map<VirtualFile, FileViewProvider>)fileToPsiFileMap);
        this.markInvalidations((Map<VirtualFile, FileViewProvider>)originalFileToPsiFileMap);
    }

    static boolean areViewProvidersEquivalent(@NotNull FileViewProvider view1, @NotNull FileViewProvider view2) {
        if (view1.getClass() != view2.getClass() || view1.getFileType() != view2.getFileType()) {
            return false;
        }
        Language baseLanguage = view1.getBaseLanguage();
        if (baseLanguage != view2.getBaseLanguage()) {
            return false;
        }
        if (!view1.getLanguages().equals(view2.getLanguages())) {
            return false;
        }
        PsiFile psi1 = view1.getPsi(baseLanguage);
        PsiFile psi2 = view2.getPsi(baseLanguage);
        if (psi1 == null || psi2 == null) {
            return psi1 == psi2;
        }
        return psi1.getClass() == psi2.getClass();
    }

    private void markInvalidations(@NotNull Map<VirtualFile, FileViewProvider> originalFileToPsiFileMap) {
        if (!originalFileToPsiFileMap.isEmpty()) {
            DebugUtil.performPsiModification(null, () -> {
                for (Map.Entry entry : originalFileToPsiFileMap.entrySet()) {
                    FileViewProvider viewProvider = (FileViewProvider)entry.getValue();
                    if (this.getVFileToViewProviderMap().get(entry.getKey()) == viewProvider) continue;
                    this.markInvalidated(viewProvider);
                }
            });
        }
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file2) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile vFile = file2.getVirtualFile();
        assert (vFile != null);
        Document document = this.myFileDocumentManager.getCachedDocument(vFile);
        if (document != null) {
            this.myFileDocumentManager.reloadFromDisk(document);
        } else {
            this.reloadPsiAfterTextChange(file2.getViewProvider(), vFile);
        }
    }

    void reloadPsiAfterTextChange(@NotNull FileViewProvider viewProvider, @NotNull VirtualFile vFile) {
        if (!FileManagerImpl.areViewProvidersEquivalent(viewProvider, this.createFileViewProvider(vFile, false))) {
            this.forceReload(vFile);
            return;
        }
        ((AbstractFileViewProvider)viewProvider).onContentReload();
    }

    public boolean evaluateValidity(@NotNull PsiFile file2) {
        AbstractFileViewProvider vp = (AbstractFileViewProvider)file2.getViewProvider();
        return this.evaluateValidity(vp) && vp.getCachedPsiFiles().contains(file2);
    }

    private boolean evaluateValidity(@NotNull AbstractFileViewProvider viewProvider) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile file2 = viewProvider.getVirtualFile();
        if (this.getRawCachedViewProvider(file2) != viewProvider) {
            return false;
        }
        if (viewProvider.getUserData(IN_COMA) == null) {
            return true;
        }
        if (this.shouldResurrect(viewProvider, file2)) {
            viewProvider.putUserData(IN_COMA, null);
            LOG.assertTrue(this.getRawCachedViewProvider(file2) == viewProvider);
            for (PsiFile psiFile : viewProvider.getCachedPsiFiles()) {
                if (psiFile.isValid()) continue;
                LOG.error((Throwable)new PsiInvalidElementAccessException((PsiElement)psiFile));
            }
            return true;
        }
        this.getVFileToViewProviderMap().remove(file2, (Object)viewProvider);
        file2.replace(this.myPsiHardRefKey, (Object)viewProvider, null);
        viewProvider.putUserData(IN_COMA, null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldResurrect(@NotNull FileViewProvider viewProvider, @NotNull VirtualFile file2) {
        if (!file2.isValid()) {
            return false;
        }
        Map<VirtualFile, FileViewProvider> tempProviders = this.myTempProviders.get();
        if (tempProviders.containsKey(file2)) {
            LOG.error((Throwable)new StackOverflowPreventedException("isValid leads to endless recursion in " + viewProvider.getClass() + ": " + new ArrayList(viewProvider.getLanguages())));
        }
        tempProviders.put(file2, null);
        try {
            FileViewProvider recreated = this.createFileViewProvider(file2, true);
            tempProviders.put(file2, recreated);
            boolean bl = FileManagerImpl.areViewProvidersEquivalent(viewProvider, recreated) && ((AbstractFileViewProvider)viewProvider).getCachedPsiFiles().stream().noneMatch(f -> FileManagerImpl.hasInvalidOriginal(f));
            return bl;
        }
        finally {
            FileViewProvider temp = tempProviders.remove(file2);
            if (temp != null) {
                DebugUtil.performPsiModification("invalidate temp view provider", () -> ((AbstractFileViewProvider)temp).markInvalidated());
            }
        }
    }

    private static boolean hasInvalidOriginal(@NotNull PsiFile file2) {
        PsiFile original = file2.getOriginalFile();
        return original != file2 && !original.isValid();
    }
}

