/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.search.BulkOccurrenceProcessor;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.PsiSearchRequest;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.ScopeOptimizer;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSearchHelperImpl
implements PsiSearchHelper {
    private static final ExtensionPointName<ScopeOptimizer> USE_SCOPE_OPTIMIZER_EP_NAME = ExtensionPointName.create((String)"com.intellij.useScopeOptimizer");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.PsiSearchHelperImpl");
    private final PsiManagerEx myManager;
    private final DumbService myDumbService;

    @NotNull
    public SearchScope getUseScope(@NotNull PsiElement element) {
        SearchScope scope = element.getUseScope();
        for (UseScopeEnlarger enlarger : (UseScopeEnlarger[])UseScopeEnlarger.EP_NAME.getExtensions()) {
            ProgressManager.checkCanceled();
            SearchScope additionalScope = enlarger.getAdditionalUseScope(element);
            if (additionalScope == null) continue;
            scope = scope.union(additionalScope);
        }
        SearchScope scopeToRestrict = ScopeOptimizer.calculateOverallRestrictedUseScope((ScopeOptimizer[])((ScopeOptimizer[])USE_SCOPE_OPTIMIZER_EP_NAME.getExtensions()), (PsiElement)element);
        if (scopeToRestrict != null) {
            scope = scope.intersectWith(scopeToRestrict);
        }
        return scope;
    }

    public PsiSearchHelperImpl(@NotNull PsiManagerEx manager) {
        this.myManager = manager;
        this.myDumbService = DumbService.getInstance((Project)this.myManager.getProject());
    }

    @NotNull
    public PsiElement[] findCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope) {
        List result2 = Collections.synchronizedList(new ArrayList());
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.processCommentsContainingIdentifier(identifier, searchScope, (Processor<? super PsiElement>)processor2);
        return PsiUtilCore.toPsiElementArray(result2);
    }

    public boolean processCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope, @NotNull Processor<? super PsiElement> processor2) {
        TextOccurenceProcessor occurrenceProcessor = (element, offsetInElement) -> {
            if (CommentUtilCore.isCommentTextElement(element) && element.findReferenceAt(offsetInElement) == null) {
                return processor2.process((Object)element);
            }
            return true;
        };
        return this.processElementsWithWord(occurrenceProcessor, searchScope, identifier, (short)2, true);
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitive) {
        return this.processElementsWithWord(processor2, searchScope, text, searchContext, caseSensitive, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope));
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitive, boolean processInjectedPsi) {
        EnumSet<Options> options = EnumSet.of(Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE);
        if (caseSensitive) {
            options.add(Options.CASE_SENSITIVE_SEARCH);
        }
        if (processInjectedPsi) {
            options.add(Options.PROCESS_INJECTED_PSI);
        }
        return this.processElementsWithWord(processor2, searchScope, text, searchContext, options, null);
    }

    @NotNull
    public AsyncFuture<Boolean> processElementsWithWordAsync(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitively) {
        boolean result2 = this.processElementsWithWord(processor2, searchScope, text, searchContext, caseSensitively, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope));
        return AsyncUtil.wrapBoolean((boolean)result2);
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, @NotNull EnumSet<Options> options, @Nullable String containerName) {
        return this.bulkProcessElementsWithWord(searchScope, text, searchContext, options, containerName, (scope, offsetsInScope, searcher) -> LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, options.contains((Object)Options.PROCESS_INJECTED_PSI), PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, processor2));
    }

    private boolean bulkProcessElementsWithWord(@NotNull SearchScope searchScope, @NotNull String text, short searchContext, @NotNull EnumSet<Options> options, @Nullable String containerName, final @NotNull BulkOccurrenceProcessor processor2) {
        if (text.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text");
        }
        final ProgressIndicator progress = PsiSearchHelperImpl.getOrCreateIndicator();
        if (searchScope instanceof GlobalSearchScope) {
            StringSearcher searcher = new StringSearcher(text, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
            return this.processElementsWithTextInGlobalScope((GlobalSearchScope)searchScope, searcher, searchContext, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), containerName, progress, processor2);
        }
        LocalSearchScope scope = (LocalSearchScope)searchScope;
        PsiElement[] scopeElements = scope.getScope();
        final StringSearcher searcher = new StringSearcher(text, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
        ReadActionProcessor<PsiElement> localProcessor = new ReadActionProcessor<PsiElement>(){

            public boolean processInReadAction(PsiElement scopeElement) {
                if (!scopeElement.isValid()) {
                    return true;
                }
                if (!scopeElement.isPhysical() || scopeElement instanceof PsiCompiledElement) {
                    scopeElement = scopeElement.getNavigationElement();
                }
                if (scopeElement instanceof PsiCompiledElement) {
                    return true;
                }
                if (scopeElement.getTextRange() == null) {
                    LOG.debug("Element " + scopeElement + " of class " + scopeElement.getClass() + " has null range");
                    return true;
                }
                return processor2.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher, progress), searcher);
            }

            public String toString() {
                return processor2.toString();
            }
        };
        return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(scopeElements), progress, localProcessor);
    }

    @NotNull
    private static ProgressIndicator getOrCreateIndicator() {
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress == null) {
            progress = new EmptyProgressIndicator();
        }
        progress.setIndeterminate(false);
        return progress;
    }

    public static boolean shouldProcessInjectedPsi(@NotNull SearchScope scope) {
        return !(scope instanceof LocalSearchScope) || !((LocalSearchScope)scope).isIgnoreInjectedPsi();
    }

    @NotNull
    private static Processor<PsiElement> localProcessor(final @NotNull ProgressIndicator progress, final @NotNull StringSearcher searcher, final @NotNull BulkOccurrenceProcessor processor2) {
        return new ReadActionProcessor<PsiElement>(){

            public boolean processInReadAction(PsiElement scopeElement) {
                if (scopeElement instanceof PsiCompiledElement) {
                    return true;
                }
                return scopeElement.isValid() && processor2.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher, progress), searcher);
            }

            public String toString() {
                return processor2.toString();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processElementsWithTextInGlobalScope(@NotNull GlobalSearchScope scope, @NotNull StringSearcher searcher, short searchContext, boolean caseSensitively, @Nullable String containerName, @NotNull ProgressIndicator progress, @NotNull BulkOccurrenceProcessor processor2) {
        boolean result2;
        progress.pushState();
        try {
            progress.setText(PsiBundle.message((String)"psi.scanning.files.progress", (Object[])new Object[0]));
            String text = searcher.getPattern();
            THashSet fileSet = new THashSet();
            this.getFilesWithText(scope, searchContext, caseSensitively, text, (Collection<? super VirtualFile>)fileSet);
            progress.setText(PsiBundle.message((String)"psi.search.for.word.progress", (Object[])new Object[]{text}));
            Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(progress, searcher, processor2);
            if (containerName != null) {
                ArrayList intersectionWithContainerFiles = new ArrayList();
                this.getFilesWithText(scope, searchContext, caseSensitively, text + " " + containerName, intersectionWithContainerFiles);
                if (!intersectionWithContainerFiles.isEmpty()) {
                    int totalSize = fileSet.size();
                    boolean result3 = this.processPsiFileRoots(intersectionWithContainerFiles, totalSize, 0, progress, localProcessor);
                    if (result3) {
                        fileSet.removeAll(intersectionWithContainerFiles);
                        if (!fileSet.isEmpty()) {
                            result3 = this.processPsiFileRoots(new ArrayList(fileSet), totalSize, intersectionWithContainerFiles.size(), progress, localProcessor);
                        }
                    }
                    boolean bl = result3;
                    return bl;
                }
            }
            result2 = fileSet.isEmpty() || this.processPsiFileRoots(new ArrayList(fileSet), fileSet.size(), 0, progress, localProcessor);
        }
        finally {
            progress.popState();
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processPsiFileRoots(@NotNull List<? extends VirtualFile> files2, int totalSize, int alreadyProcessedFiles, @NotNull ProgressIndicator progress, @NotNull Processor<? super PsiFile> localProcessor) {
        this.myManager.startBatchFilesProcessingMode();
        try {
            AtomicInteger counter = new AtomicInteger(alreadyProcessedFiles);
            AtomicBoolean stopped = new AtomicBoolean(false);
            boolean bl = PsiSearchHelperImpl.processFilesConcurrentlyDespiteWriteActions(this.myManager.getProject(), files2, progress, stopped, (Processor<? super VirtualFile>)((Processor)vfile -> {
                TooManyUsagesStatus.getFrom(progress).pauseProcessingIfTooManyUsages();
                try {
                    this.processVirtualFile((VirtualFile)vfile, localProcessor, stopped);
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error("Error during processing of: " + vfile.getName(), e);
                    throw e;
                }
                if (progress.isRunning()) {
                    double fraction = (double)counter.incrementAndGet() / (double)totalSize;
                    progress.setFraction(fraction);
                }
                return !stopped.get();
            }));
            return bl;
        }
        finally {
            this.myManager.finishBatchFilesProcessingMode();
        }
    }

    public static boolean processFilesConcurrentlyDespiteWriteActions(@NotNull Project project, @NotNull List<? extends VirtualFile> files2, @NotNull ProgressIndicator progress, @NotNull AtomicBoolean stopped, @NotNull Processor<? super VirtualFile> localProcessor) {
        ApplicationEx app = (ApplicationEx)ApplicationManager.getApplication();
        if (!app.isDispatchThread()) {
            CoreProgressManager.assertUnderProgress(progress);
        }
        while (true) {
            boolean completed;
            ProgressManager.checkCanceled();
            SmartList failedList = new SmartList();
            List failedFiles = Collections.synchronizedList(failedList);
            if (app.isWriteAccessAllowed() || app.isReadAccessAllowed() && app.isWriteActionPending()) {
                completed = ContainerUtil.process(files2, localProcessor);
            } else if (app.isWriteActionPending()) {
                completed = true;
                failedFiles.addAll(files2);
            } else {
                Processor processor2 = vfile -> {
                    ProgressManager.checkCanceled();
                    if (failedFiles.isEmpty()) {
                        try {
                            app.executeByImpatientReader(() -> {
                                if (!localProcessor.process(vfile)) {
                                    stopped.set(true);
                                }
                            });
                        }
                        catch (ApplicationUtil.CannotRunReadActionException action) {
                            failedFiles.add(vfile);
                        }
                    } else {
                        failedFiles.add(vfile);
                    }
                    return !stopped.get();
                };
                completed = JobLauncher.getInstance().invokeConcurrentlyUnderProgress(files2, progress, processor2);
            }
            if (!completed) {
                return false;
            }
            if (failedFiles.isEmpty()) break;
            DumbService.getInstance((Project)project).runReadActionInSmartMode(EmptyRunnable.getInstance());
            files2 = failedList;
        }
        return true;
    }

    private void processVirtualFile(@NotNull VirtualFile vfile, @NotNull Processor<? super PsiFile> localProcessor, @NotNull AtomicBoolean stopped) throws ApplicationUtil.CannotRunReadActionException {
        PsiFile file2 = (PsiFile)ApplicationUtil.tryRunReadAction(() -> vfile.isValid() ? this.myManager.findFile(vfile) : null);
        if (file2 != null && !(file2 instanceof PsiBinaryFile)) {
            if (FileDocumentManager.getInstance().getCachedDocument(vfile) == null) {
                try {
                    vfile.contentsToByteArray();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ApplicationUtil.tryRunReadAction(() -> {
                Project project = this.myManager.getProject();
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                if (DumbService.isDumb((Project)project)) {
                    throw ApplicationUtil.CannotRunReadActionException.create();
                }
                List psiRoots = file2.getViewProvider().getAllFiles();
                THashSet processed2 = new THashSet(psiRoots.size() * 2, 0.5f);
                for (PsiFile psiRoot : psiRoots) {
                    ProgressManager.checkCanceled();
                    assert (psiRoot != null) : "One of the roots of file " + file2 + " is null. All roots: " + psiRoots + "; ViewProvider: " + file2.getViewProvider() + "; Virtual file: " + file2.getViewProvider().getVirtualFile();
                    if (!processed2.add(psiRoot) || !psiRoot.isValid() || localProcessor.process((Object)psiRoot)) continue;
                    stopped.set(true);
                    break;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFilesWithText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text, @NotNull Collection<? super VirtualFile> result2) {
        this.myManager.startBatchFilesProcessingMode();
        try {
            Processor processor2 = Processors.cancelableCollectProcessor(result2);
            boolean bl = this.processFilesWithText(scope, searchContext, caseSensitively, text, (Processor<? super VirtualFile>)processor2);
        }
        finally {
            this.myManager.finishBatchFilesProcessingMode();
        }
    }

    public boolean processFilesWithText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text, @NotNull Processor<? super VirtualFile> processor2) {
        List<IdIndexEntry> entries2 = PsiSearchHelperImpl.getWordEntries(text, caseSensitively);
        if (entries2.isEmpty()) {
            return true;
        }
        Condition contextMatches = integer -> (integer & searchContext) != 0;
        return PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, (Condition<? super Integer>)contextMatches, entries2, processor2);
    }

    @NotNull
    public PsiFile[] findFilesWithPlainTextWords(@NotNull String word) {
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).getFilesWithWord(word, (short)16, GlobalSearchScope.projectScope((Project)this.myManager.getProject()), true);
    }

    public boolean processUsagesInNonJavaFiles(@NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor2, @NotNull GlobalSearchScope searchScope) {
        return this.processUsagesInNonJavaFiles(null, qName, processor2, searchScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processUsagesInNonJavaFiles(@Nullable PsiElement originalElement, @NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor2, @NotNull GlobalSearchScope initialScope) {
        int dollarIndex;
        if (qName.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text. Element: " + originalElement + "; " + (originalElement == null ? null : originalElement.getClass()));
        }
        ProgressIndicator progress = PsiSearchHelperImpl.getOrCreateIndicator();
        int dotIndex = qName.lastIndexOf(46);
        int maxIndex = Math.max(dotIndex, dollarIndex = qName.lastIndexOf(36));
        String wordToSearch = maxIndex >= 0 ? qName.substring(maxIndex + 1) : qName;
        GlobalSearchScope theSearchScope = (GlobalSearchScope)ReadAction.compute(() -> {
            if (originalElement != null && this.myManager.isInProject(originalElement) && initialScope.isSearchInLibraries()) {
                return initialScope.intersectWith(GlobalSearchScope.projectScope((Project)this.myManager.getProject()));
            }
            return initialScope;
        });
        PsiFile[] files2 = (PsiFile[])this.myDumbService.runReadActionInSmartMode(() -> CacheManager.SERVICE.getInstance(this.myManager.getProject()).getFilesWithWord(wordToSearch, (short)16, theSearchScope, true));
        StringSearcher searcher = new StringSearcher(qName, true, true, false);
        progress.pushState();
        Ref stopped = Ref.create((Object)Boolean.FALSE);
        try {
            progress.setText(PsiBundle.message((String)"psi.search.in.non.java.files.progress", (Object[])new Object[0]));
            SearchScope useScope = originalElement == null ? null : (SearchScope)this.myDumbService.runReadActionInSmartMode(() -> this.getUseScope(originalElement));
            int patternLength = qName.length();
            for (int i = 0; i < files2.length; ++i) {
                ProgressManager.checkCanceled();
                PsiFile psiFile = files2[i];
                if (psiFile instanceof PsiBinaryFile) continue;
                CharSequence text = (CharSequence)ReadAction.compute(() -> psiFile.getViewProvider().getContents());
                LowLevelSearchUtil.processTextOccurrences(text, 0, text.length(), searcher, progress, index -> {
                    boolean isReferenceOK = (Boolean)this.myDumbService.runReadActionInSmartMode(() -> {
                        PsiReference referenceAt = psiFile.findReferenceAt(index);
                        return referenceAt == null || useScope == null || !PsiSearchScopeUtil.isInScope((SearchScope)useScope.intersectWith((SearchScope)initialScope), (PsiElement)psiFile);
                    });
                    if (isReferenceOK && !processor2.process(psiFile, index, index + patternLength)) {
                        stopped.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                });
                if (((Boolean)stopped.get()).booleanValue()) {
                    break;
                }
                progress.setFraction((double)(i + 1) / (double)files2.length);
            }
        }
        finally {
            progress.popState();
        }
        return (Boolean)stopped.get() == false;
    }

    public boolean processAllFilesWithWord(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor2, boolean caseSensitively) {
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor2, word, (short)1, scope, caseSensitively);
    }

    public boolean processAllFilesWithWordInText(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor2, boolean caseSensitively) {
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor2, word, (short)16, scope, caseSensitively);
    }

    public boolean processAllFilesWithWordInComments(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor2) {
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor2, word, (short)2, scope, true);
    }

    public boolean processAllFilesWithWordInLiterals(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor2) {
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor2, word, (short)4, scope, true);
    }

    public boolean processRequests(@NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> processor2) {
        QueryRequestsRunResult result2;
        HashMap collectors = ContainerUtil.newHashMap();
        collectors.put(collector, processor2);
        ProgressIndicator progress = PsiSearchHelperImpl.getOrCreateIndicator();
        if (PsiSearchHelperImpl.appendCollectorsFromQueryRequests(progress, collectors) == QueryRequestsRunResult.STOPPED) {
            return false;
        }
        do {
            MultiMap globals = new MultiMap();
            ArrayList customs = ContainerUtil.newArrayList();
            LinkedHashSet locals = ContainerUtil.newLinkedHashSet();
            THashMap localProcessors = new THashMap();
            PsiSearchHelperImpl.distributePrimitives(collectors, locals, (MultiMap<Set<IdIndexEntry>, RequestWithProcessor>)globals, customs, (Map<RequestWithProcessor, Processor<? super PsiElement>>)localProcessors, progress);
            if (!this.processGlobalRequestsOptimized((MultiMap<Set<IdIndexEntry>, RequestWithProcessor>)globals, progress, (Map<RequestWithProcessor, Processor<? super PsiElement>>)localProcessors)) {
                return false;
            }
            for (RequestWithProcessor local : locals) {
                progress.checkCanceled();
                if (this.processSingleRequest(local.request, (Processor<? super PsiReference>)local.refProcessor)) continue;
                return false;
            }
            for (Computable custom : customs) {
                progress.checkCanceled();
                if (((Boolean)custom.compute()).booleanValue()) continue;
                return false;
            }
            result2 = PsiSearchHelperImpl.appendCollectorsFromQueryRequests(progress, collectors);
            if (result2 != QueryRequestsRunResult.STOPPED) continue;
            return false;
        } while (result2 != QueryRequestsRunResult.UNCHANGED);
        return true;
    }

    @NotNull
    public AsyncFuture<Boolean> processRequestsAsync(@NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> processor2) {
        return AsyncUtil.wrapBoolean((boolean)this.processRequests(collector, processor2));
    }

    @NotNull
    private static QueryRequestsRunResult appendCollectorsFromQueryRequests(@NotNull ProgressIndicator progress, @NotNull Map<SearchRequestCollector, Processor<? super PsiReference>> collectors) {
        boolean changed = false;
        LinkedList<SearchRequestCollector> queue2 = new LinkedList<SearchRequestCollector>(collectors.keySet());
        while (!queue2.isEmpty()) {
            progress.checkCanceled();
            SearchRequestCollector each = (SearchRequestCollector)queue2.removeFirst();
            for (QuerySearchRequest request : each.takeQueryRequests()) {
                progress.checkCanceled();
                if (!request.runQuery()) {
                    return QueryRequestsRunResult.STOPPED;
                }
                assert (!collectors.containsKey(request.collector) || collectors.get(request.collector) == request.processor);
                collectors.put(request.collector, (Processor<? super PsiReference>)request.processor);
                queue2.addLast(request.collector);
                changed = true;
            }
        }
        return changed ? QueryRequestsRunResult.CHANGED : QueryRequestsRunResult.UNCHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processGlobalRequestsOptimized(@NotNull MultiMap<Set<IdIndexEntry>, RequestWithProcessor> singles, @NotNull ProgressIndicator progress, @NotNull Map<RequestWithProcessor, Processor<? super PsiElement>> localProcessors) {
        boolean result2;
        Collection requests;
        if (singles.isEmpty()) {
            return true;
        }
        if (singles.size() == 1 && (requests = singles.values()).size() == 1) {
            RequestWithProcessor theOnly = (RequestWithProcessor)requests.iterator().next();
            return this.processSingleRequest(theOnly.request, (Processor<? super PsiReference>)theOnly.refProcessor);
        }
        progress.pushState();
        progress.setText(PsiBundle.message((String)"psi.scanning.files.progress", (Object[])new Object[0]));
        try {
            MultiMap<VirtualFile, RequestWithProcessor> intersectionCandidateFiles = PsiSearchHelperImpl.createMultiMap();
            MultiMap<VirtualFile, RequestWithProcessor> restCandidateFiles = PsiSearchHelperImpl.createMultiMap();
            this.collectFiles(singles, intersectionCandidateFiles, restCandidateFiles);
            if (intersectionCandidateFiles.isEmpty() && restCandidateFiles.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            TreeSet<String> allWords = new TreeSet<String>();
            for (RequestWithProcessor singleRequest : localProcessors.keySet()) {
                ProgressManager.checkCanceled();
                allWords.add(((RequestWithProcessor)singleRequest).request.word);
            }
            progress.setText(PsiBundle.message((String)"psi.search.for.word.progress", (Object[])new Object[]{PsiSearchHelperImpl.getPresentableWordsDescription(allWords)}));
            if (intersectionCandidateFiles.isEmpty()) {
                result2 = this.processCandidates(localProcessors, restCandidateFiles, progress, restCandidateFiles.size(), 0);
            } else {
                int totalSize = restCandidateFiles.size() + intersectionCandidateFiles.size();
                result2 = this.processCandidates(localProcessors, intersectionCandidateFiles, progress, totalSize, 0);
                if (result2) {
                    result2 = this.processCandidates(localProcessors, restCandidateFiles, progress, totalSize, intersectionCandidateFiles.size());
                }
            }
        }
        finally {
            progress.popState();
        }
        return result2;
    }

    private boolean processCandidates(@NotNull Map<RequestWithProcessor, Processor<? super PsiElement>> localProcessors, @NotNull MultiMap<VirtualFile, RequestWithProcessor> candidateFiles, @NotNull ProgressIndicator progress, int totalSize, int alreadyProcessedFiles) {
        ArrayList files2 = new ArrayList(candidateFiles.keySet());
        return this.processPsiFileRoots(files2, totalSize, alreadyProcessedFiles, progress, (Processor<? super PsiFile>)((Processor)psiRoot -> {
            VirtualFile vfile = psiRoot.getVirtualFile();
            for (RequestWithProcessor singleRequest : candidateFiles.get((Object)vfile)) {
                ProgressManager.checkCanceled();
                Processor localProcessor = (Processor)localProcessors.get(singleRequest);
                if (localProcessor.process(psiRoot)) continue;
                return false;
            }
            return true;
        }));
    }

    @NotNull
    private static String getPresentableWordsDescription(@NotNull Set<String> allWords) {
        StringBuilder result2 = new StringBuilder();
        for (String string : allWords) {
            ProgressManager.checkCanceled();
            if (string == null || string.isEmpty()) continue;
            if (result2.length() > 50) {
                result2.append("...");
                break;
            }
            if (result2.length() != 0) {
                result2.append(", ");
            }
            result2.append(string);
        }
        return result2.toString();
    }

    @NotNull
    private static BulkOccurrenceProcessor adaptProcessor(@NotNull PsiSearchRequest singleRequest, final @NotNull Processor<? super PsiReference> consumer) {
        SearchScope searchScope = singleRequest.searchScope;
        final boolean ignoreInjectedPsi = searchScope instanceof LocalSearchScope && ((LocalSearchScope)searchScope).isIgnoreInjectedPsi();
        final RequestResultProcessor wrapped = singleRequest.processor;
        return new BulkOccurrenceProcessor(){

            @Override
            public boolean execute(@NotNull PsiElement scope, @NotNull int[] offsetsInScope, @NotNull StringSearcher searcher) {
                try {
                    ProgressManager.checkCanceled();
                    if (wrapped instanceof RequestResultProcessor.BulkResultProcessor) {
                        return ((RequestResultProcessor.BulkResultProcessor)wrapped).processTextOccurrences(scope, offsetsInScope, consumer);
                    }
                    return LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, !ignoreInjectedPsi, PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, (element, offsetInElement) -> {
                        if (ignoreInjectedPsi && element instanceof PsiLanguageInjectionHost) {
                            return true;
                        }
                        return wrapped.processTextOccurrence(element, offsetInElement, consumer);
                    });
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Error | Exception e) {
                    PsiFile file2 = scope.getContainingFile();
                    LOG.error("Error during processing of: " + (file2 != null ? file2.getName() : scope), e);
                    return true;
                }
            }

            public String toString() {
                return consumer.toString();
            }
        };
    }

    private void collectFiles(@NotNull MultiMap<Set<IdIndexEntry>, RequestWithProcessor> singles, @NotNull MultiMap<VirtualFile, RequestWithProcessor> intersectionResult, @NotNull MultiMap<VirtualFile, RequestWithProcessor> restResult) {
        for (Map.Entry entry : singles.entrySet()) {
            ProgressManager.checkCanceled();
            Set keys = (Set)entry.getKey();
            if (keys.isEmpty()) continue;
            Collection processors = (Collection)entry.getValue();
            GlobalSearchScope commonScope = PsiSearchHelperImpl.uniteScopes(processors);
            Set<VirtualFile> intersectionWithContainerNameFiles = this.intersectionWithContainerNameFiles(commonScope, processors, keys);
            ArrayList result2 = new ArrayList();
            Processor processor2 = Processors.cancelableCollectProcessor(result2);
            PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, null, keys, (Processor<? super VirtualFile>)processor2);
            for (VirtualFile file2 : result2) {
                ProgressManager.checkCanceled();
                for (IdIndexEntry indexEntry : keys) {
                    ProgressManager.checkCanceled();
                    this.myDumbService.runReadActionInSmartMode(() -> FileBasedIndex.getInstance().processValues(IdIndex.NAME, (Object)indexEntry, file2, (file1, value) -> {
                        int mask = value;
                        for (RequestWithProcessor single : processors) {
                            ProgressManager.checkCanceled();
                            PsiSearchRequest request = single.request;
                            if ((mask & request.searchContext) == 0 || !request.searchScope.contains(file1)) continue;
                            MultiMap result1 = intersectionWithContainerNameFiles == null || !intersectionWithContainerNameFiles.contains(file1) ? restResult : intersectionResult;
                            result1.putValue((Object)file1, (Object)single);
                        }
                        return true;
                    }, commonScope));
                }
            }
        }
    }

    @Nullable(value="null means we did not find common container files")
    private Set<VirtualFile> intersectionWithContainerNameFiles(@NotNull GlobalSearchScope commonScope, @NotNull Collection<? extends RequestWithProcessor> data, @NotNull Set<IdIndexEntry> keys) {
        String commonName = null;
        short searchContext = 0;
        boolean caseSensitive = true;
        for (RequestWithProcessor requestWithProcessor : data) {
            ProgressManager.checkCanceled();
            String containerName = ((RequestWithProcessor)requestWithProcessor).request.containerName;
            if (containerName == null) continue;
            if (commonName == null) {
                commonName = containerName;
                searchContext = ((RequestWithProcessor)requestWithProcessor).request.searchContext;
                caseSensitive = ((RequestWithProcessor)requestWithProcessor).request.caseSensitive;
                continue;
            }
            if (commonName.equals(containerName)) {
                searchContext = (short)(searchContext | ((RequestWithProcessor)requestWithProcessor).request.searchContext);
                caseSensitive &= ((RequestWithProcessor)requestWithProcessor).request.caseSensitive;
                continue;
            }
            return null;
        }
        if (commonName == null) {
            return null;
        }
        List<IdIndexEntry> entries2 = PsiSearchHelperImpl.getWordEntries(commonName, caseSensitive);
        if (entries2.isEmpty()) {
            return null;
        }
        entries2.addAll(keys);
        short s = searchContext;
        Condition contextMatches = context -> (context & finalSearchContext) != 0;
        THashSet containerFiles = new THashSet();
        Processor processor2 = Processors.cancelableCollectProcessor((Collection)containerFiles);
        PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, (Condition<? super Integer>)contextMatches, entries2, (Processor<? super VirtualFile>)processor2);
        return containerFiles;
    }

    @NotNull
    private static MultiMap<VirtualFile, RequestWithProcessor> createMultiMap() {
        return MultiMap.createSmart();
    }

    @NotNull
    private static GlobalSearchScope uniteScopes(@NotNull Collection<RequestWithProcessor> requests) {
        Set scopes = ContainerUtil.map2LinkedSet(requests, r -> (GlobalSearchScope)((RequestWithProcessor)r).request.searchScope);
        return GlobalSearchScope.union((GlobalSearchScope[])scopes.toArray(GlobalSearchScope.EMPTY_ARRAY));
    }

    private static void distributePrimitives(@NotNull Map<SearchRequestCollector, Processor<? super PsiReference>> collectors, @NotNull Set<RequestWithProcessor> locals, @NotNull MultiMap<Set<IdIndexEntry>, RequestWithProcessor> globals, @NotNull List<? super Computable<Boolean>> customs, @NotNull Map<RequestWithProcessor, Processor<? super PsiElement>> localProcessors, @NotNull ProgressIndicator progress) {
        for (Map.Entry<SearchRequestCollector, Processor<? super PsiReference>> entry : collectors.entrySet()) {
            ProgressManager.checkCanceled();
            Processor<? super PsiReference> processor2 = entry.getValue();
            SearchRequestCollector collector = entry.getKey();
            for (PsiSearchRequest primitive : collector.takeSearchRequests()) {
                ProgressManager.checkCanceled();
                SearchScope scope = primitive.searchScope;
                if (scope instanceof LocalSearchScope) {
                    PsiSearchHelperImpl.registerRequest(locals, primitive, processor2);
                    continue;
                }
                HashSet<IdIndexEntry> key = new HashSet<IdIndexEntry>(PsiSearchHelperImpl.getWordEntries(primitive.word, primitive.caseSensitive));
                PsiSearchHelperImpl.registerRequest(globals.getModifiable(key), primitive, processor2);
            }
            for (Processor customAction : collector.takeCustomSearchActions()) {
                ProgressManager.checkCanceled();
                customs.add((Computable<Boolean>)((Computable)() -> customAction.process((Object)processor2)));
            }
        }
        for (Map.Entry<Object, Object> entry : globals.entrySet()) {
            ProgressManager.checkCanceled();
            for (RequestWithProcessor singleRequest : (Collection)entry.getValue()) {
                ProgressManager.checkCanceled();
                PsiSearchRequest primitive = singleRequest.request;
                StringSearcher searcher = new StringSearcher(primitive.word, primitive.caseSensitive, true, false);
                BulkOccurrenceProcessor adapted = PsiSearchHelperImpl.adaptProcessor(primitive, (Processor<? super PsiReference>)singleRequest.refProcessor);
                Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(progress, searcher, adapted);
                assert (!localProcessors.containsKey(singleRequest) || localProcessors.get(singleRequest) == localProcessor);
                localProcessors.put(singleRequest, localProcessor);
            }
        }
    }

    private static void registerRequest(@NotNull Collection<RequestWithProcessor> collection, @NotNull PsiSearchRequest primitive, @NotNull Processor<? super PsiReference> processor2) {
        RequestWithProcessor singleRequest = new RequestWithProcessor(primitive, processor2);
        for (RequestWithProcessor existing : collection) {
            ProgressManager.checkCanceled();
            if (!existing.uniteWith(singleRequest)) continue;
            return;
        }
        collection.add(singleRequest);
    }

    private boolean processSingleRequest(@NotNull PsiSearchRequest single, @NotNull Processor<? super PsiReference> consumer) {
        EnumSet<Options> options = EnumSet.of(Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE);
        if (single.caseSensitive) {
            options.add(Options.CASE_SENSITIVE_SEARCH);
        }
        if (PsiSearchHelperImpl.shouldProcessInjectedPsi(single.searchScope)) {
            options.add(Options.PROCESS_INJECTED_PSI);
        }
        return this.bulkProcessElementsWithWord(single.searchScope, single.word, single.searchContext, options, single.containerName, PsiSearchHelperImpl.adaptProcessor(single, consumer));
    }

    @NotNull
    public PsiSearchHelper.SearchCostResult isCheapEnoughToSearch(@NotNull String name, @NotNull GlobalSearchScope scope, final @Nullable PsiFile fileToIgnoreOccurrencesIn, @Nullable ProgressIndicator progress) {
        boolean cheap;
        if (!((Boolean)ReadAction.compute(() -> scope.getUnloadedModulesBelongingToScope().isEmpty())).booleanValue()) {
            return PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
        }
        final AtomicInteger filesCount = new AtomicInteger();
        final AtomicLong filesSizeToProcess = new AtomicLong();
        Processor<VirtualFile> processor2 = new Processor<VirtualFile>(){
            private final VirtualFile virtualFileToIgnoreOccurrencesIn;
            private final int maxFilesToProcess;
            private final int maxFilesSizeToProcess;
            {
                this.virtualFileToIgnoreOccurrencesIn = fileToIgnoreOccurrencesIn == null ? null : fileToIgnoreOccurrencesIn.getVirtualFile();
                this.maxFilesToProcess = Registry.intValue((String)"ide.unused.symbol.calculation.maxFilesToSearchUsagesIn", (int)10);
                this.maxFilesSizeToProcess = Registry.intValue((String)"ide.unused.symbol.calculation.maxFilesSizeToSearchUsagesIn", (int)524288);
            }

            public boolean process(VirtualFile file2) {
                ProgressManager.checkCanceled();
                if (Comparing.equal((Object)file2, (Object)this.virtualFileToIgnoreOccurrencesIn)) {
                    return true;
                }
                int currentFilesCount = filesCount.incrementAndGet();
                long accumulatedFileSizeToProcess = filesSizeToProcess.addAndGet(file2.isDirectory() ? 0L : file2.getLength());
                return currentFilesCount < this.maxFilesToProcess && accumulatedFileSizeToProcess < (long)this.maxFilesSizeToProcess;
            }
        };
        List<IdIndexEntry> keys = PsiSearchHelperImpl.getWordEntries(name, true);
        boolean bl = cheap = keys.isEmpty() || PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, null, keys, (Processor<? super VirtualFile>)processor2);
        if (!cheap) {
            return PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
        }
        return filesCount.get() == 0 ? PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES : PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES;
    }

    private static boolean processFilesContainingAllKeys(@NotNull Project project, @NotNull GlobalSearchScope scope, @Nullable Condition<? super Integer> checker, @NotNull Collection<? extends IdIndexEntry> keys, @NotNull Processor<? super VirtualFile> processor2) {
        FileIndexFacade index = FileIndexFacade.getInstance((Project)project);
        return (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> FileBasedIndex.getInstance().processFilesContainingAllKeys(IdIndex.NAME, keys, scope, checker, file2 -> !index.shouldBeFound(scope, file2) || processor2.process(file2)));
    }

    @NotNull
    private static List<IdIndexEntry> getWordEntries(@NotNull String name, boolean caseSensitively) {
        String trimmed;
        List<String> words = StringUtil.getWordsInStringLongestFirst((String)name);
        if (words.isEmpty() && StringUtil.isNotEmpty((String)(trimmed = name.trim()))) {
            words = Collections.singletonList(trimmed);
        }
        if (words.isEmpty()) {
            return Collections.emptyList();
        }
        return ContainerUtil.map2List((Collection)words, word -> new IdIndexEntry((String)word, caseSensitively));
    }

    public static boolean processTextOccurrences(@NotNull PsiElement element, @NotNull String stringToSearch, @NotNull GlobalSearchScope searchScope, @NotNull Processor<? super UsageInfo> processor2, @NotNull UsageInfoFactory factory) {
        PsiSearchHelper helper = (PsiSearchHelper)ReadAction.compute(() -> PsiSearchHelper.getInstance((Project)element.getProject()));
        return helper.processUsagesInNonJavaFiles(element, stringToSearch, (psiFile, startOffset, endOffset) -> {
            try {
                UsageInfo usageInfo = (UsageInfo)ReadAction.compute(() -> factory.createUsageInfo((PsiElement)psiFile, startOffset, endOffset));
                return usageInfo == null || processor2.process((Object)usageInfo);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return true;
            }
        }, searchScope);
    }

    private static enum QueryRequestsRunResult {
        STOPPED,
        UNCHANGED,
        CHANGED;

    }

    private static class RequestWithProcessor {
        @NotNull
        private final PsiSearchRequest request;
        @NotNull
        private Processor<? super PsiReference> refProcessor;

        private RequestWithProcessor(@NotNull PsiSearchRequest request, @NotNull Processor<? super PsiReference> processor2) {
            this.request = request;
            this.refProcessor = processor2;
        }

        private boolean uniteWith(@NotNull RequestWithProcessor another) {
            if (this.request.equals((Object)another.request)) {
                Processor<? super PsiReference> myProcessor = this.refProcessor;
                if (myProcessor != another.refProcessor) {
                    this.refProcessor = psiReference -> myProcessor.process(psiReference) && another.refProcessor.process(psiReference);
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return this.request.toString();
        }
    }

    public static enum Options {
        PROCESS_INJECTED_PSI,
        CASE_SENSITIVE_SEARCH,
        PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE;

    }
}

