/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoIndexPatternProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.search.LightIndexPatternSearch;
import com.intellij.psi.impl.search.TodoItemsCreator;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import com.intellij.psi.search.searches.IndexPatternSearch;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PsiTodoSearchHelperImpl
implements PsiTodoSearchHelper {
    private final PsiManagerEx myManager;
    private static final TodoItem[] EMPTY_TODO_ITEMS = new TodoItem[0];

    public PsiTodoSearchHelperImpl(PsiManagerEx manager) {
        this.myManager = manager;
    }

    @NotNull
    public PsiFile[] findFilesWithTodoItems() {
        return TodoCacheManager.SERVICE.getInstance(this.myManager.getProject()).getFilesWithTodoItems();
    }

    @NotNull
    public TodoItem[] findTodoItems(@NotNull PsiFile file2) {
        return this.findTodoItems(file2, 0, file2.getTextLength());
    }

    @NotNull
    public TodoItem[] findTodoItems(@NotNull PsiFile file2, int startOffset, int endOffset) {
        Collection occurrences = IndexPatternSearch.search((PsiFile)file2, (IndexPatternProvider)TodoIndexPatternProvider.getInstance(), (boolean)TodoConfiguration.getInstance().isMultiLine()).findAll();
        if (occurrences.isEmpty()) {
            return EMPTY_TODO_ITEMS;
        }
        return PsiTodoSearchHelperImpl.processTodoOccurences(startOffset, endOffset, occurrences);
    }

    @NotNull
    private static TodoItem[] processTodoOccurences(int startOffset, int endOffset, Collection<? extends IndexPatternOccurrence> occurrences) {
        ArrayList<TodoItem> items = new ArrayList<TodoItem>(occurrences.size());
        TextRange textRange = new TextRange(startOffset, endOffset);
        TodoItemsCreator todoItemsCreator = new TodoItemsCreator();
        for (IndexPatternOccurrence indexPatternOccurrence : occurrences) {
            TextRange occurrenceRange = indexPatternOccurrence.getTextRange();
            if (!textRange.intersectsStrict(occurrenceRange) && !indexPatternOccurrence.getAdditionalTextRanges().stream().anyMatch(r -> textRange.intersectsStrict(r))) continue;
            items.add(todoItemsCreator.createTodo(indexPatternOccurrence));
        }
        return items.toArray(new TodoItem[0]);
    }

    @NotNull
    public TodoItem[] findTodoItemsLight(@NotNull PsiFile file2) {
        return this.findTodoItemsLight(file2, 0, file2.getTextLength());
    }

    @NotNull
    public TodoItem[] findTodoItemsLight(@NotNull PsiFile file2, int startOffset, int endOffset) {
        Collection occurrences = LightIndexPatternSearch.SEARCH.createQuery(new IndexPatternSearch.SearchParameters(file2, (IndexPatternProvider)TodoIndexPatternProvider.getInstance(), TodoConfiguration.getInstance().isMultiLine())).findAll();
        if (occurrences.isEmpty()) {
            return EMPTY_TODO_ITEMS;
        }
        return PsiTodoSearchHelperImpl.processTodoOccurences(startOffset, endOffset, occurrences);
    }

    public int getTodoItemsCount(@NotNull PsiFile file2) {
        int count = TodoCacheManager.SERVICE.getInstance(this.myManager.getProject()).getTodoCount(file2.getVirtualFile(), TodoIndexPatternProvider.getInstance());
        if (count != -1) {
            return count;
        }
        return this.findTodoItems(file2).length;
    }

    public int getTodoItemsCount(@NotNull PsiFile file2, @NotNull TodoPattern pattern) {
        int count = TodoCacheManager.SERVICE.getInstance(this.myManager.getProject()).getTodoCount(file2.getVirtualFile(), pattern.getIndexPattern());
        if (count != -1) {
            return count;
        }
        TodoItem[] items = this.findTodoItems(file2);
        count = 0;
        for (TodoItem item : items) {
            if (!item.getPattern().equals((Object)pattern)) continue;
            ++count;
        }
        return count;
    }

    public boolean shouldHighlightInEditor(@NotNull PsiFile file2) {
        return true;
    }
}

