/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnchorElementInfo
extends SelfElementInfo {
    private volatile long myStubElementTypeAndId;

    AnchorElementInfo(@NotNull PsiElement anchor2, @NotNull PsiFile containingFile, @NotNull Identikit.ByAnchor identikit) {
        super(ProperTextRange.create((Segment)anchor2.getTextRange()), identikit, containingFile, false);
        this.myStubElementTypeAndId = AnchorElementInfo.pack(-1, null);
    }

    AnchorElementInfo(@NotNull PsiElement anchor2, @NotNull PsiFileWithStubSupport containingFile, int stubId, @NotNull IStubElementType stubElementType) {
        super(null, Identikit.fromTypes(anchor2.getClass(), (IElementType)stubElementType, LanguageUtil.getRootLanguage((PsiElement)containingFile)), containingFile, false);
        this.myStubElementTypeAndId = AnchorElementInfo.pack(stubId, stubElementType);
        assert (!(anchor2 instanceof PsiFile)) : "FileElementInfo must be used for file: " + anchor2;
    }

    private static long pack(int stubId, @Nullable IStubElementType stubElementType) {
        short index;
        short s = index = stubElementType == null ? (short)0 : stubElementType.getIndex();
        assert (index >= 0) : "Unregistered token types not allowed here: " + stubElementType;
        return (long)stubId | (long)index << 32;
    }

    private int getStubId() {
        return (int)this.myStubElementTypeAndId;
    }

    @Override
    @Nullable
    public PsiElement restoreElement(@NotNull SmartPointerManagerImpl manager) {
        long typeAndId = this.myStubElementTypeAndId;
        int stubId = (int)typeAndId;
        if (stubId != -1) {
            PsiFile file2 = this.restoreFile(manager);
            if (!(file2 instanceof PsiFileWithStubSupport)) {
                return null;
            }
            short index = (short)(typeAndId >> 32);
            IStubElementType stubElementType = (IStubElementType)IElementType.find((short)index);
            return PsiAnchor.restoreFromStubIndex((PsiFileWithStubSupport)file2, stubId, stubElementType, false);
        }
        return super.restoreElement(manager);
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other, @NotNull SmartPointerManagerImpl manager) {
        if (other instanceof AnchorElementInfo) {
            if (!this.getVirtualFile().equals(other.getVirtualFile())) {
                return false;
            }
            long packed1 = this.myStubElementTypeAndId;
            long packed2 = ((AnchorElementInfo)other).myStubElementTypeAndId;
            if (packed1 != -1L && packed2 != -1L) {
                return packed1 == packed2;
            }
            if (packed1 != -1L || packed2 != -1L) {
                return (Boolean)ReadAction.compute(() -> Comparing.equal((Object)this.restoreElement(manager), (Object)other.restoreElement(manager)));
            }
        }
        return super.pointsToTheSameElementAs(other, manager);
    }

    @Override
    public void fastenBelt(@NotNull SmartPointerManagerImpl manager) {
        if (this.getStubId() != -1) {
            this.switchToTree(manager);
        }
        super.fastenBelt(manager);
    }

    private void switchToTree(@NotNull SmartPointerManagerImpl manager) {
        PsiElement element = this.restoreElement(manager);
        SmartPointerTracker tracker = manager.getTracker(this.getVirtualFile());
        if (element != null && tracker != null) {
            tracker.switchStubToAst(this, element);
        }
    }

    void switchToTreeRange(@NotNull PsiElement element) {
        this.switchToAnchor(element);
        this.myStubElementTypeAndId = AnchorElementInfo.pack(-1, null);
    }

    @Override
    public Segment getRange(@NotNull SmartPointerManagerImpl manager) {
        if (this.getStubId() != -1) {
            this.switchToTree(manager);
        }
        return super.getRange(manager);
    }

    @Override
    @Nullable
    public TextRange getPsiRange(@NotNull SmartPointerManagerImpl manager) {
        if (this.getStubId() != -1) {
            this.switchToTree(manager);
        }
        return super.getPsiRange(manager);
    }

    @Override
    public String toString() {
        return super.toString() + ",stubId=" + this.getStubId();
    }
}

