/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

class HardElementInfo
extends SmartPointerElementInfo {
    @NotNull
    private final PsiElement myElement;

    HardElementInfo(@NotNull PsiElement element) {
        this.myElement = element;
    }

    @Override
    PsiElement restoreElement(@NotNull SmartPointerManagerImpl manager) {
        return this.myElement;
    }

    @Override
    PsiFile restoreFile(@NotNull SmartPointerManagerImpl manager) {
        return this.myElement.isValid() ? this.myElement.getContainingFile() : null;
    }

    @Override
    int elementHashCode() {
        return this.myElement.hashCode();
    }

    @Override
    boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other, @NotNull SmartPointerManagerImpl manager) {
        return other instanceof HardElementInfo && this.myElement.equals(((HardElementInfo)other).myElement);
    }

    @Override
    VirtualFile getVirtualFile() {
        return PsiUtilCore.getVirtualFile((PsiElement)this.myElement);
    }

    @Override
    Segment getRange(@NotNull SmartPointerManagerImpl manager) {
        return this.myElement.getTextRange();
    }

    @Override
    Segment getPsiRange(@NotNull SmartPointerManagerImpl manager) {
        return this.getRange(manager);
    }

    public String toString() {
        return "hard{" + this.myElement + " of " + this.myElement.getClass() + "}";
    }
}

