/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.ManualRangeMarker;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.editor.impl.event.RetargetRangeMarkers;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MarkerCache {
    static final Comparator<SelfElementInfo> INFO_COMPARATOR = (info1, info2) -> {
        int o1 = info1.getPsiStartOffset();
        int o2 = info2.getPsiStartOffset();
        if (o1 < 0 || o2 < 0) {
            return o1 >= 0 ? -1 : (o2 >= 0 ? 1 : 0);
        }
        if (o1 != o2) {
            return o1 > o2 ? 1 : -1;
        }
        o1 = info1.getPsiEndOffset();
        if (o1 != (o2 = info2.getPsiEndOffset())) {
            return o1 > o2 ? 1 : -1;
        }
        return (info1.isGreedy() ? 1 : 0) - (info2.isGreedy() ? 1 : 0);
    };
    private final SmartPointerTracker myPointers;
    private UpdatedRanges myUpdatedRanges;

    MarkerCache(SmartPointerTracker pointers) {
        this.myPointers = pointers;
    }

    private UpdatedRanges getUpdatedMarkers(@NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        UpdatedRanges answer;
        int eventCount = events.size();
        assert (eventCount > 0);
        UpdatedRanges cache = this.myUpdatedRanges;
        if (cache != null && cache.myEventCount == eventCount) {
            return cache;
        }
        if (cache != null && cache.myEventCount < eventCount) {
            answer = MarkerCache.applyEvents(events.subList(cache.myEventCount, eventCount), cache);
        } else {
            List<SelfElementInfo> infos = this.myPointers.getSortedInfos();
            ManualRangeMarker[] markers = MarkerCache.createMarkers(infos);
            answer = MarkerCache.applyEvents(events, new UpdatedRanges(0, frozen, infos, markers));
        }
        this.myUpdatedRanges = answer;
        return answer;
    }

    @NotNull
    private static ManualRangeMarker[] createMarkers(List<? extends SelfElementInfo> infos) {
        ManualRangeMarker[] markers = new ManualRangeMarker[infos.size()];
        int i = 0;
        while (i < markers.length) {
            SelfElementInfo info = infos.get(i);
            boolean greedy = info.isGreedy();
            int start2 = info.getPsiStartOffset();
            int end = info.getPsiEndOffset();
            markers[i] = new ManualRangeMarker(start2, end, greedy, greedy, !greedy, null);
            ++i;
            while (i < markers.length && MarkerCache.rangeEquals(infos.get(i), start2, end, greedy)) {
                markers[i] = markers[i - 1];
                ++i;
            }
        }
        return markers;
    }

    private static boolean rangeEquals(SelfElementInfo info, int start2, int end, boolean greedy) {
        return start2 == info.getPsiStartOffset() && end == info.getPsiEndOffset() && greedy == info.isGreedy();
    }

    private static UpdatedRanges applyEvents(@NotNull List<? extends DocumentEvent> events, UpdatedRanges struct) {
        FrozenDocument frozen = struct.myResultDocument;
        ManualRangeMarker[] resultMarkers = (ManualRangeMarker[])struct.myMarkers.clone();
        for (DocumentEvent documentEvent : events) {
            DocumentEventImpl corrected;
            FrozenDocument before = frozen;
            if (documentEvent instanceof RetargetRangeMarkers) {
                RetargetRangeMarkers retarget = (RetargetRangeMarkers)documentEvent;
                corrected = new RetargetRangeMarkers(frozen, retarget.getStartOffset(), retarget.getEndOffset(), retarget.getMoveDestinationOffset());
            } else {
                frozen = frozen.applyEvent(documentEvent, 0);
                corrected = new DocumentEventImpl(frozen, documentEvent.getOffset(), documentEvent.getOldFragment(), documentEvent.getNewFragment(), documentEvent.getOldTimeStamp(), documentEvent.isWholeTextReplaced(), ((DocumentEventImpl)documentEvent).getInitialStartOffset(), ((DocumentEventImpl)documentEvent).getInitialOldLength());
            }
            int i = 0;
            while (i < resultMarkers.length) {
                ManualRangeMarker updatedRange;
                int sameMarkersEnd;
                ManualRangeMarker currentRange = resultMarkers[i];
                for (sameMarkersEnd = i + 1; sameMarkersEnd < resultMarkers.length && resultMarkers[sameMarkersEnd] == currentRange; ++sameMarkersEnd) {
                }
                ManualRangeMarker manualRangeMarker = updatedRange = currentRange == null ? null : currentRange.getUpdatedRange(corrected, before);
                while (i < sameMarkersEnd) {
                    resultMarkers[i] = updatedRange;
                    ++i;
                }
            }
        }
        return new UpdatedRanges(struct.myEventCount + events.size(), frozen, struct.mySortedInfos, resultMarkers);
    }

    boolean updateMarkers(@NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        UpdatedRanges updated = this.getUpdatedMarkers(frozen, events);
        boolean sorted = true;
        for (int i = 0; i < updated.myMarkers.length; ++i) {
            SelfElementInfo info = (SelfElementInfo)updated.mySortedInfos.get(i);
            info.setRange(updated.myMarkers[i]);
            if (!sorted || i <= 0 || INFO_COMPARATOR.compare((SelfElementInfo)updated.mySortedInfos.get(i - 1), info) <= 0) continue;
            sorted = false;
        }
        this.myUpdatedRanges = null;
        return sorted;
    }

    @Nullable
    TextRange getUpdatedRange(@NotNull SelfElementInfo info, @NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        UpdatedRanges struct = this.getUpdatedMarkers(frozen, events);
        int i = Collections.binarySearch(struct.mySortedInfos, info, INFO_COMPARATOR);
        ManualRangeMarker updated = i >= 0 ? struct.myMarkers[i] : null;
        return updated == null ? null : new UnfairTextRange(updated.getStartOffset(), updated.getEndOffset());
    }

    @Nullable
    static Segment getUpdatedRange(@NotNull PsiFile containingFile, @NotNull Segment segment, boolean isSegmentGreedy, @NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        SelfElementInfo info = new SelfElementInfo(ProperTextRange.create((Segment)segment), new Identikit(){

            @Override
            @Nullable
            public PsiElement findPsiElement(@NotNull PsiFile file2, int startOffset, int endOffset) {
                return null;
            }

            @Override
            @NotNull
            public Language getFileLanguage() {
                throw new IllegalStateException();
            }

            @Override
            public boolean isForPsiFile() {
                return false;
            }
        }, containingFile, isSegmentGreedy);
        List<SelfElementInfo> infos = Collections.singletonList(info);
        boolean greedy = info.isGreedy();
        int start2 = info.getPsiStartOffset();
        int end = info.getPsiEndOffset();
        boolean surviveOnExternalChange = events.stream().anyMatch(event -> MarkerCache.isWholeDocumentReplace(frozen, (DocumentEventImpl)((Object)event)));
        ManualRangeMarker marker = new ManualRangeMarker(start2, end, greedy, greedy, surviveOnExternalChange, null);
        UpdatedRanges ranges = new UpdatedRanges(0, frozen, infos, new ManualRangeMarker[]{marker});
        List newEvents = ContainerUtil.map(events, event -> MarkerCache.isWholeDocumentReplace(frozen, (DocumentEventImpl)((Object)event)) ? new DocumentEventImpl(event.getDocument(), event.getOffset(), event.getOldFragment(), event.getNewFragment(), event.getOldTimeStamp(), true, ((DocumentEventImpl)((Object)event)).getInitialStartOffset(), ((DocumentEventImpl)((Object)event)).getInitialOldLength()) : event);
        UpdatedRanges updated = MarkerCache.applyEvents(newEvents, ranges);
        return updated.myMarkers[0];
    }

    private static boolean isWholeDocumentReplace(@NotNull FrozenDocument frozen, @NotNull DocumentEventImpl event) {
        return event.getInitialStartOffset() == 0 && event.getInitialOldLength() == frozen.getTextLength();
    }

    void rangeChanged() {
        this.myUpdatedRanges = null;
    }

    private static class UpdatedRanges {
        private final int myEventCount;
        private final FrozenDocument myResultDocument;
        private final List<SelfElementInfo> mySortedInfos;
        private final ManualRangeMarker[] myMarkers;

        UpdatedRanges(int eventCount, @NotNull FrozenDocument resultDocument, @NotNull List<SelfElementInfo> sortedInfos, @NotNull ManualRangeMarker[] markers) {
            this.myEventCount = eventCount;
            this.myResultDocument = resultDocument;
            this.mySortedInfos = sortedInfos;
            this.myMarkers = markers;
        }
    }
}

