/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelfElementInfo
extends SmartPointerElementInfo {
    private static final FileDocumentManager ourFileDocManager = FileDocumentManager.getInstance();
    private volatile Identikit myIdentikit;
    private final VirtualFile myFile;
    private final boolean myForInjected;
    private int myStartOffset;
    private int myEndOffset;

    SelfElementInfo(@Nullable ProperTextRange range2, @NotNull Identikit identikit, @NotNull PsiFile containingFile, boolean forInjected) {
        this.myForInjected = forInjected;
        this.myIdentikit = identikit;
        this.myFile = containingFile.getViewProvider().getVirtualFile();
        this.setRange((Segment)range2);
    }

    void switchToAnchor(@NotNull PsiElement element) {
        this.switchTo(element, this.findAnchor(element));
    }

    private Pair<Identikit.ByAnchor, PsiElement> findAnchor(@NotNull PsiElement element) {
        return Identikit.withAnchor(element, this.myIdentikit.getFileLanguage());
    }

    private void switchTo(@NotNull PsiElement element, @Nullable Pair<Identikit.ByAnchor, PsiElement> pair) {
        if (pair != null) {
            assert (((Identikit.ByAnchor)pair.first).hashCode() == this.myIdentikit.hashCode());
            this.myIdentikit = (Identikit)pair.first;
            this.setRange((Segment)((PsiElement)pair.second).getTextRange());
        } else {
            this.setRange((Segment)element.getTextRange());
        }
    }

    boolean updateRangeToPsi(@NotNull Segment pointerRange, PsiElement cachedElement) {
        Pair<Identikit.ByAnchor, PsiElement> pair = this.findAnchor(cachedElement);
        TextRange range2 = (pair != null ? (PsiElement)pair.second : cachedElement).getTextRange();
        if (range2 != null && range2.intersects(pointerRange)) {
            this.switchTo(cachedElement, pair);
            return true;
        }
        return false;
    }

    void setRange(@Nullable Segment range2) {
        if (range2 == null) {
            this.myStartOffset = -1;
            this.myEndOffset = -1;
        } else {
            this.myStartOffset = range2.getStartOffset();
            this.myEndOffset = range2.getEndOffset();
        }
    }

    boolean hasRange() {
        return this.myStartOffset >= 0;
    }

    int getPsiStartOffset() {
        return this.myStartOffset;
    }

    int getPsiEndOffset() {
        return this.myEndOffset;
    }

    boolean isGreedy() {
        return this.myForInjected || this.myIdentikit.isForPsiFile();
    }

    @Override
    Document getDocumentToSynchronize() {
        return ourFileDocManager.getCachedDocument(this.getVirtualFile());
    }

    @Override
    PsiElement restoreElement(@NotNull SmartPointerManagerImpl manager) {
        TextRange segment = this.getPsiRange(manager);
        if (segment == null) {
            return null;
        }
        PsiFile file2 = this.restoreFile(manager);
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        return this.myIdentikit.findPsiElement(file2, segment.getStartOffset(), segment.getEndOffset());
    }

    @Nullable
    TextRange getPsiRange(@NotNull SmartPointerManagerImpl manager) {
        return this.calcPsiRange();
    }

    boolean isForInjected() {
        return this.myForInjected;
    }

    @Nullable
    private TextRange calcPsiRange() {
        return this.hasRange() ? new UnfairTextRange(this.myStartOffset, this.myEndOffset) : null;
    }

    @Override
    PsiFile restoreFile(@NotNull SmartPointerManagerImpl manager) {
        return SelfElementInfo.restoreFileFromVirtual(this.getVirtualFile(), manager.getProject(), this.myIdentikit.getFileLanguage());
    }

    @Override
    void cleanup() {
        this.setRange(null);
    }

    @Nullable
    public static PsiFile restoreFileFromVirtual(@NotNull VirtualFile virtualFile, @NotNull Project project, @NotNull Language language) {
        return (PsiFile)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return null;
            }
            VirtualFile child2 = SelfElementInfo.restoreVFile(virtualFile);
            if (child2 == null || !child2.isValid()) {
                return null;
            }
            PsiFile file2 = PsiManager.getInstance((Project)project).findFile(child2);
            if (file2 != null) {
                return file2.getViewProvider().getPsi(language == Language.ANY ? file2.getViewProvider().getBaseLanguage() : language);
            }
            return null;
        });
    }

    @Nullable
    public static PsiDirectory restoreDirectoryFromVirtual(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        return (PsiDirectory)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return null;
            }
            VirtualFile child2 = SelfElementInfo.restoreVFile(virtualFile);
            if (child2 == null || !child2.isValid()) {
                return null;
            }
            PsiDirectory file2 = PsiManager.getInstance((Project)project).findDirectory(child2);
            if (file2 == null || !file2.isValid()) {
                return null;
            }
            return file2;
        });
    }

    @Nullable
    private static VirtualFile restoreVFile(@NotNull VirtualFile virtualFile) {
        VirtualFile child2;
        if (virtualFile.isValid()) {
            child2 = virtualFile;
        } else {
            VirtualFile vParent = virtualFile.getParent();
            if (vParent == null || !vParent.isValid()) {
                return null;
            }
            String name = virtualFile.getName();
            child2 = vParent.findChild(name);
        }
        return child2;
    }

    @Override
    int elementHashCode() {
        return this.getVirtualFile().hashCode() + this.myIdentikit.hashCode() * 31;
    }

    @Override
    boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other, @NotNull SmartPointerManagerImpl manager) {
        if (other instanceof SelfElementInfo) {
            SelfElementInfo otherInfo = (SelfElementInfo)other;
            if (!this.getVirtualFile().equals(other.getVirtualFile()) || this.myIdentikit != otherInfo.myIdentikit) {
                return false;
            }
            return (Boolean)ReadAction.compute(() -> {
                TextRange range1 = this.getPsiRange(manager);
                TextRange range2 = otherInfo.getPsiRange(manager);
                return range1 != null && range2 != null && range1.getStartOffset() == range2.getStartOffset() && range1.getEndOffset() == range2.getEndOffset();
            });
        }
        return false;
    }

    @Override
    @NotNull
    final VirtualFile getVirtualFile() {
        return this.myFile;
    }

    @Override
    @Nullable
    Segment getRange(@NotNull SmartPointerManagerImpl manager) {
        SmartPointerTracker tracker;
        PsiDocumentManagerBase documentManager;
        List<DocumentEvent> events;
        Document document;
        if (this.hasRange() && (document = this.getDocumentToSynchronize()) != null && !(events = (documentManager = manager.getPsiDocumentManager()).getEventsSinceCommit(document)).isEmpty() && (tracker = manager.getTracker(this.getVirtualFile())) != null) {
            return tracker.getUpdatedRange(this, (FrozenDocument)documentManager.getLastCommittedDocument(document), events);
        }
        return this.calcPsiRange();
    }

    public String toString() {
        return "psi:range=" + this.calcPsiRange() + ",type=" + this.myIdentikit;
    }

    public static Segment calcActualRangeAfterDocumentEvents(@NotNull PsiFile containingFile, @NotNull Document document, @NotNull Segment segment, boolean isSegmentGreedy) {
        SmartPointerManagerImpl pointerManager;
        SmartPointerTracker tracker;
        Project project = containingFile.getProject();
        PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project);
        List<DocumentEvent> events = documentManager.getEventsSinceCommit(document);
        if (!events.isEmpty() && (tracker = (pointerManager = (SmartPointerManagerImpl)SmartPointerManager.getInstance((Project)project)).getTracker(containingFile.getViewProvider().getVirtualFile())) != null) {
            return tracker.getUpdatedRange(containingFile, segment, isSegmentGreedy, (FrozenDocument)documentManager.getLastCommittedDocument(document), events);
        }
        return null;
    }
}

