/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartPointerManagerImpl
extends SmartPointerManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl");
    private final Project myProject;
    private final Key<SmartPointerTracker> POINTERS_KEY;
    private final PsiDocumentManagerBase myPsiDocManager;
    private static final Key<Reference<SmartPsiElementPointerImpl>> CACHED_SMART_POINTER_KEY = Key.create((String)"CACHED_SMART_POINTER_KEY");

    public SmartPointerManagerImpl(Project project, PsiDocumentManagerBase psiDocManager) {
        this.myProject = project;
        this.myPsiDocManager = psiDocManager;
        this.POINTERS_KEY = Key.create((String)("SMART_POINTERS " + SmartPointerManagerImpl.anonymize(project)));
    }

    @NotNull
    private static String anonymize(@NotNull Project project) {
        return project.isDefault() ? "default" : String.valueOf(project.hashCode());
    }

    public void fastenBelts(@NotNull VirtualFile file2) {
        SmartPointerTracker pointers = this.getTracker(file2);
        if (pointers != null) {
            pointers.fastenBelts(this);
        }
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile containingFile = element.getContainingFile();
        return this.createSmartPsiElementPointer(element, containingFile);
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile) {
        return this.createSmartPsiElementPointer(element, containingFile, false);
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile, boolean forInjected) {
        SmartPointerManagerImpl.ensureValid(element, containingFile);
        SmartPointerTracker.processQueue();
        this.ensureMyProject(containingFile != null ? containingFile.getProject() : element.getProject());
        SmartPsiElementPointerImpl<E> pointer = SmartPointerManagerImpl.getCachedPointer(element);
        if (!(pointer == null || pointer.getElementInfo() instanceof SelfElementInfo && ((SelfElementInfo)pointer.getElementInfo()).isForInjected() != forInjected || pointer.incrementAndGetReferenceCount(1) <= 0)) {
            return pointer;
        }
        pointer = new SmartPsiElementPointerImpl<E>(this, element, containingFile, forInjected);
        if (containingFile != null) {
            this.trackPointer(pointer, containingFile.getViewProvider().getVirtualFile());
        }
        element.putUserData(CACHED_SMART_POINTER_KEY, (Object)new SoftReference(pointer));
        return pointer;
    }

    private void ensureMyProject(@NotNull Project project) {
        if (project != this.myProject) {
            throw new IllegalArgumentException("Element from alien project: " + SmartPointerManagerImpl.anonymize(project) + " expected: " + SmartPointerManagerImpl.anonymize(this.myProject));
        }
    }

    private static void ensureValid(@NotNull PsiElement element, @Nullable PsiFile containingFile) {
        boolean valid;
        boolean bl = valid = containingFile != null ? containingFile.isValid() : element.isValid();
        if (!valid) {
            PsiUtilCore.ensureValid((PsiElement)element);
            if (containingFile != null && !containingFile.isValid()) {
                throw new PsiInvalidElementAccessException((PsiElement)containingFile, "Element " + element.getClass() + "(" + element.getLanguage() + ") claims to be valid but returns invalid containing file ");
            }
        }
    }

    private static <E extends PsiElement> SmartPsiElementPointerImpl<E> getCachedPointer(@NotNull E element) {
        Object cachedElement;
        Reference data = (Reference)element.getUserData(CACHED_SMART_POINTER_KEY);
        SmartPsiElementPointerImpl cachedPointer = (SmartPsiElementPointerImpl)SoftReference.dereference((Reference)data);
        if (cachedPointer != null && (cachedElement = cachedPointer.getElement()) != element) {
            return null;
        }
        return cachedPointer;
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file2, @NotNull TextRange range2) {
        return this.createSmartPsiFileRangePointer(file2, range2, false);
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file2, @NotNull TextRange range2, boolean forInjected) {
        PsiUtilCore.ensureValid((PsiElement)file2);
        SmartPointerTracker.processQueue();
        SmartPsiFileRangePointerImpl pointer = new SmartPsiFileRangePointerImpl(this, file2, ProperTextRange.create((Segment)range2), forInjected);
        this.trackPointer(pointer, file2.getViewProvider().getVirtualFile());
        return pointer;
    }

    private <E extends PsiElement> void trackPointer(@NotNull SmartPsiElementPointerImpl<E> pointer, @NotNull VirtualFile containingFile) {
        SmartPointerTracker pointers;
        SmartPointerElementInfo info = pointer.getElementInfo();
        if (!(info instanceof SelfElementInfo)) {
            return;
        }
        SmartPointerTracker.PointerReference reference = new SmartPointerTracker.PointerReference(pointer, containingFile, this.POINTERS_KEY);
        do {
            if ((pointers = this.getTracker(containingFile)) != null) continue;
            pointers = (SmartPointerTracker)containingFile.putUserDataIfAbsent(this.POINTERS_KEY, (Object)new SmartPointerTracker());
        } while (!pointers.addReference(reference, pointer));
    }

    public void removePointer(@NotNull SmartPsiElementPointer pointer) {
        if (!(pointer instanceof SmartPsiElementPointerImpl) || this.myProject.isDisposed()) {
            return;
        }
        this.ensureMyProject(pointer.getProject());
        int refCount = ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(-1);
        if (refCount == -1) {
            LOG.error("Double smart pointer removal");
            return;
        }
        if (refCount == 0) {
            PsiElement element = ((SmartPointerEx)pointer).getCachedElement();
            if (element != null) {
                element.putUserData(CACHED_SMART_POINTER_KEY, null);
            }
            SmartPointerElementInfo info = ((SmartPsiElementPointerImpl)pointer).getElementInfo();
            info.cleanup();
            SmartPointerTracker.PointerReference reference = ((SmartPsiElementPointerImpl)pointer).pointerReference;
            if (reference != null) {
                if (reference.get() != pointer) {
                    throw new IllegalStateException("Reference points to " + reference.get());
                }
                if (reference.key != this.POINTERS_KEY) {
                    throw new IllegalStateException("Reference from wrong project: " + reference.key + " vs " + this.POINTERS_KEY);
                }
                SmartPointerTracker pointers = this.getTracker(reference.file);
                if (pointers != null) {
                    pointers.removeReference(reference);
                }
            }
        }
    }

    @Nullable
    SmartPointerTracker getTracker(@NotNull VirtualFile containingFile) {
        return (SmartPointerTracker)containingFile.getUserData(this.POINTERS_KEY);
    }

    public int getPointersNumber(@NotNull PsiFile containingFile) {
        VirtualFile file2 = containingFile.getViewProvider().getVirtualFile();
        SmartPointerTracker pointers = this.getTracker(file2);
        return pointers == null ? 0 : pointers.getSize();
    }

    public boolean pointToTheSameElement(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        return SmartPsiElementPointerImpl.pointsToTheSameElementAs(pointer1, pointer2);
    }

    public void updatePointers(@NotNull Document document, @NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        SmartPointerTracker list2;
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        SmartPointerTracker smartPointerTracker = list2 = file2 == null ? null : this.getTracker(file2);
        if (list2 != null) {
            list2.updateMarkers(frozen, events);
        }
    }

    public void updatePointerTargetsAfterReparse(@NotNull VirtualFile file2) {
        SmartPointerTracker list2 = this.getTracker(file2);
        if (list2 != null) {
            list2.updatePointerTargetsAfterReparse();
        }
    }

    @NotNull
    Project getProject() {
        return this.myProject;
    }

    @NotNull
    PsiDocumentManagerBase getPsiDocumentManager() {
        return this.myPsiDocManager;
    }
}

