/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.AnchorElementInfo;
import com.intellij.psi.impl.smartPointers.MarkerCache;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SmartPointerTracker {
    private static final ReferenceQueue<SmartPsiElementPointerImpl> ourQueue = new ReferenceQueue();
    private int nextAvailableIndex;
    private int size;
    private PointerReference[] references = new PointerReference[10];
    private final MarkerCache markerCache = new MarkerCache(this);
    private boolean mySorted;

    SmartPointerTracker() {
    }

    synchronized boolean addReference(@NotNull PointerReference reference, @NotNull SmartPsiElementPointerImpl pointer) {
        if (!this.isActual(reference.file, reference.key)) {
            return false;
        }
        if (this.needsExpansion() || this.isTooSparse()) {
            this.resize();
            if (!this.isActual(reference.file, reference.key)) {
                throw new AssertionError();
            }
        }
        if (this.references[this.nextAvailableIndex] != null) {
            throw new AssertionError(this.references[this.nextAvailableIndex]);
        }
        SmartPointerTracker.storePointerReference(this.references, this.nextAvailableIndex++, reference);
        ++this.size;
        this.mySorted = false;
        if (((SelfElementInfo)pointer.getElementInfo()).hasRange()) {
            this.markerCache.rangeChanged();
        }
        return true;
    }

    private boolean isActual(@NotNull VirtualFile file2, @NotNull Key<SmartPointerTracker> key) {
        return file2.getUserData(key) == this;
    }

    private boolean needsExpansion() {
        return this.nextAvailableIndex >= this.references.length;
    }

    private boolean isTooSparse() {
        return this.nextAvailableIndex > this.size * 2;
    }

    private void resize() {
        PointerReference[] newReferences = new PointerReference[this.size * 3 / 2 + 1];
        int index = 0;
        for (PointerReference ref : this.references) {
            if (ref == null) continue;
            SmartPointerTracker.storePointerReference(newReferences, index++, ref);
        }
        assert (index == this.size) : index + " != " + this.size;
        this.references = newReferences;
        this.nextAvailableIndex = index;
    }

    synchronized void removeReference(@NotNull PointerReference reference) {
        int index = reference.index;
        if (index < 0) {
            return;
        }
        this.assertActual(reference.file, reference.key);
        if (this.references[index] != reference) {
            throw new AssertionError((Object)("At " + index + " expected " + reference + ", found " + this.references[index]));
        }
        this.references[index].index = -1;
        this.references[index] = null;
        if (--this.size == 0) {
            this.disconnectTracker(reference.file, reference.key);
        }
    }

    private void disconnectTracker(VirtualFile file2, Key<SmartPointerTracker> key) {
        if (!file2.replace(key, (Object)this, null)) {
            throw new IllegalStateException("Couldn't clear smart pointer tracker " + this + ", current " + file2.getUserData(key));
        }
    }

    private void assertActual(@NotNull VirtualFile file2, @NotNull Key<SmartPointerTracker> refKey) {
        if (!this.isActual(file2, refKey)) {
            SmartPointerTracker another = (SmartPointerTracker)file2.getUserData(refKey);
            throw new AssertionError((Object)("Smart pointer list mismatch: size=" + this.size + ", ref.key=" + refKey + (another != null ? "; has another pointer list with size " + another.size : "")));
        }
    }

    private void processAlivePointers(@NotNull Processor<? super SmartPsiElementPointerImpl<?>> processor2) {
        for (int i = 0; i < this.nextAvailableIndex; ++i) {
            PointerReference ref = this.references[i];
            if (ref == null) continue;
            if (!this.isActual(ref.file, ref.key)) {
                throw new AssertionError();
            }
            SmartPsiElementPointerImpl pointer = (SmartPsiElementPointerImpl)ref.get();
            if (pointer == null) {
                this.removeReference(ref);
                continue;
            }
            if (processor2.process((Object)pointer)) continue;
            return;
        }
    }

    private void ensureSorted() {
        if (!this.mySorted) {
            ArrayList pointers = new ArrayList();
            this.processAlivePointers((Processor<? super SmartPsiElementPointerImpl<?>>)new CommonProcessors.CollectProcessor(pointers));
            if (this.size != pointers.size()) {
                throw new AssertionError();
            }
            pointers.sort((p1, p2) -> MarkerCache.INFO_COMPARATOR.compare((SelfElementInfo)p1.getElementInfo(), (SelfElementInfo)p2.getElementInfo()));
            for (int i = 0; i < pointers.size(); ++i) {
                SmartPointerTracker.storePointerReference(this.references, i, ((SmartPsiElementPointerImpl)pointers.get((int)i)).pointerReference);
            }
            Arrays.fill(this.references, pointers.size(), this.nextAvailableIndex, null);
            this.nextAvailableIndex = pointers.size();
            this.mySorted = true;
        }
    }

    synchronized void updateMarkers(@NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        boolean stillSorted = this.markerCache.updateMarkers(frozen, events);
        if (!stillSorted) {
            this.mySorted = false;
        }
    }

    @Nullable
    synchronized Segment getUpdatedRange(@NotNull SelfElementInfo info, @NotNull FrozenDocument document, @NotNull List<? extends DocumentEvent> events) {
        return this.markerCache.getUpdatedRange(info, document, events);
    }

    @Nullable
    synchronized Segment getUpdatedRange(@NotNull PsiFile containingFile, @NotNull Segment segment, boolean isSegmentGreedy, @NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        return MarkerCache.getUpdatedRange(containingFile, segment, isSegmentGreedy, frozen, events);
    }

    synchronized void switchStubToAst(@NotNull AnchorElementInfo info, @NotNull PsiElement element) {
        info.switchToTreeRange(element);
        this.markerCache.rangeChanged();
        this.mySorted = false;
    }

    synchronized void fastenBelts(@NotNull SmartPointerManagerImpl manager) {
        SmartPointerTracker.processQueue();
        this.processAlivePointers(pointer -> {
            pointer.getElementInfo().fastenBelt(manager);
            return true;
        });
    }

    synchronized void updatePointerTargetsAfterReparse() {
        this.processAlivePointers(pointer -> {
            if (!(pointer instanceof SmartPsiFileRangePointerImpl)) {
                SmartPointerTracker.updatePointerTarget(pointer, pointer.getPsiRange());
            }
            return true;
        });
    }

    private static <E extends PsiElement> void updatePointerTarget(@NotNull SmartPsiElementPointerImpl<E> pointer, @Nullable Segment pointerRange) {
        E actual;
        E cachedElement = pointer.getCachedElement();
        if (cachedElement == null) {
            return;
        }
        boolean cachedValid = cachedElement.isValid();
        if (cachedValid) {
            if (pointerRange == null) {
                ((SelfElementInfo)pointer.getElementInfo()).switchToAnchor((PsiElement)cachedElement);
                return;
            }
            if (pointerRange.equals(cachedElement.getTextRange())) {
                return;
            }
        }
        if ((actual = pointer.doRestoreElement()) == null && cachedValid && ((SelfElementInfo)pointer.getElementInfo()).updateRangeToPsi(pointerRange, (PsiElement)cachedElement)) {
            return;
        }
        if (actual != cachedElement) {
            pointer.cacheElement(actual);
        }
    }

    private static void storePointerReference(PointerReference[] references, int index, PointerReference ref) {
        references[index] = ref;
        ref.index = index;
    }

    synchronized List<SelfElementInfo> getSortedInfos() {
        this.ensureSorted();
        ArrayList infos = ContainerUtil.newArrayListWithCapacity((int)this.size);
        this.processAlivePointers(pointer -> {
            SelfElementInfo info = (SelfElementInfo)pointer.getElementInfo();
            if (!info.hasRange()) {
                return false;
            }
            infos.add(info);
            return true;
        });
        return infos;
    }

    synchronized int getSize() {
        return this.size;
    }

    static void processQueue() {
        PointerReference reference;
        while ((reference = (PointerReference)ourQueue.poll()) != null) {
            if (reference.get() != null) {
                throw new IllegalStateException("Queued reference has referent!");
            }
            SmartPointerTracker pointers = (SmartPointerTracker)reference.file.getUserData(reference.key);
            if (pointers == null) continue;
            pointers.removeReference(reference);
        }
    }

    static {
        LowMemoryWatcher.register(() -> SmartPointerTracker.processQueue(), (Disposable)ApplicationManager.getApplication());
    }

    static class PointerReference
    extends WeakReference<SmartPsiElementPointerImpl<?>> {
        @NotNull
        final VirtualFile file;
        @NotNull
        final Key<SmartPointerTracker> key;
        private int index = -2;

        PointerReference(@NotNull SmartPsiElementPointerImpl<?> pointer, @NotNull VirtualFile containingFile, @NotNull Key<SmartPointerTracker> key) {
            super(pointer, ourQueue);
            this.file = containingFile;
            this.key = key;
            pointer.pointerReference = this;
        }
    }
}

