/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.smartPointers.AnchorElementInfo;
import com.intellij.psi.impl.smartPointers.ClsElementInfo;
import com.intellij.psi.impl.smartPointers.DirElementInfo;
import com.intellij.psi.impl.smartPointers.FileElementInfo;
import com.intellij.psi.impl.smartPointers.HardElementInfo;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.InjectedSelfElementInfo;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SmartPsiElementPointerImpl<E extends PsiElement>
implements SmartPointerEx<E> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl");
    private Reference<E> myElement;
    private final SmartPointerElementInfo myElementInfo;
    protected final SmartPointerManagerImpl myManager;
    private byte myReferenceCount = 1;
    @Nullable
    SmartPointerTracker.PointerReference pointerReference;

    SmartPsiElementPointerImpl(SmartPointerManagerImpl manager, @NotNull E element, @Nullable PsiFile containingFile, boolean forInjected) {
        this(manager, element, SmartPsiElementPointerImpl.createElementInfo(manager, element, containingFile, forInjected));
    }

    SmartPsiElementPointerImpl(SmartPointerManagerImpl manager, @NotNull E element, @NotNull SmartPointerElementInfo elementInfo) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myElementInfo = elementInfo;
        this.myManager = manager;
        this.cacheElement(element);
    }

    public boolean equals(Object obj) {
        return obj instanceof SmartPsiElementPointer && SmartPsiElementPointerImpl.pointsToTheSameElementAs(this, (SmartPsiElementPointer)obj);
    }

    public int hashCode() {
        return this.myElementInfo.elementHashCode();
    }

    @NotNull
    public Project getProject() {
        return this.myManager.getProject();
    }

    @Nullable
    public E getElement() {
        if (this.getProject().isDisposed()) {
            return null;
        }
        E element = this.getCachedElement();
        if (element == null || !element.isValid()) {
            element = this.doRestoreElement();
            this.cacheElement(element);
        }
        return element;
    }

    @Nullable
    E doRestoreElement() {
        PsiElement element = this.myElementInfo.restoreElement(this.myManager);
        if (element != null && !element.isValid()) {
            return null;
        }
        return (E)element;
    }

    void cacheElement(@Nullable E element) {
        this.myElement = element == null ? null : (PsiManagerEx.getInstanceEx(this.getProject()).isBatchFilesProcessingMode() ? new WeakReference<E>(element) : new java.lang.ref.SoftReference<E>(element));
    }

    public E getCachedElement() {
        return (E)((PsiElement)SoftReference.dereference(this.myElement));
    }

    public PsiFile getContainingFile() {
        PsiFile file2 = this.getElementInfo().restoreFile(this.myManager);
        if (file2 != null) {
            return file2;
        }
        Document doc = this.myElementInfo.getDocumentToSynchronize();
        if (doc == null) {
            E resolved = this.getElement();
            return resolved == null ? null : resolved.getContainingFile();
        }
        return PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(doc);
    }

    public VirtualFile getVirtualFile() {
        return this.myElementInfo.getVirtualFile();
    }

    public Segment getRange() {
        return this.myElementInfo.getRange(this.myManager);
    }

    @Nullable
    public Segment getPsiRange() {
        return this.myElementInfo.getPsiRange(this.myManager);
    }

    @NotNull
    private static <E extends PsiElement> SmartPointerElementInfo createElementInfo(SmartPointerManagerImpl manager, @NotNull E element, PsiFile containingFile, boolean forInjected) {
        PsiElement restored;
        SmartPointerElementInfo elementInfo = SmartPsiElementPointerImpl.doCreateElementInfo(manager.getProject(), element, containingFile, forInjected);
        if (ApplicationManager.getApplication().isUnitTestMode() && !element.equals(restored = elementInfo.restoreElement(manager))) {
            LOG.error("Cannot restore " + element + " of " + element.getClass() + " from " + elementInfo + "; restored=" + restored + " in " + element.getProject());
        }
        return elementInfo;
    }

    @NotNull
    private static <E extends PsiElement> SmartPointerElementInfo doCreateElementInfo(@NotNull Project project, @NotNull E element, PsiFile containingFile, boolean forInjected) {
        SmartPointerElementInfo info;
        if (element instanceof PsiDirectory) {
            return new DirElementInfo((PsiDirectory)element);
        }
        if (element instanceof PsiCompiledElement || containingFile == null || !containingFile.isPhysical() || !element.isPhysical()) {
            if (element instanceof StubBasedPsiElement && element instanceof PsiCompiledElement) {
                if (element instanceof PsiFile) {
                    return new FileElementInfo((PsiFile)element);
                }
                PsiAnchor.StubIndexReference stubReference = PsiAnchor.createStubReference(element, containingFile);
                if (stubReference != null) {
                    return new ClsElementInfo(stubReference);
                }
            }
            return new HardElementInfo(element);
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        if (viewProvider instanceof FreeThreadedFileViewProvider) {
            PsiLanguageInjectionHost hostContext = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
            TextRange elementRange = element.getTextRange();
            if (hostContext != null && elementRange != null) {
                SmartPsiElementPointer hostPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)hostContext);
                return new InjectedSelfElementInfo(project, element, elementRange, containingFile, (SmartPsiElementPointer<PsiLanguageInjectionHost>)hostPointer);
            }
        }
        if (element instanceof PsiFile) {
            return new FileElementInfo((PsiFile)element);
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(viewProvider.getVirtualFile());
        if (document != null && ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project)).getSynchronizer().isDocumentAffectedByTransactions(document)) {
            LOG.error("Smart pointers shouldn't be created during PSI changes");
        }
        if ((info = SmartPsiElementPointerImpl.createAnchorInfo(element, containingFile)) != null) {
            return info;
        }
        TextRange elementRange = element.getTextRange();
        if (elementRange == null) {
            return new HardElementInfo(element);
        }
        Identikit.ByType identikit = Identikit.fromPsi(element, LanguageUtil.getRootLanguage(element));
        if (elementRange.isEmpty() && identikit.findPsiElement(containingFile, elementRange.getStartOffset(), elementRange.getEndOffset()) != element) {
            return new HardElementInfo(element);
        }
        ProperTextRange proper = ProperTextRange.create((Segment)elementRange);
        return new SelfElementInfo(proper, identikit, containingFile, forInjected);
    }

    @Nullable
    private static SmartPointerElementInfo createAnchorInfo(@NotNull PsiElement element, @NotNull PsiFile containingFile) {
        StubBasedPsiElement stubPsi;
        int stubId;
        IStubFileElementType stubType;
        if (element instanceof StubBasedPsiElement && containingFile instanceof PsiFileImpl && (stubType = ((PsiFileImpl)containingFile).getElementTypeForStubBuilder()) != null && stubType.shouldBuildStubFor(containingFile.getViewProvider().getVirtualFile()) && (stubId = PsiAnchor.calcStubIndex(stubPsi = (StubBasedPsiElement)element)) != -1) {
            return new AnchorElementInfo(element, (PsiFileImpl)containingFile, stubId, stubPsi.getElementType());
        }
        Pair<Identikit.ByAnchor, PsiElement> pair = Identikit.withAnchor(element, LanguageUtil.getRootLanguage((PsiElement)containingFile));
        if (pair != null) {
            return new AnchorElementInfo((PsiElement)pair.second, containingFile, (Identikit.ByAnchor)pair.first);
        }
        return null;
    }

    @NotNull
    SmartPointerElementInfo getElementInfo() {
        return this.myElementInfo;
    }

    static boolean pointsToTheSameElementAs(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == pointer2) {
            return true;
        }
        if (pointer1 instanceof SmartPsiElementPointerImpl && pointer2 instanceof SmartPsiElementPointerImpl) {
            SmartPointerElementInfo elementInfo2;
            SmartPsiElementPointerImpl impl1 = (SmartPsiElementPointerImpl)pointer1;
            SmartPsiElementPointerImpl impl2 = (SmartPsiElementPointerImpl)pointer2;
            SmartPointerElementInfo elementInfo1 = impl1.getElementInfo();
            if (!elementInfo1.pointsToTheSameElementAs(elementInfo2 = impl2.getElementInfo(), ((SmartPsiElementPointerImpl)pointer1).myManager)) {
                return false;
            }
            Object cachedElement1 = impl1.getCachedElement();
            Object cachedElement2 = impl2.getCachedElement();
            return cachedElement1 == null || cachedElement2 == null || Comparing.equal(cachedElement1, cachedElement2);
        }
        return Comparing.equal((Object)pointer1.getElement(), (Object)pointer2.getElement());
    }

    synchronized int incrementAndGetReferenceCount(int delta) {
        if (this.myReferenceCount == 127) {
            return 127;
        }
        if (this.myReferenceCount == 0) {
            return -1;
        }
        this.myReferenceCount = (byte)(this.myReferenceCount + delta);
        return this.myReferenceCount;
    }

    public String toString() {
        return this.myElementInfo.toString();
    }
}

