/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.CommonClassNames;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringFactory;
import gnu.trove.TIntObjectHashMap;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharTableImpl
implements CharTable {
    private static final int INTERN_THRESHOLD = 40;
    private static final StringHashToCharSequencesMap STATIC_ENTRIES = CharTableImpl.newStaticSet();
    private final StringHashToCharSequencesMap entries = new StringHashToCharSequencesMap(10, 0.9f);

    @NotNull
    public CharSequence intern(@NotNull CharSequence text) {
        return text.length() > 40 ? CharTableImpl.createSequence(text) : this.doIntern(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CharSequence doIntern(@NotNull CharSequence text, int startOffset, int endOffset) {
        int hashCode = CharTableImpl.subSequenceHashCode(text, startOffset, endOffset);
        CharSequence interned = CharTableImpl.STATIC_ENTRIES.getSubSequenceWithHashCode(hashCode, text, startOffset, endOffset);
        if (interned != null) {
            return interned;
        }
        StringHashToCharSequencesMap stringHashToCharSequencesMap = this.entries;
        synchronized (stringHashToCharSequencesMap) {
            return this.entries.getOrAddSubSequenceWithHashCode(hashCode, text, startOffset, endOffset);
        }
    }

    @NotNull
    public CharSequence doIntern(@NotNull CharSequence text) {
        return this.doIntern(text, 0, text.length());
    }

    @NotNull
    public CharSequence intern(@NotNull CharSequence baseText, int startOffset, int endOffset) {
        CharSequence result2 = endOffset - startOffset == baseText.length() ? this.intern(baseText) : (endOffset - startOffset > 40 ? CharTableImpl.createSequence(baseText, startOffset, endOffset) : this.doIntern(baseText, startOffset, endOffset));
        return result2;
    }

    @NotNull
    private static String createSequence(@NotNull CharSequence text) {
        return CharTableImpl.createSequence(text, 0, text.length());
    }

    @NotNull
    private static String createSequence(@NotNull CharSequence text, int startOffset, int endOffset) {
        if (text instanceof String) {
            return ((String)text).substring(startOffset, endOffset);
        }
        char[] buf = new char[endOffset - startOffset];
        CharArrayUtil.getChars((CharSequence)text, (char[])buf, (int)startOffset, (int)0, (int)buf.length);
        return StringFactory.createShared((char[])buf);
    }

    @Nullable
    public static CharSequence getStaticInterned(@NotNull CharSequence text) {
        return CharTableImpl.STATIC_ENTRIES.get(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void staticIntern(@NotNull String text) {
        StringHashToCharSequencesMap stringHashToCharSequencesMap = STATIC_ENTRIES;
        synchronized (stringHashToCharSequencesMap) {
            CharTableImpl.STATIC_ENTRIES.add(text);
        }
    }

    @NotNull
    private static StringHashToCharSequencesMap newStaticSet() {
        StringHashToCharSequencesMap r = new StringHashToCharSequencesMap(10, 0.9f);
        r.add("==");
        r.add("!=");
        r.add("||");
        r.add("++");
        r.add("--");
        r.add("<");
        r.add("<=");
        r.add("<<=");
        r.add("<<");
        r.add(">");
        r.add("&");
        r.add("&&");
        r.add("+=");
        r.add("-=");
        r.add("*=");
        r.add("/=");
        r.add("&=");
        r.add("|=");
        r.add("^=");
        r.add("%=");
        r.add("(");
        r.add(")");
        r.add("{");
        r.add("}");
        r.add("[");
        r.add("]");
        r.add(";");
        r.add(",");
        r.add("...");
        r.add(".");
        r.add("=");
        r.add("!");
        r.add("~");
        r.add("?");
        r.add(":");
        r.add("+");
        r.add("-");
        r.add("*");
        r.add("/");
        r.add("|");
        r.add("^");
        r.add("%");
        r.add("@");
        r.add(" ");
        r.add("  ");
        r.add("   ");
        r.add("    ");
        r.add("     ");
        r.add("      ");
        r.add("       ");
        r.add("        ");
        r.add("         ");
        r.add("          ");
        r.add("           ");
        r.add("            ");
        r.add("             ");
        r.add("              ");
        r.add("               ");
        r.add("\n");
        r.add("\n  ");
        r.add("\n    ");
        r.add("\n      ");
        r.add("\n        ");
        r.add("\n          ");
        r.add("\n            ");
        r.add("\n              ");
        r.add("\n                ");
        r.add("<");
        r.add(">");
        r.add("</");
        r.add("/>");
        r.add("\"");
        r.add("'");
        r.add("<![CDATA[");
        r.add("]]>");
        r.add("<!--");
        r.add("-->");
        r.add("<!DOCTYPE");
        r.add("SYSTEM");
        r.add("PUBLIC");
        r.add("<?");
        r.add("?>");
        r.add("<%");
        r.add("%>");
        r.add("<%=");
        r.add("<%@");
        r.add("${");
        r.add("");
        return r;
    }

    public static void addStringsFromClassToStatics(@NotNull Class aClass) {
        for (Field field : aClass.getDeclaredFields()) {
            String typeName;
            if ((field.getModifiers() & 8) == 0 || (field.getModifiers() & 1) == 0 || !String.class.equals(field.getType()) || (typeName = (String)ReflectionUtil.getStaticFieldValue((Class)aClass, String.class, (String)field.getName())) == null) continue;
            CharTableImpl.staticIntern(typeName);
        }
    }

    private static int subSequenceHashCode(@NotNull CharSequence sequence, int startOffset, int endOffset) {
        if (startOffset == 0 && endOffset == sequence.length()) {
            return StringUtil.stringHashCode((CharSequence)sequence);
        }
        return StringUtil.stringHashCode((CharSequence)sequence, (int)startOffset, (int)endOffset);
    }

    static {
        CharTableImpl.addStringsFromClassToStatics(CommonClassNames.class);
    }

    private static class StringHashToCharSequencesMap
    extends TIntObjectHashMap<Object> {
        private StringHashToCharSequencesMap(int capacity, float loadFactor) {
            super(capacity, loadFactor);
        }

        private CharSequence get(@NotNull CharSequence sequence, int startOffset, int endOffset) {
            return this.getSubSequenceWithHashCode(CharTableImpl.subSequenceHashCode(sequence, startOffset, endOffset), sequence, startOffset, endOffset);
        }

        private CharSequence getSubSequenceWithHashCode(int hashCode, @NotNull CharSequence sequence, int startOffset, int endOffset) {
            Object o = this.get(hashCode);
            if (o == null) {
                return null;
            }
            if (o instanceof CharSequence) {
                if (StringHashToCharSequencesMap.charSequenceSubSequenceEquals((CharSequence)o, sequence, startOffset, endOffset)) {
                    return (CharSequence)o;
                }
                return null;
            }
            if (o instanceof CharSequence[]) {
                for (CharSequence cs : (CharSequence[])o) {
                    if (!StringHashToCharSequencesMap.charSequenceSubSequenceEquals(cs, sequence, startOffset, endOffset)) continue;
                    return cs;
                }
                return null;
            }
            assert (false) : o.getClass();
            return null;
        }

        private static boolean charSequenceSubSequenceEquals(@NotNull CharSequence cs, @NotNull CharSequence baseSequence, int startOffset, int endOffset) {
            if (cs.length() != endOffset - startOffset) {
                return false;
            }
            if (cs == baseSequence && startOffset == 0) {
                return true;
            }
            int len = cs.length();
            for (int i = 0; i < len; ++i) {
                if (cs.charAt(i) == baseSequence.charAt(startOffset + i)) continue;
                return false;
            }
            return true;
        }

        private CharSequence get(@NotNull CharSequence sequence) {
            return this.get(sequence, 0, sequence.length());
        }

        @NotNull
        private CharSequence add(@NotNull CharSequence sequence) {
            return this.add(sequence, 0, sequence.length());
        }

        @NotNull
        private CharSequence add(CharSequence sequence, int startOffset, int endOffset) {
            int hashCode = CharTableImpl.subSequenceHashCode(sequence, startOffset, endOffset);
            return this.getOrAddSubSequenceWithHashCode(hashCode, sequence, startOffset, endOffset);
        }

        @NotNull
        private CharSequence getOrAddSubSequenceWithHashCode(int hashCode, @NotNull CharSequence sequence, int startOffset, int endOffset) {
            String addedSequence;
            int index = this.index(hashCode);
            if (index < 0) {
                addedSequence = CharTableImpl.createSequence(sequence, startOffset, endOffset);
                this.put(hashCode, addedSequence);
            } else {
                Object value = this._values[index];
                if (value instanceof CharSequence) {
                    CharSequence existingSequence = (CharSequence)value;
                    if (StringHashToCharSequencesMap.charSequenceSubSequenceEquals(existingSequence, sequence, startOffset, endOffset)) {
                        return existingSequence;
                    }
                    addedSequence = CharTableImpl.createSequence(sequence, startOffset, endOffset);
                    this.put(hashCode, new CharSequence[]{existingSequence, addedSequence});
                } else if (value instanceof CharSequence[]) {
                    Object[] existingSequenceArray;
                    for (CharSequence charSequence : existingSequenceArray = (CharSequence[])value) {
                        if (!StringHashToCharSequencesMap.charSequenceSubSequenceEquals(charSequence, sequence, startOffset, endOffset)) continue;
                        return charSequence;
                    }
                    addedSequence = CharTableImpl.createSequence(sequence, startOffset, endOffset);
                    CharSequence[] newSequenceArray = (CharSequence[])ArrayUtil.append((Object[])existingSequenceArray, (Object)addedSequence, CharSequence[]::new);
                    this.put(hashCode, newSequenceArray);
                } else {
                    assert (false) : value.getClass();
                    return null;
                }
            }
            return addedSequence;
        }
    }
}

