/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.source.FileTrees;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.AstSpine;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.ReadOnlyLightVirtualFile;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PatchedWeakReference;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.text.CharArrayUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiFileImpl
extends ElementBase
implements PsiFileEx,
PsiFileWithStubSupport,
Queryable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiFileImpl");
    static final String STUB_PSI_MISMATCH = "stub-psi mismatch";
    private static final AtomicFieldUpdater<PsiFileImpl, FileTrees> ourTreeUpdater = AtomicFieldUpdater.forFieldOfType(PsiFileImpl.class, FileTrees.class);
    private IElementType myElementType;
    protected IElementType myContentElementType;
    private long myModificationStamp;
    protected PsiFile myOriginalFile;
    private final AbstractFileViewProvider myViewProvider;
    private volatile FileTrees myTrees = FileTrees.noStub(null, this);
    private volatile boolean myPossiblyInvalidated;
    protected final PsiManagerEx myManager;
    public static final Key<Boolean> BUILDING_STUB = new Key("Don't use stubs mark!");
    private final PsiLock myPsiLock;
    private volatile boolean myLoadingAst;
    private static final Comparator<PsiFile> FILE_BY_LANGUAGE_ID = Comparator.comparing(o -> o.getLanguage().getID());

    protected PsiFileImpl(@NotNull IElementType elementType, IElementType contentElementType, @NotNull FileViewProvider provider) {
        this(provider);
        this.init(elementType, contentElementType);
    }

    protected PsiFileImpl(@NotNull FileViewProvider provider) {
        this.myManager = (PsiManagerEx)provider.getManager();
        this.myViewProvider = (AbstractFileViewProvider)provider;
        this.myPsiLock = this.myViewProvider.getFilePsiLock();
    }

    public void setContentElementType(IElementType contentElementType) {
        LOG.assertTrue(contentElementType instanceof ILazyParseableElementType, (Object)contentElementType);
        this.myContentElementType = contentElementType;
    }

    public IElementType getContentElementType() {
        return this.myContentElementType;
    }

    protected void init(@NotNull IElementType elementType, IElementType contentElementType) {
        this.myElementType = elementType;
        this.setContentElementType(contentElementType);
    }

    public TreeElement createContentLeafElement(CharSequence leafText) {
        if (this.myContentElementType instanceof ILazyParseableElementType) {
            return ASTFactory.lazy((ILazyParseableElementType)this.myContentElementType, leafText);
        }
        return ASTFactory.leaf(this.myContentElementType, leafText);
    }

    public boolean isDirectory() {
        return false;
    }

    @Nullable
    public FileElement getTreeElement() {
        FileElement node = this.derefTreeElement();
        if (node != null) {
            return node;
        }
        if (!this.getViewProvider().isPhysical()) {
            return this.loadTreeElement();
        }
        return null;
    }

    FileElement derefTreeElement() {
        return this.myTrees.derefTreeElement();
    }

    public VirtualFile getVirtualFile() {
        return this.getViewProvider().isEventSystemEnabled() ? this.getViewProvider().getVirtualFile() : null;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        return true;
    }

    public boolean isValid() {
        if (this.myManager.getProject().isDisposed()) {
            return false;
        }
        if (!this.myViewProvider.getVirtualFile().isValid()) {
            return false;
        }
        if (!this.myPossiblyInvalidated) {
            return true;
        }
        if (((FileManagerImpl)this.myManager.getFileManager()).evaluateValidity(this)) {
            this.myPossiblyInvalidated = false;
            PsiInvalidElementAccessException.setInvalidationTrace((UserDataHolder)this, null);
            return true;
        }
        return false;
    }

    @Override
    public final void markInvalidated() {
        this.myPossiblyInvalidated = true;
        DebugUtil.onInvalidated((PsiElement)this);
    }

    @Override
    public boolean isContentsLoaded() {
        return this.derefTreeElement() != null;
    }

    protected void assertReadAccessAllowed() {
        if (this.myViewProvider.getVirtualFile() instanceof ReadOnlyLightVirtualFile) {
            return;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private FileElement loadTreeElement() {
        FileViewProvider viewProvider;
        this.assertReadAccessAllowed();
        if (this.myPossiblyInvalidated) {
            PsiUtilCore.ensureValid((PsiElement)this);
        }
        if ((viewProvider = this.getViewProvider()).isPhysical()) {
            VirtualFile vFile = viewProvider.getVirtualFile();
            AstLoadingFilter.assertTreeLoadingAllowed((VirtualFile)vFile);
            if (this.myManager.isAssertOnFileLoading(vFile)) {
                LOG.error("Access to tree elements not allowed. path='" + vFile.getPresentableUrl() + "'");
            }
        }
        PsiLock psiLock = this.myPsiLock;
        synchronized (psiLock) {
            FileElement treeElement = this.derefTreeElement();
            if (treeElement != null) {
                return treeElement;
            }
            treeElement = this.createFileElement(viewProvider.getContents());
            treeElement.setPsi((PsiElement)this);
            this.myLoadingAst = true;
            try {
                this.updateTrees(this.myTrees.withAst(this.createTreeElementPointer(treeElement)));
            }
            finally {
                this.myLoadingAst = false;
            }
            if (LOG.isDebugEnabled() && viewProvider.isPhysical()) {
                LOG.debug("Loaded text for file " + viewProvider.getVirtualFile().getPresentableUrl());
            }
            return treeElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public StubbedSpine getStubbedSpine() {
        StubTree tree = this.getGreenStubTree();
        if (tree != null) {
            return tree.getSpine();
        }
        AstSpine astSpine = this.calcTreeElement().getStubbedSpine();
        if (!this.myTrees.useSpineRefs()) {
            PsiLock psiLock = this.myPsiLock;
            synchronized (psiLock) {
                this.updateTrees(this.myTrees.switchToSpineRefs(FileTrees.getAllSpinePsi(astSpine)));
            }
        }
        return astSpine;
    }

    @Nullable
    public IStubFileElementType getElementTypeForStubBuilder() {
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.getLanguage());
        IFileElementType type = definition == null ? null : definition.getFileNodeType();
        return type instanceof IStubFileElementType ? (IStubFileElementType)type : null;
    }

    @NotNull
    protected FileElement createFileElement(CharSequence docText) {
        FileElement treeElement;
        TreeElement contentLeaf = this.createContentLeafElement(docText);
        if (contentLeaf instanceof FileElement) {
            treeElement = (FileElement)contentLeaf;
        } else {
            CompositeElement xxx = ASTFactory.composite(this.myElementType);
            assert (xxx instanceof FileElement) : "BUMM";
            treeElement = (FileElement)xxx;
            treeElement.rawAddChildrenWithoutNotifications(contentLeaf);
        }
        return treeElement;
    }

    public void clearCaches() {
        ++this.myModificationStamp;
    }

    public String getText() {
        FileElement tree = this.derefTreeElement();
        if (!this.isValid()) {
            ProgressManager.checkCanceled();
            if (tree != null) {
                return tree.getText();
            }
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        String string = this.getViewProvider().getContents().toString();
        if (tree != null && string.length() != tree.getTextLength()) {
            throw new AssertionError((Object)("File text mismatch: tree.length=" + tree.getTextLength() + "; psi.length=" + string.length() + "; this=" + this + "; vp=" + this.getViewProvider()));
        }
        return string;
    }

    public int getTextLength() {
        FileElement tree = this.derefTreeElement();
        if (tree != null) {
            return tree.getTextLength();
        }
        PsiUtilCore.ensureValid((PsiElement)this);
        return this.getViewProvider().getContents().length();
    }

    public TextRange getTextRange() {
        return new TextRange(0, this.getTextLength());
    }

    public PsiElement getNextSibling() {
        return SharedPsiElementImplUtil.getNextSibling((PsiElement)this);
    }

    public PsiElement getPrevSibling() {
        return SharedPsiElementImplUtil.getPrevSibling((PsiElement)this);
    }

    public long getModificationStamp() {
        PsiElement context = this.getContext();
        PsiFile contextFile = context == null || !context.isValid() ? null : context.getContainingFile();
        long contextStamp = contextFile == null ? 0L : contextFile.getModificationStamp();
        return this.myModificationStamp + contextStamp;
    }

    public void subtreeChanged() {
        this.doClearCaches("subtreeChanged");
        this.getViewProvider().rootChanged((PsiFile)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClearCaches(String reason) {
        FileElement tree = this.getTreeElement();
        if (tree != null) {
            tree.clearCaches();
        }
        PsiLock psiLock = this.myPsiLock;
        synchronized (psiLock) {
            this.updateTrees(this.myTrees.clearStub(reason));
        }
        this.clearCaches();
    }

    protected PsiFileImpl clone() {
        FileViewProvider viewProvider = this.getViewProvider();
        FileViewProvider providerCopy = viewProvider.clone();
        Language language = this.getLanguage();
        if (providerCopy == null) {
            throw new AssertionError((Object)("Unable to clone the view provider: " + viewProvider + "; " + language));
        }
        PsiFileImpl clone = BlockSupportImpl.getFileCopy(this, providerCopy);
        this.copyCopyableDataTo((UserDataHolderBase)clone);
        if (this.getTreeElement() != null) {
            FileElement treeClone = (FileElement)this.calcTreeElement().clone();
            clone.setTreeElementPointer(treeClone);
            treeClone.setPsi((PsiElement)clone);
        } else {
            clone.setTreeElementPointer(null);
        }
        if (viewProvider.isEventSystemEnabled()) {
            clone.myOriginalFile = this;
        } else if (this.myOriginalFile != null) {
            clone.myOriginalFile = this.myOriginalFile;
        }
        FileManagerImpl.clearPsiCaches(providerCopy);
        return clone;
    }

    @NotNull
    public String getName() {
        return this.getViewProvider().getVirtualFile().getName();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        this.checkSetName(name);
        return PsiFileImplUtil.setName(this, name);
    }

    public void checkSetName(String name) {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            return;
        }
        PsiFileImplUtil.checkSetName(this, name);
    }

    public boolean isWritable() {
        return this.getViewProvider().getVirtualFile().isWritable();
    }

    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    @Nullable
    public PsiDirectory getContainingDirectory() {
        VirtualFile file2 = this.getViewProvider().getVirtualFile();
        VirtualFile parentFile = file2.getParent();
        if (parentFile == null) {
            return null;
        }
        if (!parentFile.isValid()) {
            LOG.error("Invalid parent: " + parentFile + " of file " + file2 + ", file.valid=" + file2.isValid());
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @NotNull
    public PsiFile getContainingFile() {
        return this;
    }

    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        PsiFileImplUtil.doDelete(this);
    }

    public void checkDelete() throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            throw new IncorrectOperationException();
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    @NotNull
    public PsiFile getOriginalFile() {
        return this.myOriginalFile == null ? this : this.myOriginalFile;
    }

    public void setOriginalFile(@NotNull PsiFile originalFile) {
        this.myOriginalFile = originalFile.getOriginalFile();
        FileViewProvider original = this.myOriginalFile.getViewProvider();
        ((AbstractFileViewProvider)original).registerAsCopy(this.myViewProvider);
    }

    @NotNull
    public PsiFile[] getPsiRoots() {
        FileViewProvider viewProvider = this.getViewProvider();
        Set languages = viewProvider.getLanguages();
        PsiFile[] roots = new PsiFile[languages.size()];
        int i = 0;
        for (Language language : languages) {
            PsiFile psi = viewProvider.getPsi(language);
            if (psi == null) {
                LOG.error("PSI is null for " + language + "; in file: " + this);
            }
            roots[i++] = psi;
        }
        if (roots.length > 1) {
            Arrays.sort(roots, FILE_BY_LANGUAGE_ID);
        }
        return roots;
    }

    public boolean isPhysical() {
        return this.getViewProvider().isEventSystemEnabled();
    }

    @NotNull
    public Language getLanguage() {
        return this.myElementType.getLanguage();
    }

    @Nullable
    public IFileElementType getFileElementType() {
        return this.myElementType instanceof IFileElementType ? (IFileElementType)this.myElementType : (IFileElementType)ObjectUtils.tryCast((Object)this.myContentElementType, IFileElementType.class);
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        return this.myViewProvider;
    }

    public void setTreeElementPointer(@Nullable FileElement element) {
        this.updateTrees(FileTrees.noStub(element, this));
    }

    public PsiElement findElementAt(int offset) {
        return this.getViewProvider().findElementAt(offset);
    }

    public PsiReference findReferenceAt(int offset) {
        return this.getViewProvider().findReferenceAt(offset);
    }

    @NotNull
    public char[] textToCharArray() {
        return CharArrayUtil.fromSequence((CharSequence)this.getViewProvider().getContents());
    }

    @NotNull
    public <T> T[] findChildrenByClass(Class<T> aClass) {
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement child2 : this.getChildren()) {
            if (!aClass.isInstance(child2)) continue;
            result2.add(child2);
        }
        return result2.toArray((Object[])Array.newInstance(aClass, result2.size()));
    }

    @Nullable
    public <T> T findChildByClass(Class<T> aClass) {
        for (PsiElement child2 : this.getChildren()) {
            if (!aClass.isInstance(child2)) continue;
            return (T)child2;
        }
        return null;
    }

    public boolean isTemplateDataFile() {
        return false;
    }

    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    public void onContentReload() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.clearContent("onContentReload");
    }

    final void clearContent(String reason) {
        DebugUtil.performPsiModification(reason, () -> {
            PsiLock psiLock = this.myPsiLock;
            synchronized (psiLock) {
                FileElement treeElement = this.derefTreeElement();
                if (treeElement != null) {
                    treeElement.detachFromFile();
                    DebugUtil.onInvalidated(treeElement);
                }
                this.updateTrees(this.myTrees.clearStub(reason));
                this.setTreeElementPointer(null);
            }
        });
        this.clearCaches();
    }

    @Nullable
    public StubElement getStub() {
        StubTree stubHolder = this.getStubTree();
        return stubHolder != null ? stubHolder.getRoot() : null;
    }

    @Nullable
    public final StubElement getGreenStub() {
        StubTree stubHolder = this.getGreenStubTree();
        return stubHolder != null ? stubHolder.getRoot() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public StubTree getStubTree() {
        this.assertReadAccessAllowed();
        if (this.getTreeElement() != null) {
            return null;
        }
        StubTree derefd = this.derefStub();
        if (derefd != null) {
            return derefd;
        }
        if (Boolean.TRUE.equals(this.getUserData(BUILDING_STUB)) || this.myLoadingAst || this.getElementTypeForStubBuilder() == null) {
            return null;
        }
        VirtualFile vFile = this.getVirtualFile();
        if (!(vFile instanceof VirtualFileWithId) || !vFile.isValid()) {
            return null;
        }
        ObjectStubTree tree = StubTreeLoader.getInstance().readOrBuild(this.getProject(), vFile, this);
        if (!(tree instanceof StubTree)) {
            return null;
        }
        FileViewProvider viewProvider = this.getViewProvider();
        List<Pair<IStubFileElementType, PsiFile>> roots = StubTreeBuilder.getStubbedRoots(viewProvider);
        PsiLock psiLock = this.myPsiLock;
        synchronized (psiLock) {
            if (this.getTreeElement() != null) {
                return null;
            }
            StubTree derefdOnLock = this.derefStub();
            if (derefdOnLock != null) {
                return derefdOnLock;
            }
            PsiFileStubImpl baseRoot = (PsiFileStubImpl)((StubTree)tree).getRoot();
            if (!baseRoot.rootsAreSet()) {
                LOG.error("Stub roots must be set when stub tree was read or built with StubTreeLoader");
                return null;
            }
            Object[] stubRoots = baseRoot.getStubRoots();
            if (stubRoots.length != roots.size()) {
                Function stubToString = stub -> "{" + stub.getClass().getSimpleName() + " " + stub.getType().getLanguage() + "}";
                LOG.error("readOrBuilt roots = " + StringUtil.join((Object[])stubRoots, (Function)stubToString, (String)", ") + "; " + StubTreeLoader.getFileViewProviderMismatchDiagnostics(viewProvider));
                this.rebuildStub();
                return null;
            }
            StubTree result2 = null;
            for (int i = 0; i < roots.size(); ++i) {
                PsiFileImpl eachPsiRoot = (PsiFileImpl)roots.get((int)i).second;
                if (eachPsiRoot.derefStub() != null) continue;
                StubTree stubTree = eachPsiRoot.setStubTree((PsiFileStub)stubRoots[i]);
                if (eachPsiRoot != this) continue;
                result2 = stubTree;
            }
            assert (result2 != null) : "Current file not in root list: " + roots + ", vp=" + viewProvider;
            return result2;
        }
    }

    @NotNull
    private StubTree setStubTree(PsiFileStub root) {
        ((StubBase)root).setPsi((PsiElement)this);
        StubTree stubTree = new StubTree(root);
        FileElement fileElement = this.getTreeElement();
        stubTree.setDebugInfo("created in getStubTree(), with AST = " + (fileElement != null));
        this.updateTrees(this.myTrees.withStub(stubTree, fileElement));
        return stubTree;
    }

    @Nullable
    @VisibleForTesting
    public StubTree derefStub() {
        return this.myTrees.derefStub();
    }

    private void updateTrees(@NotNull FileTrees trees) {
        if (!ourTreeUpdater.compareAndSet((Object)this, (Object)this.myTrees, (Object)trees)) {
            LOG.error("Non-atomic trees update");
            this.myTrees = trees;
        }
    }

    protected PsiFileImpl cloneImpl(FileElement treeElementClone) {
        PsiFileImpl clone = (PsiFileImpl)super.clone();
        clone.setTreeElementPointer(treeElementClone);
        treeElementClone.setPsi((PsiElement)clone);
        return clone;
    }

    private boolean isKeepTreeElementByHardReference() {
        return !this.getViewProvider().isEventSystemEnabled();
    }

    @NotNull
    private Getter<FileElement> createTreeElementPointer(@NotNull FileElement treeElement) {
        if (this.isKeepTreeElementByHardReference()) {
            return treeElement;
        }
        return this.myManager.isBatchFilesProcessingMode() ? new PatchedWeakReference<FileElement>(treeElement) : new SoftReference((Object)treeElement);
    }

    public final PsiManager getManager() {
        return this.myManager;
    }

    public PsiElement getNavigationElement() {
        return this;
    }

    public PsiElement getOriginalElement() {
        return this.getOriginalFile();
    }

    @NotNull
    public final FileElement calcTreeElement() {
        FileElement treeElement = this.getTreeElement();
        return treeElement != null ? treeElement : this.loadTreeElement();
    }

    @NotNull
    public PsiElement[] getChildren() {
        return this.calcTreeElement().getChildrenAsPsiElements(null, PsiElement.ARRAY_FACTORY);
    }

    public PsiElement getFirstChild() {
        return SharedImplUtil.getFirstChild((ASTNode)this.getNode());
    }

    public PsiElement getLastChild() {
        return SharedImplUtil.getLastChild((ASTNode)this.getNode());
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        SharedImplUtil.acceptChildren(visitor, (ASTNode)this.getNode());
    }

    public int getStartOffsetInParent() {
        return this.calcTreeElement().getStartOffsetInParent();
    }

    public int getTextOffset() {
        return this.calcTreeElement().getTextOffset();
    }

    public boolean textMatches(@NotNull CharSequence text) {
        return this.calcTreeElement().textMatches(text);
    }

    public boolean textMatches(@NotNull PsiElement element) {
        return this.calcTreeElement().textMatches(element);
    }

    public boolean textContains(char c) {
        return this.calcTreeElement().textContains(c);
    }

    public final PsiElement copy() {
        return this.clone();
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, null, null);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.TRUE);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.FALSE);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public final void checkAdd(@NotNull PsiElement element) {
        CheckUtil.checkWritable((PsiElement)this);
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange((PsiElement)this, first, last, null, null);
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        return SharedImplUtil.addRange((PsiElement)this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.TRUE);
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        return SharedImplUtil.addRange((PsiElement)this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.FALSE);
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        if (first == null) {
            LOG.assertTrue(last == null);
            return;
        }
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last);
        FileElement treeElement = this.calcTreeElement();
        LOG.assertTrue(firstElement.getTreeParent() == treeElement);
        LOG.assertTrue(lastElement.getTreeParent() == treeElement);
        CodeEditUtil.removeChildren(treeElement, firstElement, lastElement);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        FileElement treeElement = this.calcTreeElement();
        return SharedImplUtil.doReplace((PsiElement)this, treeElement, newElement);
    }

    public PsiReference getReference() {
        return null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        return SharedPsiElementImplUtil.getReferences((PsiElement)this);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        return true;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        return ResolveScopeManager.getElementResolveScope((PsiElement)this);
    }

    @NotNull
    public SearchScope getUseScope() {
        return ResolveScopeManager.getElementUseScope((PsiElement)this);
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return PsiFileImpl.this.getName();
            }

            public String getLocationString() {
                PsiDirectory psiDirectory = PsiFileImpl.this.getParent();
                if (psiDirectory != null) {
                    return psiDirectory.getVirtualFile().getPresentableUrl();
                }
                return null;
            }

            public Icon getIcon(boolean open2) {
                return PsiFileImpl.this.getIcon(0);
            }
        };
    }

    public void navigate(boolean requestFocus) {
        assert (this.canNavigate()) : this;
        PsiNavigationSupport.getInstance().getDescriptor((PsiElement)this).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate((PsiElement)this);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public final Project getProject() {
        return this.getManager().getProject();
    }

    @NotNull
    public FileASTNode getNode() {
        return this.calcTreeElement();
    }

    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }

    @Nullable
    public final StubTree getGreenStubTree() {
        StubTree result2 = this.derefStub();
        return result2 != null ? result2 : this.getStubTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public StubTree calcStubTree() {
        StubTree tree = this.derefStub();
        if (tree != null) {
            return tree;
        }
        FileElement fileElement = this.calcTreeElement();
        PsiLock psiLock = this.myPsiLock;
        synchronized (psiLock) {
            tree = this.derefStub();
            if (tree == null) {
                this.assertReadAccessAllowed();
                IStubFileElementType contentElementType = this.getElementTypeForStubBuilder();
                if (contentElementType == null) {
                    VirtualFile vFile = this.getVirtualFile();
                    String message = "ContentElementType: " + this.getContentElementType() + "; file: " + this + "\n\tBoolean.TRUE.equals(getUserData(BUILDING_STUB)) = " + Boolean.TRUE.equals(this.getUserData(BUILDING_STUB)) + "\n\tgetTreeElement() = " + this.getTreeElement() + "\n\tvFile instanceof VirtualFileWithId = " + (vFile instanceof VirtualFileWithId) + "\n\tStubUpdatingIndex.canHaveStub(vFile) = " + StubTreeLoader.getInstance().canHaveStub(vFile);
                    this.rebuildStub();
                    throw new AssertionError((Object)message);
                }
                StubElement currentStubTree = contentElementType.getBuilder().buildStubTree((PsiFile)this);
                if (currentStubTree == null) {
                    throw new AssertionError((Object)("Stub tree wasn't built for " + (Object)((Object)contentElementType) + "; file: " + this));
                }
                tree = new StubTree((PsiFileStub)currentStubTree);
                tree.setDebugInfo("created in calcStubTree");
                this.updateTrees(this.myTrees.withStub(tree, fileElement));
            }
            return tree;
        }
    }

    final void rebuildStub() {
        ApplicationManager.getApplication().invokeLater(() -> {
            VirtualFile vFile;
            if (!this.myManager.isDisposed()) {
                this.myManager.dropPsiCaches();
            }
            if ((vFile = this.getVirtualFile()) != null && vFile.isValid()) {
                Document doc = FileDocumentManager.getInstance().getCachedDocument(vFile);
                if (doc != null) {
                    FileDocumentManager.getInstance().saveDocument(doc);
                }
                FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{vFile});
                StubTreeLoader.getInstance().rebuildStubTree(vFile);
            }
        }, ModalityState.NON_MODAL);
    }

    public void putInfo(@NotNull Map<String, String> info) {
        PsiFileImpl.putInfo(this, info);
    }

    public static void putInfo(@NotNull PsiFile psiFile, @NotNull Map<String, String> info) {
        info.put("fileName", psiFile.getName());
        info.put("fileType", psiFile.getFileType().toString());
    }

    public String toString() {
        return this.myElementType.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void beforeAstChange() {
        this.checkWritable();
        PsiLock psiLock = this.myPsiLock;
        synchronized (psiLock) {
            FileTrees updated = this.myTrees.switchToStrongRefs();
            if (updated != this.myTrees) {
                this.updateTrees(updated);
            }
        }
    }

    private void checkWritable() {
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)this.getProject());
        if (docManager instanceof PsiDocumentManagerBase && !((PsiDocumentManagerBase)docManager).isCommitInProgress() && !(this.myViewProvider instanceof FreeThreadedFileViewProvider)) {
            CheckUtil.checkWritable((PsiElement)this);
        }
    }
}

