/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeStyleSchemesImpl
extends CodeStyleSchemes {
    @NonNls
    static final String CODE_STYLES_DIR_PATH = "codestyles";
    protected final SchemeManager<CodeStyleScheme> mySchemeManager;

    public CodeStyleSchemesImpl(@NotNull SchemeManagerFactory schemeManagerFactory) {
        this.mySchemeManager = schemeManagerFactory.create(CODE_STYLES_DIR_PATH, new LazySchemeProcessor<CodeStyleScheme, CodeStyleSchemeImpl>(){

            @Override
            @NotNull
            public CodeStyleSchemeImpl createScheme(@NotNull SchemeDataHolder<? super CodeStyleSchemeImpl> dataHolder, @NotNull String name, @NotNull Function<? super String, String> attributeProvider2, boolean isBundled) {
                return new CodeStyleSchemeImpl(attributeProvider2.apply("name"), attributeProvider2.apply("parent"), dataHolder);
            }
        });
        this.mySchemeManager.loadSchemes();
        this.setCurrentScheme(this.getDefaultScheme());
    }

    @Transient
    public CodeStyleScheme getCurrentScheme() {
        return this.mySchemeManager.getActiveScheme();
    }

    public void setCurrentScheme(CodeStyleScheme scheme2) {
        this.mySchemeManager.setCurrent(scheme2);
    }

    public CodeStyleScheme createNewScheme(String preferredName, CodeStyleScheme parentScheme) {
        return new CodeStyleSchemeImpl(SchemeNameGenerator.getUniqueName(preferredName, (Scheme)parentScheme, name -> this.mySchemeManager.findSchemeByName((String)name) != null), false, parentScheme);
    }

    public void deleteScheme(@NotNull CodeStyleScheme scheme2) {
        if (scheme2.isDefault()) {
            throw new IllegalArgumentException("Unable to delete default scheme!");
        }
        CodeStyleSchemeImpl currentScheme = (CodeStyleSchemeImpl)this.getCurrentScheme();
        if (currentScheme == scheme2) {
            CodeStyleScheme newCurrentScheme = this.getDefaultScheme();
            if (newCurrentScheme == null) {
                throw new IllegalStateException("Unable to load default scheme!");
            }
            this.setCurrentScheme(newCurrentScheme);
        }
        this.mySchemeManager.removeScheme(scheme2);
    }

    public CodeStyleScheme getDefaultScheme() {
        CodeStyleScheme defaultScheme = this.mySchemeManager.findSchemeByName("Default");
        if (defaultScheme == null) {
            defaultScheme = new CodeStyleSchemeImpl("Default", true, null);
            this.addScheme(defaultScheme);
        }
        return defaultScheme;
    }

    @Nullable
    public CodeStyleScheme findSchemeByName(@NotNull String name) {
        return this.mySchemeManager.findSchemeByName(name);
    }

    public void addScheme(@NotNull CodeStyleScheme scheme2) {
        this.mySchemeManager.addScheme(scheme2);
    }

    @NotNull
    public static SchemeManager<CodeStyleScheme> getSchemeManager() {
        return ((CodeStyleSchemesImpl)CodeStyleSchemes.getInstance()).mySchemeManager;
    }
}

