/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.annotations.NotNull;

public class IndentHelperImpl
extends IndentHelper {
    public static final int INDENT_FACTOR = 10000;
    public static final int TOO_BIG_WALK_THRESHOLD = 450;

    public int getIndent(@NotNull PsiFile file2, @NotNull ASTNode element) {
        return this.getIndent(file2, element, false);
    }

    public int getIndent(@NotNull PsiFile file2, @NotNull ASTNode element, boolean includeNonSpace) {
        return this.getIndentInner(file2, element, includeNonSpace, 0);
    }

    protected int getIndentInner(@NotNull PsiFile file2, @NotNull ASTNode element, boolean includeNonSpace, int recursionLevel) {
        if (recursionLevel > 450) {
            return 0;
        }
        if (element.getTreePrev() != null) {
            ASTNode parent;
            ASTNode prev2 = element.getTreePrev();
            while (prev2 instanceof CompositeElement && !TreeUtil.isStrongWhitespaceHolder(prev2.getElementType())) {
                ASTNode lastCompositePrev = prev2;
                if ((prev2 = prev2.getLastChildNode()) != null) continue;
                return this.getIndentInner(file2, lastCompositePrev, includeNonSpace, recursionLevel + 1);
            }
            String text = prev2.getText();
            int index = Math.max(text.lastIndexOf(10), text.lastIndexOf(13));
            if (index >= 0) {
                return IndentHelperImpl.getIndent(file2, text.substring(index + 1), includeNonSpace);
            }
            if (includeNonSpace) {
                return this.getIndentInner(file2, prev2, includeNonSpace, recursionLevel + 1) + IndentHelperImpl.getIndent(file2, text, includeNonSpace);
            }
            ASTNode child2 = prev2;
            for (parent = prev2.getTreeParent(); parent != null && child2.getTreePrev() == null; parent = parent.getTreeParent()) {
                child2 = parent;
            }
            if (parent == null) {
                return IndentHelperImpl.getIndent(file2, text, includeNonSpace);
            }
            return this.getIndentInner(file2, prev2, includeNonSpace, recursionLevel + 1);
        }
        if (element.getTreeParent() == null) {
            return 0;
        }
        return this.getIndentInner(file2, element.getTreeParent(), includeNonSpace, recursionLevel + 1);
    }

    @Deprecated
    public static String fillIndent(Project project, FileType fileType, int indent) {
        return IndentHelperImpl.fillIndent(CodeStyle.getProjectOrDefaultSettings((Project)project).getIndentOptions(fileType), indent);
    }

    public static String fillIndent(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions, int indent) {
        int indentLevel = (indent + 5000) / 10000;
        int spaceCount = indent - indentLevel * 10000;
        int indentLevelSize = indentLevel * indentOptions.INDENT_SIZE;
        int totalSize = indentLevelSize + spaceCount;
        StringBuilder buffer = new StringBuilder();
        if (indentOptions.USE_TAB_CHARACTER) {
            if (indentOptions.SMART_TABS) {
                int i;
                int tabCount = indentLevelSize / indentOptions.TAB_SIZE;
                int leftSpaces = indentLevelSize - tabCount * indentOptions.TAB_SIZE;
                for (i = 0; i < tabCount; ++i) {
                    buffer.append('\t');
                }
                for (i = 0; i < leftSpaces + spaceCount; ++i) {
                    buffer.append(' ');
                }
            } else {
                int size = totalSize;
                while (size > 0) {
                    if (size >= indentOptions.TAB_SIZE) {
                        buffer.append('\t');
                        size -= indentOptions.TAB_SIZE;
                        continue;
                    }
                    buffer.append(' ');
                    --size;
                }
            }
        } else {
            for (int i = 0; i < totalSize; ++i) {
                buffer.append(' ');
            }
        }
        return buffer.toString();
    }

    @Deprecated
    public static int getIndent(Project project, FileType fileType, String text, boolean includeNonSpace) {
        return IndentHelperImpl.getIndent(CodeStyle.getSettings((Project)project).getIndentOptions(fileType), text, includeNonSpace);
    }

    public static int getIndent(@NotNull PsiFile file2, String text, boolean includeNonSpace) {
        return IndentHelperImpl.getIndent(CodeStyle.getIndentOptions((PsiFile)file2), text, includeNonSpace);
    }

    public static int getIndent(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions, String text, boolean includeNonSpace) {
        char c;
        for (int i = text.length() - 1; i >= 0 && (c = text.charAt(i)) != '\n' && c != '\r'; --i) {
        }
        int spaceCount = 0;
        int tabCount = 0;
        for (int j = ++i; j < text.length(); ++j) {
            char c2 = text.charAt(j);
            if (c2 != '\t') {
                if (!includeNonSpace && c2 != ' ') break;
                ++spaceCount;
                continue;
            }
            ++tabCount;
        }
        if (tabCount == 0) {
            return spaceCount;
        }
        int tabSize = indentOptions.TAB_SIZE;
        int indentSize = indentOptions.INDENT_SIZE;
        if (indentSize <= 0) {
            indentSize = 1;
        }
        int indentLevel = tabCount * tabSize / indentSize;
        return indentLevel * 10000 + spaceCount;
    }
}

